/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.dto.GoodsStatisticalDTO;
import com.wmeimob.fastboot.bizvane.entity.ActivityRuleCombination;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.GoodsClassifyCustom;
import com.wmeimob.fastboot.bizvane.entity.GoodsPropValueCustom;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.entity.GoodsSpecRelation;
import com.wmeimob.fastboot.bizvane.entity.GoodsTagCustom;
import com.wmeimob.fastboot.bizvane.mapper.ActivityRuleCombinationMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsClassifyCustomMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsPropHeadCustomMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsPropValueCustomMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSkuDetailMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSpecRelationMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsTagCustomMapper;
import com.wmeimob.fastboot.bizvane.service.ActivityService;
import com.wmeimob.fastboot.bizvane.service.GoodsService;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.util.InputValidator;
import com.wmeimob.fastboot.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class GoodsServiceImpl
implements GoodsService {
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private GoodsTagCustomMapper goodsTagCustomMapper;
    @Autowired
    private GoodsClassifyCustomMapper goodsClassifyCustomMapper;
    @Autowired
    private GoodsPropValueCustomMapper goodsPropValueCustomMapper;
    @Autowired
    private GoodsSkuDetailMapper goodsSkuDetailMapper;
    @Autowired
    private GoodsSpecRelationMapper goodsSpecRelationMapper;
    @Autowired
    private GoodsPropHeadCustomMapper goodsPropHeadCustomMapper;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ActivityRuleCombinationMapper activityRuleCombinationMapper;

    public Goods add(Goods goods) {
        InputValidator.checkEmpty((Object)goods.getExpressTemplateId(), (String)"\u8fd0\u8d39\u6a21\u677f");
        InputValidator.checkEmpty((Object)goods.getCoverImg(), (String)"\u8be6\u60c5\u9875\u5546\u54c1\u56fe");
        InputValidator.checkEmpty((Object)goods.getBannerImgPaths(), (String)"\u5217\u8868\u9875\u5c55\u793a\u56fe");
        if (goods.getLimitation() != null) {
            InputValidator.checkNaturalNumber((Integer)goods.getLimitation(), (String)"\u9650\u8d2d\u6570\u91cf");
        }
        if (!StringUtils.isEmpty((Object)goods.getVideoPaths())) {
            InputValidator.checkEmpty((Object)goods.getVideoImg(), (String)"\u89c6\u9891\u5c01\u9762\u56fe");
        }
        Example example = new Example(Goods.class);
        example.createCriteria().andEqualTo("goodsNo", (Object)goods.getGoodsNo()).andEqualTo("merchantId", (Object)goods.getMerchantId()).andEqualTo("isDel", (Object)false);
        List goodsList = this.goodsMapper.selectByExample((Object)example);
        if (goodsList.size() > 0) {
            throw new CustomException("\u5546\u54c1\u7f16\u53f7\u91cd\u590d");
        }
        Date data = new Date();
        goods.setGmtCreate(data);
        goods.setIsShelved(Boolean.valueOf(false));
        this.goodsMapper.insertSelective((Object)goods);
        for (GoodsPropValueCustom gpvc : goods.getGoodsPropValueCustomList()) {
            gpvc.setGmtCreate(data);
            gpvc.setGoodsId(goods.getId());
        }
        for (GoodsClassifyCustom gcc : goods.getGoodsClassifyCustomList()) {
            gcc.setGmtCreate(data);
            gcc.setGoodsId(goods.getId());
        }
        for (GoodsTagCustom gtc : goods.getGoodsTagCustomList()) {
            gtc.setGmtCreate(data);
            gtc.setGoodsId(goods.getId());
        }
        if (goods.getGoodsPropValueCustomList().size() > 0) {
            this.goodsPropValueCustomMapper.insertList(goods.getGoodsPropValueCustomList());
        }
        if (goods.getGoodsClassifyCustomList().size() > 0) {
            this.goodsClassifyCustomMapper.insertList(goods.getGoodsClassifyCustomList());
        }
        if (goods.getGoodsTagCustomList().size() > 0) {
            this.goodsTagCustomMapper.insertList(goods.getGoodsTagCustomList());
        }
        return goods;
    }

    public int update(Goods goods) {
        int i;
        Example example;
        if (goods.getLimitation() != null) {
            InputValidator.checkNaturalNumber((Integer)goods.getLimitation(), (String)"\u9650\u8d2d\u6570\u91cf");
        }
        Date date = new Date();
        goods.setGmtModified(date);
        if (goods.getVideoDelete() != null && goods.getVideoDelete().booleanValue()) {
            goods.setVideoImg("");
            goods.setVideoPaths("");
        }
        if (goods.getGoodsPropValueCustomList() != null) {
            for (GoodsPropValueCustom gpvc : goods.getGoodsPropValueCustomList()) {
                if (gpvc.getId() == null) {
                    gpvc.setGmtCreate(date);
                    gpvc.setGoodsId(goods.getId());
                    this.goodsPropValueCustomMapper.insertSelective((Object)gpvc);
                }
                if (gpvc.getIsDelete() == null || !gpvc.getIsDelete().booleanValue()) continue;
                this.goodsPropValueCustomMapper.deleteByPrimaryKey((Object)gpvc);
            }
        }
        if (goods.getGoodsClassifyCustomList() != null) {
            for (GoodsClassifyCustom gcc : goods.getGoodsClassifyCustomList()) {
                if (gcc.getId() == null) {
                    gcc.setGmtCreate(date);
                    gcc.setGoodsId(goods.getId());
                    this.goodsClassifyCustomMapper.insertSelective((Object)gcc);
                }
                if (gcc.getIsDelete() == null || !gcc.getIsDelete().booleanValue()) continue;
                Integer count = this.goodsClassifyCustomMapper.countclassByid(goods.getId(), gcc.getId());
                if (count == 0) {
                    Integer pid = this.goodsClassifyCustomMapper.selectPidById(gcc.getId());
                    Example example2 = new Example(GoodsClassifyCustom.class);
                    example2.createCriteria().andEqualTo("goodsId", (Object)goods.getId()).andEqualTo("classifyId", (Object)pid);
                    this.goodsClassifyCustomMapper.deleteByExample((Object)example2);
                }
                this.goodsClassifyCustomMapper.deleteByPrimaryKey((Object)gcc);
            }
        }
        if (goods.getGoodsTagCustomList() != null) {
            for (GoodsTagCustom gtc : goods.getGoodsTagCustomList()) {
                if (gtc.getId() == null) {
                    gtc.setGmtCreate(date);
                    gtc.setGoodsId(goods.getId());
                    this.goodsTagCustomMapper.insertSelective((Object)gtc);
                }
                if (gtc.getIsDelete() == null || !gtc.getIsDelete().booleanValue()) continue;
                this.goodsTagCustomMapper.deleteByPrimaryKey((Object)gtc);
            }
        }
        if (goods.getIsUniform() != null) {
            if (goods.getIsUniform().booleanValue()) {
                List list;
                GoodsSkuDetail goodsSkuDetail = (GoodsSkuDetail)goods.getGoodsSkuDetailList().get(0);
                if (goods.getIsGift() == 0) {
                    if (goodsSkuDetail.getSalesPrice().compareTo(new BigDecimal("0")) < 1) {
                        throw new CustomException("\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
                    }
                    if (goodsSkuDetail.getMarketPrice().compareTo(new BigDecimal("0")) < 1) {
                        throw new CustomException("\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
                    }
                    if (goodsSkuDetail.getMarketPrice().compareTo(goodsSkuDetail.getSalesPrice()) < 0) {
                        throw new CustomException("\u540a\u724c\u4ef7\u4e0d\u80fd\u4f4e\u4e8e\u9500\u552e\u4ef7");
                    }
                    if (!goods.getPriceSystem().equals(0) && goodsSkuDetail.getIntegralPoints().compareTo(0L) < 1) {
                        throw new CustomException("\u79ef\u5206\u4e0d\u80fd\u4e3a0");
                    }
                }
                if (goodsSkuDetail.getId() == null) {
                    goodsSkuDetail.setMerchantId(goods.getMerchantId());
                    list = this.goodsSkuDetailMapper.selectSkuNoRepeat(goodsSkuDetail);
                    if (list.size() > 0) {
                        throw new CustomException("sku\u7f16\u7801\u6709\u91cd\u590d");
                    }
                    goodsSkuDetail.setGoodsId(goods.getId());
                    goodsSkuDetail.setGmtCreate(date);
                    goodsSkuDetail.setIsUniform(Boolean.valueOf(true));
                    this.goodsSkuDetailMapper.insertSelective((Object)goodsSkuDetail);
                } else {
                    goodsSkuDetail.setMerchantId(goods.getMerchantId());
                    goodsSkuDetail.setNoId(goodsSkuDetail.getId());
                    list = this.goodsSkuDetailMapper.selectSkuNoRepeat(goodsSkuDetail);
                    if (list.size() > 0) {
                        throw new CustomException("sku\u7f16\u7801\u6709\u91cd\u590d");
                    }
                    goodsSkuDetail.setGmtModified(date);
                    this.goodsSkuDetailMapper.updateByPrimaryKeySelective((Object)goodsSkuDetail);
                }
                goods.setSalePrice(goodsSkuDetail.getSalesPrice());
                goods.setMarketPrice(goodsSkuDetail.getMarketPrice());
                goods.setIntegralPoints(((GoodsSkuDetail)goods.getGoodsSkuDetailList().get(0)).getIntegralPoints());
            } else {
                List goodsSkuDetailList = goods.getGoodsSkuDetailList();
                if (goodsSkuDetailList.size() > 0) {
                    example = new Example(GoodsSkuDetail.class);
                    example.createCriteria().andEqualTo("goodsId", (Object)goods.getId());
                    List goodsSkuDetails = this.goodsSkuDetailMapper.selectByExample((Object)example);
                    ArrayList ids = new ArrayList();
                    goodsSkuDetailList.forEach(e -> ids.add(e.getId()));
                    for (GoodsSkuDetail g : goodsSkuDetails) {
                        if (ids.contains(g.getId())) continue;
                        g.setIsDel(Boolean.valueOf(true));
                        this.goodsSkuDetailMapper.updateByPrimaryKeySelective((Object)g);
                    }
                    BigDecimal minSalePrice = ((GoodsSkuDetail)goodsSkuDetailList.get(0)).getSalesPrice();
                    BigDecimal minMarketPrice = ((GoodsSkuDetail)goodsSkuDetailList.get(0)).getMarketPrice();
                    Long minIntegralPoints = ((GoodsSkuDetail)goodsSkuDetailList.get(0)).getIntegralPoints();
                    for (GoodsSkuDetail g : goodsSkuDetailList) {
                        List list;
                        if (g.getSalesPrice().compareTo(new BigDecimal("0")) < 1) {
                            throw new CustomException("\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
                        }
                        if (g.getMarketPrice().compareTo(new BigDecimal("0")) < 1) {
                            throw new CustomException("\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
                        }
                        if (g.getMarketPrice().compareTo(g.getSalesPrice()) < 0) {
                            throw new CustomException("\u540a\u724c\u4ef7\u4e0d\u80fd\u4f4e\u4e8e\u9500\u552e\u4ef7");
                        }
                        if (!goods.getPriceSystem().equals(0) && g.getIntegralPoints().compareTo(0L) < 1) {
                            throw new CustomException("\u79ef\u5206\u4e0d\u80fd\u4e3a0");
                        }
                        if (g.getSalesPrice().compareTo(minSalePrice) < 0) {
                            minSalePrice = g.getSalesPrice();
                        }
                        if (g.getMarketPrice().compareTo(minMarketPrice) < 0) {
                            minMarketPrice = g.getMarketPrice();
                        }
                        if (!goods.getPriceSystem().equals(0) && g.getIntegralPoints().compareTo(minIntegralPoints) < 0) {
                            minIntegralPoints = g.getIntegralPoints();
                        }
                        if (g.getId() == null) {
                            g.setMerchantId(goods.getMerchantId());
                            list = this.goodsSkuDetailMapper.selectSkuNoRepeat(g);
                            if (list.size() > 0) {
                                throw new CustomException("sku\u7f16\u7801\u6709\u91cd\u590d");
                            }
                            g.setGoodsId(goods.getId());
                            g.setGmtCreate(date);
                            g.setIsUniform(Boolean.valueOf(false));
                            this.goodsSkuDetailMapper.insertSelective((Object)g);
                            continue;
                        }
                        g.setMerchantId(goods.getMerchantId());
                        g.setNoId(g.getId());
                        list = this.goodsSkuDetailMapper.selectSkuNoRepeat(g);
                        if (list.size() > 0) {
                            throw new CustomException("sku\u7f16\u7801\u6709\u91cd\u590d");
                        }
                        g.setGmtModified(date);
                        this.goodsSkuDetailMapper.updateByPrimaryKeySelective((Object)g);
                    }
                    goods.setSalePrice(minSalePrice);
                    goods.setMarketPrice(minMarketPrice);
                    goods.setIntegralPoints(minIntegralPoints);
                    if (goods.getGoodsSpecRelationList().size() > 0) {
                        Example example4 = new Example(GoodsSpecRelation.class);
                        example4.createCriteria().andEqualTo("goodsId", (Object)goods.getId());
                        this.goodsSpecRelationMapper.deleteByExample((Object)example4);
                        this.goodsSpecRelationMapper.insertList(goods.getGoodsSpecRelationList());
                    }
                }
            }
        }
        if ((i = this.goodsMapper.updateByPrimaryKeySelective((Object)goods)) > 0) {
            example = new Example(ActivityRuleCombination.class);
            example.createCriteria().andEqualTo("goodsId", (Object)goods.getId());
            List combinations = this.activityRuleCombinationMapper.selectByExample((Object)example);
            combinations.forEach(c -> {
                c.setGoodsName(goods.getGoodsName());
                c.setGoodsNo(goods.getGoodsNo());
                this.activityRuleCombinationMapper.updateByPrimaryKeySelective(c);
            });
        }
        return i;
    }

    public Goods findById(Integer id) {
        return this.goodsMapper.selectById(id);
    }

    public List<Goods> findByCondition(Goods goods) {
        return this.goodsMapper.goodsList(goods);
    }

    public int updateShelved(List<Goods> goodsList, Integer checked) {
        if (checked == 1) {
            for (Goods g : goodsList) {
                Example example = new Example(GoodsSkuDetail.class);
                example.createCriteria().andEqualTo("goodsId", (Object)g.getId()).andEqualTo("isDel", (Object)false);
                List list = this.goodsSkuDetailMapper.selectByExample((Object)example);
                if (list.size() >= 1) continue;
                throw new CustomException("\u7f16\u53f7" + g.getGoodsNo() + "\u5546\u54c1\u6ca1\u6709\u8bbe\u7f6e\u89c4\u683c");
            }
        }
        return this.goodsMapper.updateShelved(goodsList, checked);
    }

    public int delete(Integer id) {
        Goods goods1 = (Goods)this.goodsMapper.selectByPrimaryKey((Object)id);
        if (goods1.getIsShelved().booleanValue()) {
            throw new CustomException("\u5546\u54c1\u9700\u8981\u5148\u4e0b\u67b6\u624d\u80fd\u5220\u9664");
        }
        Goods goods = new Goods();
        goods.setId(id);
        goods.setIsDel(Boolean.valueOf(true));
        int result = this.goodsMapper.updateByPrimaryKeySelective((Object)goods);
        if (result > 0) {
            this.activityService.deleteActivityGoods(id);
        }
        return result;
    }

    public List<Goods> goodsStock(Goods goods) {
        return this.goodsMapper.goodsStock(goods);
    }

    public Goods findGiftByNo(Integer merchantId, String goodsNo) {
        Example example = new Example(Goods.class);
        example.createCriteria().andEqualTo("goodsNo", (Object)goodsNo).andEqualTo("merchantId", (Object)merchantId).andEqualTo("isGift", (Object)true).andEqualTo("isDel", (Object)false);
        List list = this.goodsMapper.selectByExample((Object)example);
        if (list.size() > 0) {
            return (Goods)list.get(0);
        }
        throw new CustomException("\u6ca1\u6709\u6b64\u7f16\u53f7\u7684\u8d60\u54c1");
    }

    public List<GoodsStatisticalDTO> goodsStatisticalList(Goods goods) {
        List goodsStatisticalDTOS = this.goodsMapper.goodsStatisticalList(goods);
        if (goodsStatisticalDTOS.size() > 0) {
            GoodsStatisticalDTO goodsStatisticalDTO = new GoodsStatisticalDTO();
            goodsStatisticalDTO.setGoodsNo("\u603b\u8ba1");
            goodsStatisticalDTO.setAmount(new BigDecimal("0"));
            goodsStatisticalDTO.setAvgPrice(new BigDecimal("0"));
            goodsStatisticalDTO.setCountCar(Integer.valueOf(0));
            goodsStatisticalDTO.setCountCollect(Integer.valueOf(0));
            goodsStatisticalDTO.setQuantity(Integer.valueOf(0));
            for (GoodsStatisticalDTO g : goodsStatisticalDTOS) {
                goodsStatisticalDTO.setAmount(goodsStatisticalDTO.getAmount().add(g.getAmount() == null ? new BigDecimal("0") : g.getAmount()));
                goodsStatisticalDTO.setAvgPrice(goodsStatisticalDTO.getAvgPrice().add(g.getAvgPrice() == null ? new BigDecimal("0") : g.getAvgPrice()));
                goodsStatisticalDTO.setCountCar(Integer.valueOf(goodsStatisticalDTO.getCountCar() + (g.getCountCar() == null ? 0 : g.getCountCar())));
                goodsStatisticalDTO.setCountCollect(Integer.valueOf(goodsStatisticalDTO.getCountCollect() + (g.getCountCollect() == null ? 0 : g.getCountCollect())));
                goodsStatisticalDTO.setQuantity(Integer.valueOf(goodsStatisticalDTO.getQuantity() + (g.getQuantity() == null ? 0 : g.getQuantity())));
                goodsStatisticalDTO.setAvgPrice(goodsStatisticalDTO.getAvgPrice().setScale(2, 4));
                g.setAvgPrice(g.getAvgPrice().setScale(2, 4));
            }
            goodsStatisticalDTOS.add(0, goodsStatisticalDTO);
        }
        return goodsStatisticalDTOS;
    }

    public Goods selectByGoodsNo(Goods goods) {
        Example example = new Example(Goods.class);
        example.createCriteria().andEqualTo("goodsNo", (Object)goods.getGoodsNo()).andEqualTo("isGift", (Object)false).andEqualTo("merchantId", (Object)goods.getMerchantId());
        return (Goods)this.goodsMapper.selectOneByExample((Object)example);
    }

    public Integer selectCountGoodsByExpressId(Integer id) {
        Example example = new Example(Goods.class);
        example.createCriteria().andEqualTo("expressTemplateId", (Object)id).andEqualTo("isDel", (Object)false);
        List goods = this.goodsMapper.selectByExample((Object)example);
        return goods.size();
    }
}

