/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.integral_wx;

import com.wmeimob.fastboot.bizvane.entity.IntegralGoods;
import com.wmeimob.fastboot.bizvane.service.IntegralGoodsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wx/goods"})
@Api(description="\u79ef\u5206\u5546\u57ce\u5c0f\u7a0b\u5e8f\u5546\u54c1API")
public class WxIntegralGoodsController {
    private static final Logger log = LoggerFactory.getLogger(WxIntegralGoodsController.class);
    @Autowired
    private IntegralGoodsService integralGoodsService;

    @RequestMapping(value={"/getHotGoods/{merchantId}"}, method={RequestMethod.GET})
    public List<IntegralGoods> getHotGoods(@PathVariable(value="merchantId") Integer merchantId) {
        log.info("\u5c0f\u7a0b\u5e8f\u83b7\u53d6\u70ed\u95e8\u5151\u6362\u5546\u54c1");
        return this.integralGoodsService.getHotGoods(merchantId);
    }

    @RequestMapping(value={"/getAllGoods"}, method={RequestMethod.GET})
    public List<IntegralGoods> getAllGoods(@RequestParam(value="merchantId") Integer merchantId, @RequestParam(value="sortType") String sortType, @RequestParam(value="orderBy") String orderBy) {
        log.info("\u5c0f\u7a0b\u5e8f\u83b7\u53d6\u6240\u6709\u5546\u54c1");
        sortType = "1".equals(sortType) ? "actualSales" : "price";
        return this.integralGoodsService.getGoods(merchantId, sortType, orderBy, null, "wx", new IntegralGoods());
    }

    @RequestMapping(value={"/getGoodsDetail/{id}"}, method={RequestMethod.GET})
    public IntegralGoods getGoodsDetail(@PathVariable(value="id") Integer id) {
        log.info("\u5c0f\u7a0b\u5e8f\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u3002\u3002\u3002");
        IntegralGoods integralGoods = this.integralGoodsService.getGoodsById(id, "wx");
        return integralGoods;
    }

    @RequestMapping(value={"/getGoodsByClassifyId"}, method={RequestMethod.GET})
    public List<IntegralGoods> getGoodsByClassifyId(@RequestParam(value="classifyId") Integer classifyId, @RequestParam(value="merchantId") Integer merchantId, @RequestParam(value="sortType") String sortType, @RequestParam(value="orderBy") String orderBy) {
        log.info("\u5c0f\u7a0b\u5e8f\u67e5\u8be2\u5206\u7c7b\u5546\u54c1\u3002\u3002\u3002");
        sortType = "1".equals(sortType) ? "actualSales" : "price";
        return this.integralGoodsService.getGoodsByClassifyId(classifyId, merchantId, sortType, orderBy);
    }

    @RequestMapping(value={"/getSkuStock"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u5546\u54c1sku\u5e93\u5b58\u6570")
    @ApiImplicitParam(name="skuId", value="\u5546\u54c1skuid", dataType="int", paramType="query", required=true)
    public Integer getSkuStock(@RequestParam(value="skuId") Integer skuId) {
        log.info("\u83b7\u53d6\u5546\u54c1sku\u5e93\u5b58");
        return this.integralGoodsService.getSkuStock(skuId);
    }
}

