/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.integral;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.CommonUtil;
import com.wmeimob.fastboot.bizvane.dto.integral.IntegralGoodsDTO;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoods;
import com.wmeimob.fastboot.bizvane.service.IntegralGoodsService;
import com.wmeimob.fastboot.core.annotation.Page;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.core.rest.RestResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/integral/goods"})
@Api(description="\u79ef\u5206\u5546\u57ce\u5546\u54c1API")
public class IntegralGoodsController {
    private static final Logger log = LoggerFactory.getLogger(IntegralGoodsController.class);
    @Autowired
    private IntegralGoodsService integralGoodsService;

    @ApiOperation(value="\u4fdd\u5b58\u4fee\u6539\u5546\u54c1")
    @RequestMapping(value={"/saveGoods"}, method={RequestMethod.POST})
    public RestResult saveGoods(@RequestBody IntegralGoods integralGoods) {
        if (CommonUtil.hasChinese((String)integralGoods.getGoodsNo())) {
            throw new CustomException("\u5546\u54c1\u7f16\u53f7\u4e0d\u80fd\u5b58\u5728\u4e2d\u6587\uff01");
        }
        if (integralGoods.getId() == null) {
            log.info("\u5546\u54c1\u65b0\u589e\u65b9\u6cd5....");
            this.integralGoodsService.addGoods(integralGoods);
        } else {
            log.info("\u5546\u54c1\u4fee\u6539\u65b9\u6cd5....");
            this.integralGoodsService.updateGoods(integralGoods);
        }
        return RestResult.success();
    }

    @ApiOperation(value="\u5546\u54c1\u5206\u9875")
    @ApiImplicitParams(value={@ApiImplicitParam(name="merchantId", value="\u54c1\u724cid", dataType="int", paramType="query", required=true), @ApiImplicitParam(name="pageIndex", value="\u5f53\u524d\u9875\u6570", dataType="int", paramType="query", required=true), @ApiImplicitParam(name="pageSize", value="\u4e00\u9875\u5c55\u793a\u6570\u91cf", dataType="int", paramType="query", required=true), @ApiImplicitParam(name="searchValue", value="\u641c\u7d22", dataType="String", paramType="query", required=false)})
    @RequestMapping(value={"/getGoodsList"}, method={RequestMethod.GET})
    @Page
    public PageInfo getGoodsList(@RequestParam(value="merchantId") Integer merchantId, @RequestParam(value="searchValue", required=false) String searchValue, IntegralGoods integralGoods, Integer pageSize, Integer pageIndex) {
        log.info("\u67e5\u8be2\u6240\u6709\u5546\u54c1\u5206\u9875\u3002\u3002\u3002");
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        List list = this.integralGoodsService.getGoods(merchantId, null, null, searchValue, "pc", integralGoods);
        return new PageInfo(list);
    }

    @ApiOperation(value="\u67e5\u8be2\u5546\u54c1\u8be6\u60c5")
    @ApiImplicitParam(name="id", value="\u4e3b\u952eid", dataType="int", paramType="query", required=true)
    @RequestMapping(value={"/getGoodsDetail"}, method={RequestMethod.GET})
    public IntegralGoods getGoodsDetail(@RequestParam(value="id") Integer id) {
        log.info("\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u3002\u3002\u3002");
        IntegralGoods integralGoods = this.integralGoodsService.getGoodsById(id, "pc");
        return integralGoods;
    }

    @ApiOperation(value="\u5220\u9664\u5546\u54c1")
    @ApiImplicitParam(name="id", value="\u4e3b\u952eid", dataType="int", paramType="query", required=true)
    @RequestMapping(value={"/deleteGoods"}, method={RequestMethod.GET})
    public RestResult deleteGoods(@RequestParam(value="id") Integer id) {
        log.info("\u5220\u9664\u5546\u54c1\u3002\u3002\u3002\u3002");
        this.integralGoodsService.deleteGoods(id);
        return RestResult.success();
    }

    @ApiOperation(value="\u6279\u91cf\u4e0a\u4e0b\u67b6")
    @RequestMapping(value={"/upperOrlower"}, method={RequestMethod.POST})
    public RestResult upperOrlower(@RequestBody IntegralGoodsDTO integralGoodsDTO) {
        log.info("\u6279\u91cf\u4e0a\u4e0b\u67b6\u3002\u3002\u3002\u3002");
        if (integralGoodsDTO.getShelf() == null || integralGoodsDTO.getGoodIds() == null) {
            return RestResult.fail((String)"\u53c2\u6570\u6709\u8bef");
        }
        for (Integer id : integralGoodsDTO.getGoodIds()) {
            this.integralGoodsService.upperOrlower(id, integralGoodsDTO.getShelf());
        }
        return RestResult.success();
    }
}

