/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.dto.StatisticalDTO;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.enums.LogisticsStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.OrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.PayStatusEnum;
import com.wmeimob.fastboot.bizvane.service.MarketActivityService;
import com.wmeimob.fastboot.bizvane.service.OrdersService;
import com.wmeimob.fastboot.bizvane.service.OrdersServiceImpl;
import com.wmeimob.fastboot.core.annotation.Page;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.excel.ExcelHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"orders"})
public class OrderController {
    @Resource
    private OrdersService ordersService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Resource(name="commonOrdersServiceImpl")
    private OrdersService commonOrdersService;
    @Resource
    private OrdersServiceImpl ordersServiceImpl;
    @Autowired
    private MarketActivityService marketActivityService;

    @Page
    @GetMapping
    public PageInfo list(@RequestHeader(value="merchantId") Integer merchantId, Orders orders) {
        orders.setMerchantId(merchantId);
        List list = this.ordersService.findByCondition((Serializable)orders);
        return new PageInfo(list);
    }

    @PutMapping(value={"{id}"})
    public RestResult update(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody Orders orders, @PathVariable Integer id) {
        orders.setMerchantId(merchantId);
        int i = this.ordersService.update((Serializable)orders);
        return i < 1 ? RestResult.fail() : RestResult.success();
    }

    @GetMapping(value={"/judgeSend"})
    public Map judgeSend(@RequestParam(value="id") Integer id) {
        return this.ordersServiceImpl.judgeSend(id);
    }

    @GetMapping(value={"{id}"})
    public Orders getOrderById(@PathVariable(value="id") Integer id) {
        return (Orders)this.commonOrdersService.findById(id);
    }

    @GetMapping(value={"commissionStatisticalList"})
    public PageInfo commissionStatisticalList(@RequestHeader(value="merchantId") Integer merchantId, Orders orders) {
        if (orders.getBeginDate() == null && orders.getEndDate() == null) {
            return null;
        }
        orders.setMerchantId(merchantId);
        List list = this.ordersService.commissionStatisticalList(orders);
        return new PageInfo(list);
    }

    @GetMapping(value={"orderStatisticalList"})
    public PageInfo orderStatisticalList(@RequestHeader(value="merchantId") Integer merchantId, Orders orders) {
        if (orders.getBeginDate() == null && orders.getEndDate() == null) {
            return null;
        }
        orders.setMerchantId(merchantId);
        List list = this.ordersService.orderStatisticalList(orders);
        return new PageInfo(list);
    }

    @GetMapping(value={"export-key"})
    public String export() {
        String key = UUID.randomUUID().toString();
        this.stringRedisTemplate.opsForValue().set((Object)("download_key:" + key), (Object)"all", 30L, TimeUnit.SECONDS);
        return key;
    }

    @GetMapping(value={"orderStatisticalExport"})
    public void orderStatisticalExport(String key, Orders orders, HttpServletResponse res) {
        String value = (String)this.stringRedisTemplate.opsForValue().get((Object)("download_key:" + key));
        if (value == null) {
            return;
        }
        if (orders.getBeginDate() == null && orders.getEndDate() == null) {
            return;
        }
        orders.setMerchantId(orders.getMerchantId());
        List list = this.ordersService.orderStatisticalList(orders);
        String[] heads = new String[]{"\u65e5\u671f", "\u4e0b\u5355\u4ef6\u6570", "\u4e0b\u5355\u8ba2\u5355\u6570", "\u4e0b\u5355\u91d1\u989d", "\u652f\u4ed8\u4ef6\u6570", "\u652f\u4ed8\u8ba2\u5355\u6570", "\u652f\u4ed8\u91d1\u989d", "\u9000\u6b3e\u4ef6\u6570", "\u9000\u6b3e\u5355\u6570", "\u9000\u6b3e\u91d1\u989d", "\u6536\u85cf\u91cf", "\u5ba2\u5355\u91cf", "\u5e73\u5747\u6210\u4ea4\u4ef6\u6570"};
        String[] fields = new String[]{"createTime", "quantity", "countOrder", "price", "payQuantity", "countPayOrder", "payAmount", "refundQuantity", "countRefundOrder", "refundPrice", "countCollect", "avgPrice", "avgQuantity"};
        try {
            HSSFWorkbook hssfWorkbook = ExcelHelper.exportFromList((List)list, (String[])heads, (String[])fields, StatisticalDTO.class);
            res.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode("\u8ba2\u5355\u7edf\u8ba1.xls", "UTF-8"));
            hssfWorkbook.write((OutputStream)res.getOutputStream());
            res.getOutputStream().close();
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    @GetMapping(value={"commissionStatisticalExport"})
    public void commissionStatisticalExport(String key, Orders orders, HttpServletResponse res) {
        String value = (String)this.stringRedisTemplate.opsForValue().get((Object)("download_key:" + key));
        if (value == null) {
            return;
        }
        if (orders.getBeginDate() == null && orders.getEndDate() == null) {
            return;
        }
        orders.setMerchantId(orders.getMerchantId());
        List list = this.ordersService.commissionStatisticalList(orders);
        String[] heads = new String[]{"\u65e5\u671f", "\u6210\u4ea4\u4ef6\u6570", "\u6210\u4ea4\u8ba2\u5355\u6570", "\u6210\u4ea4\u91d1\u989d", "\u9000\u6b3e\u4ef6\u6570", "\u9000\u6b3e\u5355\u6570", "\u9000\u6b3e\u91d1\u989d", "\u4f63\u91d1\u91d1\u989d"};
        String[] fields = new String[]{"createTime", "quantity", "countOrder", "price", "refundQuantity", "countRefundOrder", "refundPrice", "commission"};
        try {
            HSSFWorkbook hssfWorkbook = ExcelHelper.exportFromList((List)list, (String[])heads, (String[])fields, StatisticalDTO.class);
            res.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode("\u5206\u9500\u7edf\u8ba1.xls", "UTF-8"));
            hssfWorkbook.write((OutputStream)res.getOutputStream());
            res.getOutputStream().close();
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    @GetMapping(value={"orderListExport"})
    public void orderListExport(String key, Orders orders, HttpServletResponse res) {
        String value = (String)this.stringRedisTemplate.opsForValue().get((Object)("download_key:" + key));
        if (value == null) {
            return;
        }
        orders.setMerchantId(orders.getMerchantId());
        List list = this.ordersService.findByCondition((Serializable)orders);
        System.out.println(((Orders)list.get(2)).getOrderStatus());
        for (Orders o : list) {
            if (o.getOrderStatus().equals((Object)OrdersStatusEnum.FAIL)) {
                o.setOutStatus("\u5df2\u5173\u95ed");
            }
            if (o.getPayStatus().equals((Object)PayStatusEnum.UN_PAY) && o.getOrderStatus().equals((Object)OrdersStatusEnum.TRADE)) {
                o.setOutStatus("\u5f85\u652f\u4ed8");
            }
            if (o.getOrderStatus().equals((Object)OrdersStatusEnum.TRADE) && o.getPayStatus().equals((Object)PayStatusEnum.SUCCESS) && o.getLogisticsStatus().equals((Object)LogisticsStatusEnum.UN_SEND)) {
                o.setOutStatus("\u5f85\u53d1\u8d27");
            }
            if (o.getOrderStatus().equals((Object)OrdersStatusEnum.TRADE) && o.getPayStatus().equals((Object)PayStatusEnum.SUCCESS) && o.getLogisticsStatus().equals((Object)LogisticsStatusEnum.SEND)) {
                o.setOutStatus("\u5df2\u53d1\u8d27");
            }
            if (o.getOrderStatus().equals((Object)OrdersStatusEnum.TRADE) && o.getPayStatus().equals((Object)PayStatusEnum.SUCCESS) && o.getLogisticsStatus().equals((Object)LogisticsStatusEnum.RECEIVED)) {
                o.setOutStatus("\u5df2\u6536\u8d27");
            }
            if (!o.getOrderStatus().equals((Object)OrdersStatusEnum.SUCCESS)) continue;
            o.setOutStatus("\u4ea4\u6613\u6210\u529f" + (o.getIsComment() == false ? "(\u5f85\u8bc4\u4ef7)" : ""));
        }
        String[] heads = new String[]{"\u8ba2\u5355\u7f16\u53f7", "\u8d2d\u4e70\u4eba", "\u8ba2\u5355\u91d1\u989d", "\u6536\u8d27\u4eba", "\u6536\u8d27\u4eba\u7535\u8bdd", "\u4e0b\u5355\u65f6\u95f4", "\u4ed8\u6b3e\u65f6\u95f4", "\u72b6\u6001"};
        String[] fields = new String[]{"orderNo", "userName", "payAmount", "shippingName", "shippingMobile", "gmtCreate", "payAt", "outStatus"};
        try {
            HSSFWorkbook hssfWorkbook = ExcelHelper.exportFromList((List)list, (String[])heads, (String[])fields, Orders.class);
            res.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode("\u8ba2\u5355\u62a5\u8868.xls", "UTF-8"));
            hssfWorkbook.write((OutputStream)res.getOutputStream());
            res.getOutputStream().close();
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    @GetMapping(value={"offlineOrdersRetry"})
    public void offlineOrdersRetry(@RequestParam(value="id") Integer id) {
        this.ordersServiceImpl.pushToOffline(id);
    }
}

