/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.entity.GoodsSpecRelation;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSkuDetailMapper;
import com.wmeimob.fastboot.bizvane.service.GoodsSkuDetailService;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.core.rest.RestResult;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

@RestController
@RequestMapping(value={"goods-sku"})
public class GoodsSkuDetailController {
    @Autowired
    private GoodsSkuDetailService goodsSkuDetailService;
    @Autowired
    private GoodsSkuDetailMapper goodsSkuDetailMapper;
    @Autowired
    private GoodsMapper goodsMapper;

    @PutMapping(value={"{id}"})
    public RestResult update(@RequestBody List<GoodsSkuDetail> goodsSkuDetailList, @PathVariable(value="id") Integer id) {
        List skuDetails = this.goodsSkuDetailService.update(goodsSkuDetailList, id);
        return RestResult.success();
    }

    @GetMapping(value={"{id}"})
    public List<GoodsSkuDetail> list(@PathVariable(value="id") Integer id) {
        List list = this.goodsSkuDetailService.findByGoodsId(id);
        return list;
    }

    @PostMapping(value={"{id}"})
    public List<GoodsSpecRelation> relation(@RequestBody List<GoodsSpecRelation> goodsSpecRelations, @PathVariable(value="id") Integer id) {
        List list = this.goodsSkuDetailService.relation(goodsSpecRelations, id);
        return list;
    }

    @GetMapping(value={"getSkusByGoodsNo"})
    public List<GoodsSkuDetail> getSkusByGoodsNo(@RequestParam(value="goodsNo") String goodsNo) {
        Example example = new Example(Goods.class);
        example.createCriteria().andEqualTo("goodsNo", (Object)goodsNo).andEqualTo("isDel", (Object)Boolean.FALSE);
        Goods goods = (Goods)this.goodsMapper.selectOneByExample((Object)example);
        if (goods == null) {
            throw new CustomException("\u6b64\u5546\u54c1\u4e0d\u5b58\u5728\uff01");
        }
        Example skuExample = new Example(GoodsSkuDetail.class);
        skuExample.createCriteria().andEqualTo("goodsId", (Object)goods.getId());
        List skuDetailList = this.goodsSkuDetailMapper.selectByExample((Object)skuExample);
        return skuDetailList;
    }
}

