/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.CommonUtil;
import com.wmeimob.fastboot.bizvane.dto.integral.GoodSkuSpecDTO;
import com.wmeimob.fastboot.bizvane.entity.IntegralClassify;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoods;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoodsSku;
import com.wmeimob.fastboot.bizvane.entity.IntegralSpec;
import com.wmeimob.fastboot.bizvane.mapper.IntegralClassifyMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsSkuMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralSpecMapper;
import com.wmeimob.fastboot.bizvane.service.IntegralGoodsService;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.util.InputValidator;
import com.wmeimob.fastboot.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
public class IntegralGoodsServiceImpl
implements IntegralGoodsService {
    private static final Logger log = LoggerFactory.getLogger(IntegralGoodsServiceImpl.class);
    @Autowired
    private IntegralGoodsMapper integralGoodsMapper;
    @Autowired
    private IntegralGoodsSkuMapper integralGoodsSkuMapper;
    @Autowired
    private IntegralClassifyMapper integralClassifyMapper;
    @Autowired
    private IntegralSpecMapper integralSpecMapper;

    @Transactional
    public IntegralGoods addGoods(IntegralGoods integralGoods) {
        log.info("\u5546\u54c1\u65b0\u589e\u3002\u3002\u3002");
        InputValidator.checkEmpty((Object)integralGoods.getCoverImg(), (String)"\u5217\u8868\u7f29\u7565\u56fe\u5730\u5740");
        InputValidator.checkEmpty((Object)integralGoods.getBannerImgPaths(), (String)"\u5546\u54c1\u9996\u9875\u8f6e\u64ad\u56fe\u5730\u5740");
        InputValidator.checkEmpty((Collection)integralGoods.getSkus(), (String)"\u5546\u54c1sku\u5217\u8868");
        if (integralGoods.getRestrictedNum() != null) {
            InputValidator.checkNaturalNumber((Integer)integralGoods.getRestrictedNum(), (String)"\u9650\u5151\u6570\u91cf");
        }
        Example example = new Example(IntegralGoods.class);
        example.createCriteria().andEqualTo("goodsNo", (Object)integralGoods.getGoodsNo()).andEqualTo("merchantId", (Object)integralGoods.getMerchantId()).andEqualTo("valid", (Object)true);
        List goodsList = this.integralGoodsMapper.selectByExample((Object)example);
        if (goodsList.size() > 0) {
            throw new CustomException("\u5546\u54c1\u7f16\u53f7\u91cd\u590d");
        }
        integralGoods.setGmtCreate(new Date());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date uppTime = sdf.parse(integralGoods.getUpperShelfTimeStr());
            integralGoods.setUpperShelfTime(uppTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.integralGoodsMapper.insertSelective((Object)integralGoods);
        List goodsSkuList = integralGoods.getSkus();
        for (IntegralGoodsSku sku : goodsSkuList) {
            if (CommonUtil.hasChinese((String)sku.getSkuNo())) {
                throw new CustomException("\u5546\u54c1sku\u7f16\u7801\u4e0d\u80fd\u5b58\u5728\u4e2d\u6587\uff01");
            }
            sku.setGoodsId(integralGoods.getId());
            sku.setGmtCreate(new Date());
            this.integralGoodsSkuMapper.insertSelective((Object)sku);
        }
        return integralGoods;
    }

    @Transactional
    public IntegralGoods updateGoods(IntegralGoods integralGoods) {
        log.info("\u5546\u54c1\u4fee\u6539\u3002\u3002\u3002");
        InputValidator.checkEmpty((Object)integralGoods.getCoverImg(), (String)"\u5217\u8868\u7f29\u7565\u56fe\u5730\u5740");
        InputValidator.checkEmpty((Object)integralGoods.getBannerImgPaths(), (String)"\u5546\u54c1\u9996\u9875\u8f6e\u64ad\u56fe\u5730\u5740");
        InputValidator.checkEmpty((Collection)integralGoods.getSkus(), (String)"\u5546\u54c1sku\u5217\u8868");
        if (integralGoods.getRestrictedNum() != null) {
            InputValidator.checkNaturalNumber((Integer)integralGoods.getRestrictedNum(), (String)"\u9650\u5151\u6570\u91cf");
        }
        Example example = new Example(IntegralGoods.class);
        example.createCriteria().andEqualTo("goodsNo", (Object)integralGoods.getGoodsNo()).andEqualTo("merchantId", (Object)integralGoods.getMerchantId()).andEqualTo("valid", (Object)true).andNotEqualTo("id", (Object)integralGoods.getId());
        List goodsList = this.integralGoodsMapper.selectByExample((Object)example);
        if (goodsList.size() > 0) {
            throw new CustomException("\u5546\u54c1\u7f16\u53f7\u91cd\u590d");
        }
        integralGoods.setGmtModified(new Date());
        this.integralGoodsMapper.updateByPrimaryKey((Object)integralGoods);
        this.integralGoodsSkuMapper.deleteSkuByGoodId(integralGoods.getId());
        List goodsSkuList = integralGoods.getSkus();
        for (IntegralGoodsSku sku : goodsSkuList) {
            Example skuExample = new Example(IntegralGoodsSku.class);
            skuExample.createCriteria().andEqualTo("skuNo", (Object)sku.getSkuNo()).andEqualTo("valid", (Object)Boolean.TRUE);
            IntegralGoodsSku goodsSku = (IntegralGoodsSku)this.integralGoodsSkuMapper.selectOneByExample((Object)skuExample);
            if (goodsSku != null) {
                throw new CustomException("skuNo:[" + sku.getSkuNo() + "]\u91cd\u590d");
            }
            sku.setGmtCreate(new Date());
            sku.setGoodsId(integralGoods.getId());
            this.integralGoodsSkuMapper.insertSelective((Object)sku);
        }
        return integralGoods;
    }

    public List<IntegralGoods> getGoods(Integer merchantId, String column, String orderBy, String searchValue, String fromType) {
        List list;
        InputValidator.checkEmpty((Object)merchantId, (String)"\u54c1\u724cid");
        String desc = "desc";
        String pc = "pc";
        Example example = new Example(IntegralGoods.class);
        if (!StringUtils.isEmpty((Object)column) && !StringUtils.isEmpty((Object)orderBy)) {
            if (desc.equals(orderBy)) {
                example.orderBy(column).desc();
            } else {
                example.orderBy(column).asc();
            }
        }
        if (pc.equals(fromType)) {
            example.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("valid", (Object)Boolean.TRUE);
        } else {
            example.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("valid", (Object)Boolean.TRUE).andEqualTo("shelf", (Object)Boolean.TRUE);
        }
        if (!StringUtils.isEmpty((Object)searchValue)) {
            example.and().andLike("goodsNo", "%" + searchValue + "%").orLike("goodsName", "%" + searchValue + "%");
        }
        if ((list = this.integralGoodsMapper.selectByExample((Object)example)).size() > 0) {
            for (IntegralGoods goods : list) {
                Example skuExample = new Example(IntegralGoodsSku.class);
                skuExample.createCriteria().andEqualTo("goodsId", (Object)goods.getId()).andEqualTo("valid", (Object)Boolean.TRUE);
                List skuList = this.integralGoodsSkuMapper.selectByExample((Object)skuExample);
                if (skuList.size() > 0) {
                    int stock = 0;
                    for (IntegralGoodsSku sku : skuList) {
                        stock += sku.getStock().intValue();
                    }
                    goods.setTotalStock(Integer.valueOf(stock));
                    continue;
                }
                goods.setTotalStock(Integer.valueOf(0));
            }
        }
        return list;
    }

    public IntegralGoods getGoodsById(Integer id, String type) {
        log.info("\u83b7\u53d6\u5546\u54c1\u8be6\u60c5\u3002\u3002\u3002");
        InputValidator.checkEmpty((Object)id, (String)"\u5546\u54c1id");
        String pc = "pc";
        String wx = "wx";
        Example example = new Example(IntegralGoods.class);
        example.createCriteria().andEqualTo("id", (Object)id);
        IntegralGoods integralGoods = (IntegralGoods)this.integralGoodsMapper.selectOneByExample((Object)example);
        if (integralGoods != null) {
            Example skuExample = new Example(IntegralGoodsSku.class);
            if (pc.equals(type)) {
                skuExample.createCriteria().andEqualTo("goodsId", (Object)id).andEqualTo("valid", (Object)Boolean.TRUE);
            } else if (wx.equals(type)) {
                skuExample.createCriteria().andEqualTo("goodsId", (Object)id).andEqualTo("valid", (Object)Boolean.TRUE).andEqualTo("enabled", (Object)Boolean.TRUE);
            }
            List skuList = this.integralGoodsSkuMapper.selectByExample((Object)skuExample);
            if (skuList.size() > 0) {
                for (IntegralGoodsSku sku : skuList) {
                    ArrayList<GoodSkuSpecDTO> list = new ArrayList<GoodSkuSpecDTO>();
                    List specMainList = this.integralSpecMapper.getPidList(sku.getSpecIds());
                    for (IntegralSpec mainSpec : specMainList) {
                        GoodSkuSpecDTO goodSkuSpecDTO = new GoodSkuSpecDTO();
                        IntegralSpec specMain = (IntegralSpec)this.integralSpecMapper.selectByPrimaryKey((Object)mainSpec.getPid());
                        goodSkuSpecDTO.setMainSpec(specMain);
                        list.add(goodSkuSpecDTO);
                    }
                    for (GoodSkuSpecDTO dto : list) {
                        ArrayList<IntegralSpec> child = new ArrayList<IntegralSpec>();
                        Example specExample = new Example(IntegralSpec.class);
                        specExample.createCriteria().andCondition("id in (" + sku.getSpecIds() + ")");
                        List specList = this.integralSpecMapper.selectByExample((Object)specExample);
                        for (IntegralSpec childSpec : specList) {
                            if (!childSpec.getPid().equals(dto.getMainSpec().getId())) continue;
                            child.add(childSpec);
                        }
                        dto.setChilds(child);
                    }
                    sku.setGoodSkuSpecDetails(list);
                }
            }
            integralGoods.setSkus(skuList);
            ArrayList<IntegralClassify> integralClassifyList = new ArrayList<IntegralClassify>();
            String classifyStr = integralGoods.getClassifyId();
            if (classifyStr.contains(",")) {
                String[] classifyArray;
                for (String classify : classifyArray = classifyStr.split(",")) {
                    IntegralClassify integralClassify = (IntegralClassify)this.integralClassifyMapper.selectByPrimaryKey((Object)classify);
                    if (integralClassify == null) continue;
                    integralClassifyList.add(integralClassify);
                }
            } else {
                IntegralClassify integralClassify = (IntegralClassify)this.integralClassifyMapper.selectByPrimaryKey((Object)classifyStr);
                if (integralClassify != null) {
                    integralClassifyList.add(integralClassify);
                }
            }
            integralGoods.setClassifyList(integralClassifyList);
            String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(integralGoods.getUpperShelfTime());
            integralGoods.setUpperShelfTimeStr(time);
        }
        return integralGoods;
    }

    public void deleteGoods(Integer id) {
        log.info("\u5220\u9664\u5546\u54c1\u3002\u3002\u3002");
        InputValidator.checkEmpty((Object)id, (String)"\u5546\u54c1id");
        Example example = new Example(IntegralGoods.class);
        example.createCriteria().andEqualTo("id", (Object)id);
        IntegralGoods integralGoods = (IntegralGoods)this.integralGoodsMapper.selectOneByExample((Object)example);
        if (integralGoods != null) {
            if (Boolean.TRUE.equals(integralGoods.getShelf())) {
                throw new CustomException("\u4e0a\u67b6\u5546\u54c1\u4e0d\u80fd\u5220\u9664!");
            }
            Example skuExample = new Example(IntegralGoodsSku.class);
            skuExample.createCriteria().andEqualTo("goodsId", (Object)id).andEqualTo("valid", (Object)Boolean.TRUE);
            List skuList = this.integralGoodsSkuMapper.selectByExample((Object)skuExample);
            if (skuList.size() > 0) {
                for (IntegralGoodsSku sku : skuList) {
                    sku.setValid(Boolean.FALSE);
                    this.integralGoodsSkuMapper.updateByPrimaryKey((Object)sku);
                }
            }
            integralGoods.setValid(Boolean.FALSE);
            this.integralGoodsMapper.updateByPrimaryKey((Object)integralGoods);
        }
    }

    public List<IntegralGoods> getLowerGoods() {
        Example example = new Example(IntegralGoods.class);
        example.createCriteria().andEqualTo("shelf", (Object)Boolean.FALSE).andEqualTo("valid", (Object)Boolean.TRUE).andIsNotNull("upperShelfTime");
        List goods = this.integralGoodsMapper.selectByExample((Object)example);
        return goods;
    }

    public List<IntegralGoods> getHotGoods(Integer merchantId) {
        Example example = new Example(IntegralGoods.class);
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("valid", (Object)true).andEqualTo("hot", (Object)Boolean.TRUE).andEqualTo("shelf", (Object)Boolean.TRUE);
        List list = this.integralGoodsMapper.selectByExample((Object)example);
        return list;
    }

    public List<IntegralGoods> getGoodsByClassifyId(Integer classifyId, Integer merchantId, String column, String orderBy) {
        String desc = "desc";
        Example example = new Example(IntegralGoods.class);
        if (!StringUtils.isEmpty((Object)column) && !StringUtils.isEmpty((Object)orderBy)) {
            if (desc.equals(orderBy)) {
                example.orderBy(column).desc();
            } else {
                example.orderBy(column).asc();
            }
        }
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("valid", (Object)true).andEqualTo("shelf", (Object)Boolean.TRUE).andLike("classifyId", "%" + classifyId + "%");
        List list = this.integralGoodsMapper.selectByExample((Object)example);
        return list;
    }

    public Integer getSkuStock(Integer skuId) {
        IntegralGoodsSku sku = (IntegralGoodsSku)this.integralGoodsSkuMapper.selectByPrimaryKey((Object)skuId);
        if (sku == null) {
            return 0;
        }
        return sku.getStock();
    }

    public int upperOrlower(Integer goodId, Boolean shelf) {
        Example example = new Example(IntegralGoods.class);
        example.createCriteria().andEqualTo("id", (Object)goodId);
        IntegralGoods goods = new IntegralGoods();
        goods.setShelf(shelf);
        if (Boolean.TRUE.equals(shelf)) {
            goods.setUpperShelfTime(new Date());
        } else {
            goods.setLowerShelfTime(new Date());
        }
        return this.integralGoodsMapper.updateByExampleSelective((Object)goods, (Object)example);
    }
}

