/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.wmeimob.fastboot.bizvane.entity.GoodsGiftRelation;
import com.wmeimob.fastboot.bizvane.service.GiftService;
import com.wmeimob.fastboot.core.rest.RestResult;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"gift"})
public class GiftController {
    @Autowired
    private GiftService giftService;

    @PostMapping
    public RestResult insert(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody GoodsGiftRelation goodsGiftRelation) {
        goodsGiftRelation.setMerchantId(merchantId);
        this.giftService.add((Serializable)goodsGiftRelation);
        return RestResult.success();
    }

    @PutMapping(value={"{id}"})
    public RestResult update(@RequestBody GoodsGiftRelation goodsGiftRelation) {
        return this.giftService.update((Serializable)goodsGiftRelation) < 1 ? RestResult.fail() : RestResult.success();
    }

    @DeleteMapping(value={"{id}"})
    public RestResult delete(@PathVariable(value="id") Integer id) {
        return this.giftService.delete(id) < 1 ? RestResult.fail() : RestResult.success();
    }

    @GetMapping(value={"{id}"})
    public List<GoodsGiftRelation> list(@PathVariable(value="id") Integer id) {
        return this.giftService.findListByGoodsId(id);
    }
}

