/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoods;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoodsSku;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrders;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrdersDetails;
import com.wmeimob.fastboot.bizvane.entity.IntegralRefundOrder;
import com.wmeimob.fastboot.bizvane.enums.IntegralOrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsSkuMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralOrdersDetailsMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralOrdersMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralRefundOrderMapper;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.IntegralRefundOrderService;
import com.wmeimob.fastboot.bizvane.util.IntegralOrderNoUtil;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.core.rest.RestResult;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
public class IntegralRefundOrderServiceImpl
implements IntegralRefundOrderService {
    private static final Logger log = LoggerFactory.getLogger(IntegralRefundOrderServiceImpl.class);
    @Autowired
    private IntegralRefundOrderMapper integralRefundOrderMapper;
    @Autowired
    private IntegralOrdersMapper integralOrdersMapper;
    @Autowired
    private IntegralOrdersDetailsMapper integralOrdersDetailsMapper;
    @Resource
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private IntegralGoodsSkuMapper integralGoodsSkuMapper;
    @Autowired
    private IntegralGoodsMapper integralGoodsMapper;

    @Transactional(rollbackFor={Exception.class})
    public IntegralRefundOrder submitReturnGoods(IntegralRefundOrder refundOrder) {
        log.info("\u63d0\u4ea4\u9000\u8d27\u8ba2\u5355\u3002\u3002\u3002\u3002\u3002\u3002\u3002START................");
        log.info("\u6821\u9a8c\u662f\u5426\u5b58\u5728\u539f\u8ba2\u5355,\u8ba2\u5355\u53f7:{}", (Object)refundOrder.getOrderNo());
        Example orderExample = new Example(IntegralOrders.class);
        orderExample.createCriteria().andEqualTo("orderNo", (Object)refundOrder.getOrderNo()).andEqualTo("valid", (Object)Boolean.TRUE);
        IntegralOrders orders = (IntegralOrders)this.integralOrdersMapper.selectOneByExample((Object)orderExample);
        if (orders == null) {
            throw new CustomException("\u4e0d\u5b58\u5728\u539f\u8d2d\u4e70\u8ba2\u5355,\u65e0\u6cd5\u8fdb\u884c\u9000\u8d27\u63d0\u4ea4\uff01");
        }
        log.info("\u83b7\u53d6\u7684\u8ba2\u5355\u4fe1\u606f{}", (Object)JSONObject.toJSONString((Object)orders));
        IntegralOrdersDetails ordersDetails = (IntegralOrdersDetails)this.integralOrdersDetailsMapper.selectByPrimaryKey((Object)refundOrder.getOrderDetailId());
        if (ordersDetails == null) {
            throw new CustomException("\u4e0d\u5b58\u5728\u8ba2\u5355\u660e\u7ec6,\u65e0\u6cd5\u8fdb\u884c\u9000\u8d27\u63d0\u4ea4\uff01");
        }
        log.info("\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5\u4fe1\u606f{}", (Object)JSONObject.toJSONString((Object)ordersDetails));
        log.info("\u6821\u9a8c\u662f\u5426\u5b58\u5728\u9000\u8d27\u8ba2\u5355,\u8ba2\u5355\u53f7:{}", (Object)refundOrder.getOrderNo());
        Example refundExample = new Example(IntegralRefundOrder.class);
        refundExample.createCriteria().andEqualTo("orderNo", (Object)refundOrder.getOrderNo()).andEqualTo("valid", (Object)Boolean.TRUE);
        IntegralRefundOrder oldRefundOrders = (IntegralRefundOrder)this.integralRefundOrderMapper.selectOneByExample((Object)refundExample);
        if (oldRefundOrders != null) {
            throw new CustomException("\u5df2\u5b58\u5728\u9000\u8d27\u8ba2\u5355,\u65e0\u6cd5\u8fdb\u884c\u9000\u8d27\u63d0\u4ea4\uff01");
        }
        refundOrder.setRefundNo(IntegralOrderNoUtil.getRefundOrderNo());
        refundOrder.setRefundIntegral(ordersDetails.getSaleIntegral());
        refundOrder.setRefundQuantity(ordersDetails.getSaleQuantity());
        refundOrder.setGmtCreate(new Date());
        String cancel = "0";
        if (cancel.equals(refundOrder.getRefundType())) {
            refundOrder.setMemberCode(orders.getMemberCode());
            RestResult result = this.bizvaneInterface.refundIntegralChange(refundOrder);
            int success = 0;
            if (success == result.getCode()) {
                refundOrder.setRefundStatus("1");
                refundOrder.setRefundTime(new Date());
                refundOrder.setAuditStatus("1");
                refundOrder.setAuditTime(new Date());
                refundOrder.setAuditReback("\u53d6\u6d88\u8ba2\u5355");
                Example exampleSku = new Example(IntegralGoodsSku.class);
                exampleSku.createCriteria().andEqualTo("skuNo", (Object)ordersDetails.getGoodsSkuNo()).andEqualTo("valid", (Object)Boolean.TRUE);
                IntegralGoodsSku sku = (IntegralGoodsSku)this.integralGoodsSkuMapper.selectOneByExample((Object)exampleSku);
                if (sku != null) {
                    sku.setStock(Integer.valueOf(sku.getStock() + ordersDetails.getSaleQuantity()));
                    this.integralGoodsSkuMapper.updateByPrimaryKey((Object)sku);
                }
                IntegralGoods integralGoods = (IntegralGoods)this.integralGoodsMapper.selectByPrimaryKey((Object)ordersDetails.getGoodId());
                integralGoods.setActualSales(Integer.valueOf(integralGoods.getActualSales() - ordersDetails.getSaleQuantity()));
                this.integralGoodsMapper.updateByPrimaryKey((Object)integralGoods);
            }
        } else {
            refundOrder.setAuditor(null);
            refundOrder.setAuditStatus("0");
        }
        this.integralRefundOrderMapper.insertSelective((Object)refundOrder);
        orders.setOrderStatus(IntegralOrdersStatusEnum.RETURNED_GOODS.getCode());
        orders.setGmtModified(new Date());
        this.integralOrdersMapper.updateByPrimaryKeySelective((Object)orders);
        log.info("\u63d0\u4ea4\u9000\u8d27\u8ba2\u5355\u3002\u3002\u3002\u3002\u3002\u3002\u3002END................");
        return refundOrder;
    }

    @Transactional(rollbackFor={Exception.class})
    public IntegralRefundOrder submitRefundLogistics(IntegralRefundOrder refundOrder) {
        log.info("\u63d0\u4ea4\u9000\u8d27\u7269\u6d41\u4fe1\u606f\u3002\u3002\u3002\u3002\u3002\u3002\u3002START................");
        Example example = new Example(IntegralRefundOrder.class);
        example.createCriteria().andEqualTo("refundNo", (Object)refundOrder.getRefundNo()).andEqualTo("valid", (Object)Boolean.TRUE);
        IntegralRefundOrder integralRefundOrder = (IntegralRefundOrder)this.integralRefundOrderMapper.selectOneByExample((Object)example);
        if (integralRefundOrder == null) {
            throw new CustomException("\u6b64\u9000\u8d27\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        }
        String unAudited = "1";
        if (!unAudited.equals(integralRefundOrder.getAuditStatus())) {
            throw new CustomException("\u6b64\u9000\u8d27\u8ba2\u5355\u672a\u5ba1\u6838\u901a\u8fc7\uff01");
        }
        integralRefundOrder.setRefundCompanyCode(refundOrder.getRefundCompanyCode());
        integralRefundOrder.setRefundShippingCompany(refundOrder.getRefundShippingCompany());
        integralRefundOrder.setRefundShippingNo(refundOrder.getRefundShippingNo());
        integralRefundOrder.setGmtModified(new Date());
        integralRefundOrder.setRefundStatus("0");
        this.integralRefundOrderMapper.updateByPrimaryKeySelective((Object)integralRefundOrder);
        Example orderExample = new Example(IntegralOrders.class);
        orderExample.createCriteria().andEqualTo("orderNo", (Object)integralRefundOrder.getOrderNo()).andEqualTo("valid", (Object)Boolean.TRUE);
        IntegralOrders orders = (IntegralOrders)this.integralOrdersMapper.selectOneByExample((Object)orderExample);
        orders.setGmtModified(new Date());
        this.integralOrdersMapper.updateByPrimaryKeySelective((Object)orders);
        return integralRefundOrder;
    }
}

