/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSONObject;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.wmeimob.fastboot.bizvane.entity.CompanyBrandRelation;
import com.wmeimob.fastboot.bizvane.entity.Config;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.enums.LogisticsStatusEnum;
import com.wmeimob.fastboot.bizvane.mapper.CompanyBrandRelationMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSkuDetailMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrdersMapper;
import com.wmeimob.fastboot.bizvane.mapper.RefundOrderMapper;
import com.wmeimob.fastboot.bizvane.service.ConfigService;
import com.wmeimob.fastboot.bizvane.service.OrdersService;
import com.wmeimob.fastboot.bizvane.service.OrdersServiceImpl;
import com.wmeimob.fastboot.bizvane.service.UnderLineService;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.util.InputValidator;
import com.wmeimob.fastboot.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

@RestController
@RequestMapping(value={"/underLine"})
public class UnderLineController {
    private static final Logger log = LoggerFactory.getLogger(UnderLineController.class);
    @Autowired
    private UnderLineService underLineService;
    @Autowired
    private OrdersServiceImpl ordersServiceImpl;
    @Autowired
    private CompanyBrandRelationMapper companyBrandRelationMapper;
    @Autowired
    private OrdersMapper ordersMapper;
    @Resource
    private ConfigService configService;
    @Resource(name="commonOrdersServiceImpl")
    private OrdersService commonOrdersService;
    @Resource
    private GoodsSkuDetailMapper goodsSkuDetailMapper;
    @Resource
    private RefundOrderMapper refundOrderMapper;
    private static final ScheduledThreadPoolExecutor SCHEDULE = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("wechat-loreal-global-pool-%d").build());

    @RequestMapping(value={"/getUnSendOrders"}, method={RequestMethod.GET})
    public Map getUnPayOrders(@RequestParam(value="token") String token) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String decrypt = this.underLineService.decrypt(token);
        if (!decrypt.contains(",")) {
            map.put("code", RestResult.fail().getCode());
            map.put("msg", "\u52a0\u5bc6\u683c\u5f0f\u6709\u8bef");
            return map;
        }
        String brandCode = decrypt.split(",")[0];
        String key = decrypt.split(",")[1];
        log.info("\u7ebf\u4e0b\u62c9\u53d6\u672a\u53d1\u8d27\u8ba2\u5355\uff0cbrandCode:{}", (Object)brandCode);
        Example example = new Example(CompanyBrandRelation.class);
        example.createCriteria().andEqualTo("merchantCode", (Object)brandCode);
        CompanyBrandRelation companyBrandRelation = (CompanyBrandRelation)this.companyBrandRelationMapper.selectOneByExample((Object)example);
        if (companyBrandRelation == null) {
            map.put("code", RestResult.fail().getCode());
            map.put("msg", "\u6b64\u54c1\u724c\u672a\u5728\u5fae\u5546\u57ce\u8bbe\u7f6e\u3002");
            return map;
        }
        if (!companyBrandRelation.getAuthenticationKey().equals(key)) {
            map.put("code", RestResult.fail().getCode());
            map.put("msg", "key\u65e0\u6743\u9650\u3002");
            return map;
        }
        Orders condition = new Orders();
        condition.setMerchantId(companyBrandRelation.getMerchantId());
        condition.setQueryStatus(Integer.valueOf(2));
        List<Orders> list = this.ordersServiceImpl.findByCondition(condition);
        map.put("code", 0);
        map.put("msg", "\u64cd\u4f5c\u6210\u529f");
        map.put("data", list);
        return map;
    }

    @PostMapping(value={"/setUpSendGoods"})
    public RestResult setUpSendGoods(@RequestBody JSONObject jsonObject) {
        log.info("\u7ebf\u4e0b\u540c\u6b65\u53d1\u8d27\u63a5\u53e3\uff0c\u53c2\u6570\u4e3a\uff1a{}", (Object)jsonObject.toJSONString());
        String token = jsonObject.getString("token");
        String decrypt = this.underLineService.decrypt(token);
        if (!decrypt.contains(",")) {
            throw new CustomException("\u52a0\u5bc6\u683c\u5f0f\u6709\u8bef");
        }
        String brandCode = decrypt.split(",")[0];
        String key = decrypt.split(",")[1];
        if (StringUtils.isEmpty((Object)brandCode)) {
            throw new CustomException("\u53c2\u6570\u6709\u8bef\uff01");
        }
        if (StringUtils.isEmpty((Object)key)) {
            throw new CustomException("\u53c2\u6570\u6709\u8bef\uff01");
        }
        Example comExample = new Example(CompanyBrandRelation.class);
        comExample.createCriteria().andEqualTo("merchantCode", (Object)brandCode);
        CompanyBrandRelation companyBrandRelation = (CompanyBrandRelation)this.companyBrandRelationMapper.selectOneByExample((Object)comExample);
        if (companyBrandRelation == null) {
            throw new CustomException("\u6b64\u54c1\u724c\u672a\u5728\u5fae\u5546\u57ce\u8bbe\u7f6e");
        }
        if (!companyBrandRelation.getAuthenticationKey().equals(key)) {
            throw new CustomException("key\u65e0\u6743\u9650");
        }
        String orderNo = jsonObject.getString("orderNo");
        InputValidator.checkEmpty((Object)orderNo, (String)"orderNo");
        String shippingVendor = jsonObject.getString("shippingVendor");
        InputValidator.checkEmpty((Object)shippingVendor, (String)"shippingVendor");
        String shippingNo = jsonObject.getString("shippingNo");
        InputValidator.checkLengthRange((Object)shippingNo, (int)0, (int)20, (String)"\u5feb\u9012\u5355\u53f7");
        if (!Pattern.matches("^[a-zA-Z0-9\\-]+$", shippingNo)) {
            return RestResult.fail((String)"\u5feb\u9012\u5355\u53f7\u53c2\u6570\u5f02\u5e38");
        }
        Example example = new Example(Orders.class);
        example.createCriteria().andEqualTo("orderNo", (Object)orderNo);
        Orders orders = (Orders)this.ordersMapper.selectOneByExample((Object)example);
        if (orders == null) {
            return RestResult.fail((String)"\u6b64\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728\uff01");
        }
        if (orders.getLogisticsStatus() != null && orders.getLogisticsStatus().equals((Object)LogisticsStatusEnum.UN_SEND)) {
            orders.setShippingNo(shippingNo);
            orders.setShippingVendor(shippingVendor);
            orders.setGmtModified(new Date());
            orders.setShippingAt(new Date());
            int result = this.ordersMapper.updateByPrimaryKeySelective((Object)orders);
            if (result > 0) {
                Config sysConfig = this.configService.findSysConfig(orders.getMerchantId());
                orders.setUserId(orders.getUserId());
                orders.setId(orders.getId());
                SCHEDULE.schedule(() -> this.commonOrdersService.confirm(orders), (long)sysConfig.getAwaitOrderConfirm().intValue(), TimeUnit.DAYS);
                return RestResult.success();
            }
        } else {
            return RestResult.fail((String)"\u6b64\u5355\u4e0d\u662f\u5f85\u53d1\u8d27\u8ba2\u5355\uff01");
        }
        RestResult.fail((String)"\u53d1\u8d27\u5931\u8d25");
        return null;
    }

    @PostMapping(value={"/setStock"})
    public RestResult setStock(@RequestBody JSONObject jsonObject) {
        log.info("\u7ebf\u4e0b\u540c\u6b65\u5e93\u5b58\uff0c\u53c2\u6570\u4e3a\uff1a{}", (Object)jsonObject.toJSONString());
        String token = jsonObject.getString("token");
        String decrypt = this.underLineService.decrypt(token);
        if (!decrypt.contains(",")) {
            throw new CustomException("\u52a0\u5bc6\u683c\u5f0f\u6709\u8bef");
        }
        String brandCode = decrypt.split(",")[0];
        String key = decrypt.split(",")[1];
        if (StringUtils.isEmpty((Object)brandCode)) {
            throw new CustomException("\u53c2\u6570\u6709\u8bef\uff01");
        }
        if (StringUtils.isEmpty((Object)key)) {
            throw new CustomException("\u53c2\u6570\u6709\u8bef\uff01");
        }
        Example comExample = new Example(CompanyBrandRelation.class);
        comExample.createCriteria().andEqualTo("merchantCode", (Object)brandCode);
        CompanyBrandRelation companyBrandRelation = (CompanyBrandRelation)this.companyBrandRelationMapper.selectOneByExample((Object)comExample);
        if (companyBrandRelation == null) {
            throw new CustomException("\u6b64\u54c1\u724c\u672a\u5728\u5fae\u5546\u57ce\u8bbe\u7f6e");
        }
        if (!companyBrandRelation.getAuthenticationKey().equals(key)) {
            throw new CustomException("key\u65e0\u6743\u9650");
        }
        String skuNo = jsonObject.getString("skuNo");
        InputValidator.checkEmpty((Object)skuNo, (String)"skuNo");
        Integer stock = jsonObject.getInteger("stock");
        InputValidator.checkEmpty((Object)stock, (String)"stock");
        Example example = new Example(GoodsSkuDetail.class);
        example.createCriteria().andEqualTo("skuNo", (Object)skuNo);
        GoodsSkuDetail detail = (GoodsSkuDetail)this.goodsSkuDetailMapper.selectOneByExample((Object)example);
        if (detail == null) {
            return RestResult.fail((String)("\u6b64sku\u4e0d\u5b58\u5728\uff0cskuNo:" + skuNo));
        }
        if (stock < 0) {
            return RestResult.fail((String)"\u5e93\u5b58\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        detail.setStock(stock);
        int result = this.goodsSkuDetailMapper.updateByPrimaryKeySelective((Object)detail);
        if (result > 0) {
            return RestResult.success();
        }
        return RestResult.fail((String)"\u66f4\u65b0\u5e93\u5b58\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/getRefundOrders"}, method={RequestMethod.GET})
    public Map getRefundOrders(@RequestParam(value="token") String token) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String decrypt = this.underLineService.decrypt(token);
        if (!decrypt.contains(",")) {
            map.put("code", RestResult.fail().getCode());
            map.put("msg", "\u52a0\u5bc6\u683c\u5f0f\u6709\u8bef");
            return map;
        }
        String brandCode = decrypt.split(",")[0];
        String key = decrypt.split(",")[1];
        log.info("\u7ebf\u4e0b\u62c9\u53d6\u9000\u8d27\u8ba2\u5355\uff0cbrandCode:{}", (Object)brandCode);
        Example example = new Example(CompanyBrandRelation.class);
        example.createCriteria().andEqualTo("merchantCode", (Object)brandCode);
        CompanyBrandRelation companyBrandRelation = (CompanyBrandRelation)this.companyBrandRelationMapper.selectOneByExample((Object)example);
        if (companyBrandRelation == null) {
            map.put("code", RestResult.fail().getCode());
            map.put("msg", "\u6b64\u54c1\u724c\u672a\u5728\u5fae\u5546\u57ce\u8bbe\u7f6e\u3002");
            return map;
        }
        if (!companyBrandRelation.getAuthenticationKey().equals(key)) {
            map.put("code", RestResult.fail().getCode());
            map.put("msg", "key\u65e0\u6743\u9650\u3002");
            return map;
        }
        Example query = new Example(RefundOrder.class);
        query.createCriteria().andEqualTo("merchantId", (Object)companyBrandRelation.getMerchantId());
        List list = this.refundOrderMapper.selectByExample((Object)query);
        map.put("code", 0);
        map.put("msg", "\u64cd\u4f5c\u6210\u529f");
        map.put("data", list);
        return map;
    }

    @PostMapping(value={"/setRefund"})
    public RestResult setRefund(@RequestBody JSONObject jsonObject) {
        log.info("\u7ebf\u4e0b\u8bbe\u7f6e\u9000\u8d27\uff0c\u53c2\u6570\u4e3a:{}", (Object)jsonObject.toJSONString());
        String token = jsonObject.getString("token");
        String decrypt = this.underLineService.decrypt(token);
        if (!decrypt.contains(",")) {
            throw new CustomException("\u52a0\u5bc6\u683c\u5f0f\u6709\u8bef");
        }
        String brandCode = decrypt.split(",")[0];
        String key = decrypt.split(",")[1];
        if (StringUtils.isEmpty((Object)brandCode)) {
            throw new CustomException("\u53c2\u6570\u6709\u8bef\uff01");
        }
        if (StringUtils.isEmpty((Object)key)) {
            throw new CustomException("\u53c2\u6570\u6709\u8bef\uff01");
        }
        Example comExample = new Example(CompanyBrandRelation.class);
        comExample.createCriteria().andEqualTo("merchantCode", (Object)brandCode);
        CompanyBrandRelation companyBrandRelation = (CompanyBrandRelation)this.companyBrandRelationMapper.selectOneByExample((Object)comExample);
        if (companyBrandRelation == null) {
            throw new CustomException("\u6b64\u54c1\u724c\u672a\u5728\u5fae\u5546\u57ce\u8bbe\u7f6e");
        }
        if (!companyBrandRelation.getAuthenticationKey().equals(key)) {
            throw new CustomException("key\u65e0\u6743\u9650");
        }
        String refundNo = jsonObject.getString("refundNo");
        InputValidator.checkEmpty((Object)refundNo, (String)"refundNo");
        Example example = new Example(RefundOrder.class);
        example.createCriteria().andEqualTo("refundNo", (Object)refundNo);
        RefundOrder refundOrder = (RefundOrder)this.refundOrderMapper.selectOneByExample((Object)example);
        if (refundOrder == null) {
            return RestResult.fail((String)("\u6b64\u9000\u8d27\u8ba2\u5355\u4e0d\u5b58\u5728\uff0crefundNo:" + refundNo));
        }
        refundOrder.setUnderStatus(Boolean.TRUE);
        int result = this.refundOrderMapper.updateByPrimaryKeySelective((Object)refundOrder);
        if (result > 0) {
            return RestResult.success();
        }
        return RestResult.fail((String)"\u8bbe\u7f6e\u9000\u8d27\u8ba2\u5355\u5931\u8d25\uff01");
    }
}

