/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.entity.MarketActivity;
import com.wmeimob.fastboot.bizvane.service.MarketActivityService;
import com.wmeimob.fastboot.core.annotation.Page;
import com.wmeimob.fastboot.core.rest.RestResult;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"marketActivity"})
public class MarketActivityController {
    private static final Logger log = LoggerFactory.getLogger(MarketActivityController.class);
    @Autowired
    private MarketActivityService marketActivityService;

    @PostMapping(value={"saveActivity"})
    public RestResult saveActivity(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody MarketActivity marketActivity) {
        marketActivity.setMerchantId(merchantId);
        return this.marketActivityService.saveActivity(marketActivity);
    }

    @Page
    @GetMapping
    public PageInfo list(@RequestHeader(value="merchantId") Integer merchantId, MarketActivity marketActivity) {
        log.info("\u8425\u9500\u6d3b\u52a8\u5206\u9875\u5217\u8868");
        marketActivity.setMerchantId(merchantId);
        List<MarketActivity> list = this.marketActivityService.getAllList(marketActivity);
        return new PageInfo(list);
    }

    @GetMapping(value={"{id}"})
    public MarketActivity getDetail(@PathVariable(value="id") Integer id) {
        return this.marketActivityService.getDetail(id);
    }
}

