/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.integral;

import com.wmeimob.fastboot.bizvane.entity.ImportEntity;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

/*
 * Exception performing whole class analysis ignored.
 */
public class IntegralExcelImportUtils {
    public static List<ImportEntity> parseExcel(InputStream fis) throws FileNotFoundException, ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        HSSFWorkbook wookbook = null;
        ArrayList<ImportEntity> list = new ArrayList<ImportEntity>();
        try {
            wookbook = new HSSFWorkbook(fis);
        }
        catch (Exception ex) {
            try {
                wookbook = new XSSFWorkbook(fis);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Sheet sheet = wookbook.getSheetAt(0);
        int lastRowNum = sheet.getLastRowNum();
        block4: for (int j = 1; j <= lastRowNum; ++j) {
            Row row = sheet.getRow(j);
            ImportEntity entity = new ImportEntity();
            int lastCellNum = row.getLastCellNum();
            if (row == null) continue;
            for (int x = 0; x < lastCellNum; ++x) {
                Cell cell = row.getCell(x);
                if (cell == null) continue;
                String value = IntegralExcelImportUtils.getCellValue((Cell)cell);
                if (StringUtils.isBlank((String)value)) break block4;
                if (x == 1) {
                    entity.setOrderNo(value);
                    continue;
                }
                if (x == 2) {
                    entity.setGoodsNo(value);
                    continue;
                }
                if (x == 3) {
                    entity.setGoodName(value);
                    continue;
                }
                if (x == 4) {
                    entity.setCoupon(value);
                    continue;
                }
                if (x == 6) {
                    entity.setSpecification(value);
                    continue;
                }
                if (x == 7) {
                    entity.setExchangeCounts(value);
                    continue;
                }
                if (x == 8) {
                    entity.setExchangeNums(value);
                    continue;
                }
                if (x == 9) {
                    entity.setExchangeTotalNums(value);
                    continue;
                }
                if (x == 10) {
                    entity.setExchangeTime(sdf.parse(value));
                    continue;
                }
                if (x == 11) {
                    entity.setOrderStatus(IntegralExcelImportUtils.parseStatus((String)value));
                    continue;
                }
                if (x == 13) {
                    entity.setOnlineCardNo(value);
                    continue;
                }
                if (x == 14) {
                    entity.setMemberCode(value);
                    continue;
                }
                if (x == 15) {
                    entity.setPhone(value);
                    continue;
                }
                if (x == 16) {
                    entity.setMemberName(value);
                    continue;
                }
                if (x == 18) {
                    entity.setContactName(value);
                    continue;
                }
                if (x == 19) {
                    entity.setContactPhone(value);
                    continue;
                }
                if (x == 20) {
                    entity.setProvince(value);
                    continue;
                }
                if (x == 21) {
                    entity.setCity(value);
                    continue;
                }
                if (x == 22) {
                    entity.setArea(value);
                    continue;
                }
                if (x == 23) {
                    entity.setAddress(value);
                    continue;
                }
                if (x != 24) continue;
                entity.setServiceStore(value);
            }
            list.add(entity);
        }
        return list;
    }

    public static String parseStatus(String cn) {
        switch (cn) {
            case "\u5f85\u53d1\u8d27": {
                return "0";
            }
            case "\u5df2\u53d1\u8d27": {
                return "1";
            }
        }
        return "";
    }

    private static String getCellValue(Cell cell) {
        Object result = "";
        DecimalFormat df = new DecimalFormat("#.##");
        if (cell != null) {
            switch (cell.getCellType()) {
                case 1: {
                    result = cell.getStringCellValue();
                    break;
                }
                case 0: {
                    if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:ss");
                        return sdf.format(HSSFDateUtil.getJavaDate((double)cell.getNumericCellValue()));
                    }
                    result = df.format(cell.getNumericCellValue());
                    break;
                }
                case 4: {
                    result = cell.getBooleanCellValue();
                    break;
                }
                case 2: {
                    result = cell.getCellFormula();
                    break;
                }
                case 5: {
                    result = cell.getErrorCellValue();
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
        return result.toString();
    }
}

