/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.integral_wx;

import com.wmeimob.fastboot.bizvane.entity.IntegralOrders;
import com.wmeimob.fastboot.bizvane.service.IntegralOrdersService;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.util.InputValidator;
import com.wmeimob.fastboot.util.StringUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wx/orders"})
public class WxIntegralOrdersController {
    private static final Logger log = LoggerFactory.getLogger(WxIntegralOrdersController.class);
    @Autowired
    private IntegralOrdersService integralOrdersService;

    @RequestMapping(value={"/confirmGoods"}, method={RequestMethod.POST})
    public RestResult confirmGoods(@RequestBody IntegralOrders integralOrders) {
        IntegralOrders orders;
        log.info("\u786e\u8ba4\u4e0b\u5355...");
        InputValidator.checkEmpty((Object)integralOrders.getMerchantId(), (String)"\u54c1\u724cid");
        InputValidator.checkEmpty((Object)integralOrders.getMemberCode(), (String)"\u4f1a\u5458code");
        InputValidator.checkEmpty((Object)integralOrders.getMemberCardNo(), (String)"\u4f1a\u5458\u5361\u53f7");
        InputValidator.checkEmpty((Object)integralOrders.getMemberPhone(), (String)"\u4f1a\u5458\u7535\u8bdd");
        InputValidator.checkEmpty((Object)integralOrders.getGoodId(), (String)"\u5546\u54c1id");
        InputValidator.checkEmpty((Object)integralOrders.getSaleQuantity(), (String)"\u8d2d\u4e70\u6570\u91cf");
        if (integralOrders.getSaleQuantity() < 1) {
            throw new CustomException("\u8d2d\u4e70\u6570\u91cf\u4e0d\u5f97\u5c0f\u4e8e1\u4ef6\u3002");
        }
        InputValidator.checkEmpty((Object)integralOrders.getGoodSkuNo(), (String)"\u5546\u54c1sku\u7f16\u53f7");
        if ("0".equals(this.integralOrdersService.getDistributionModeBySkuNo(integralOrders.getGoodSkuNo()))) {
            this.checkEmptyByShipping(integralOrders);
        }
        return (orders = this.integralOrdersService.confirm(integralOrders)) == null ? RestResult.fail() : RestResult.success();
    }

    @RequestMapping(value={"/getOrderListByStatus/{merchantId}/{orderStatus}/{memberCode}"}, method={RequestMethod.GET})
    public List<IntegralOrders> getOrderListByStatus(@PathVariable(value="merchantId") Integer merchantId, @PathVariable(value="orderStatus") String orderStatus, @PathVariable(value="memberCode") String memberCode) {
        log.info("\u67e5\u8be2\u8ba2\u5355\u5217\u8868...");
        log.info("merchantId/orderStatus/memberCode:{}", (Object)(merchantId + "/" + orderStatus + "/" + memberCode));
        return this.integralOrdersService.getOrderListByStatus(merchantId, orderStatus, memberCode);
    }

    @RequestMapping(value={"/getOrderById/{orderId}"}, method={RequestMethod.GET})
    public IntegralOrders getOrderById(@PathVariable(value="orderId") Integer orderId) {
        log.info("\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5...");
        return this.integralOrdersService.getOrderById(orderId);
    }

    private void checkEmptyByShipping(IntegralOrders integralOrders) {
        if (StringUtils.isEmpty((Object)integralOrders.getShippingName()) || StringUtils.isEmpty((Object)integralOrders.getShippingMobile()) || StringUtils.isEmpty((Object)integralOrders.getShippingProvince()) || StringUtils.isEmpty((Object)integralOrders.getShippingCity()) || StringUtils.isEmpty((Object)integralOrders.getShippingDistrict()) || StringUtils.isEmpty((Object)integralOrders.getShippingAddress())) {
            throw new CustomException("\u8bf7\u5b8c\u5584\u6536\u8d27\u4fe1\u606f\uff01");
        }
    }
}

