/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.autoconfigure.wechat.WechatProperties;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.entity.OrderGift;
import com.wmeimob.fastboot.bizvane.entity.OrderItems;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.entity.WechatMchNew;
import com.wmeimob.fastboot.bizvane.enums.LogisticsStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.OperationTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.RefundStatus;
import com.wmeimob.fastboot.bizvane.mapper.OrderGiftMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrderItemsMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrdersMapper;
import com.wmeimob.fastboot.bizvane.mapper.RefundOrderMapper;
import com.wmeimob.fastboot.bizvane.mapper.WechatMchNewMapper;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.GoodsSkuDetailService;
import com.wmeimob.fastboot.bizvane.service.OrdersService;
import com.wmeimob.fastboot.bizvane.service.RefundOrderService;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.open.service.MiniprogramService;
import com.wmeimob.fastboot.starter.wechat.service.WechatService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import me.hao0.wechat.model.base.WechatMch;
import me.hao0.wechat.model.base.WechatMp;
import me.hao0.wepay.core.Wepay;
import me.hao0.wepay.exception.WepayException;
import me.hao0.wepay.model.enums.RefundAccount;
import me.hao0.wepay.model.refund.RefundApplyRequest;
import me.hao0.wepay.model.refund.RefundApplyResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class RefundOrderServiceImpl
implements RefundOrderService {
    private static final Logger log = LoggerFactory.getLogger(RefundOrderServiceImpl.class);
    @Autowired
    private RefundOrderMapper refundOrderMapper;
    @Autowired
    private OrderItemsMapper orderItemsMapper;
    @Autowired
    private OrderGiftMapper orderGiftMapper;
    @Resource
    private OrdersService ordersService;
    @Resource
    private WechatService wechatService;
    @Resource
    private WechatProperties wechatProperties;
    @Resource
    private MiniprogramService miniprogramService;
    @Resource(name="commonOrdersServiceImpl")
    private OrdersService commonOrdersServiceImpl;
    @Resource
    private GoodsSkuDetailService goodsSkuDetailService;
    @Resource
    private WechatMchNewMapper wechatMchNewMapper;
    @Resource
    private BizvaneInterface bizvaneInterface;
    @Resource
    private OrdersMapper ordersMapper;

    public List<RefundOrder> findByCondition(RefundOrder condition) {
        return this.refundOrderMapper.findList(condition);
    }

    public int update(RefundOrder refundOrder) {
        Date date = new Date();
        refundOrder.setAuditAt(date);
        if (refundOrder.getAuditStatus() == 1) {
            Orders orders = (Orders)this.ordersService.findById(refundOrder.getOrderNo());
            if (orders.getLogisticsStatus().equals((Object)LogisticsStatusEnum.UN_SEND)) {
                Orders commonOrders = (Orders)this.commonOrdersServiceImpl.findById(orders.getId());
                List customSkuInfo = this.convertToSkuInfo(commonOrders.getItems());
                customSkuInfo.forEach(o -> o.setStock(Integer.valueOf(-o.getStock().intValue())));
                this.goodsSkuDetailService.inventoryReduction(customSkuInfo);
            }
            OrderGift orderGift = new OrderGift();
            Example example = new Example(OrderGift.class);
            example.createCriteria().andEqualTo("orderItemId", (Object)refundOrder.getItemId());
            orderGift.setHasRefund(Boolean.valueOf(refundOrder.getIsGift() == null));
            this.orderGiftMapper.updateByExampleSelective((Object)orderGift, (Object)example);
            OrderItems orderItems = (OrderItems)this.orderItemsMapper.selectByPrimaryKey((Object)refundOrder.getItemId());
            if (refundOrder.getRefundAmount().compareTo(orderItems.getWepayAmount()) == 1) {
                throw new CustomException("\u9000\u6b3e\u91d1\u989d\u9519\u8bef\uff0c\u5e94\u4e3a\uff1a" + orderItems.getWepayAmount());
            }
            refundOrder.setAuditor(refundOrder.getNickName());
            if (refundOrder.getRefundIntegral() == null) {
                refundOrder.setRefundIntegral(Integer.valueOf(0));
            } else if (refundOrder.getRefundIntegral() > orderItems.getDeductionIntegral()) {
                throw new CustomException("\u9000\u6b3e\u79ef\u5206\u9519\u8bef\uff0c\u5e94\u4e3a\uff1a" + orderItems.getDeductionIntegral());
            }
            if (refundOrder.getRefundBalance() == null) {
                refundOrder.setRefundBalance(BigDecimal.ZERO);
            } else if (refundOrder.getRefundBalance().compareTo(orderItems.getDeductionBalance()) == 1) {
                throw new CustomException("\u9000\u6b3e\u4f59\u989d\u9519\u8bef\uff0c\u5e94\u4e3a\uff1a" + orderItems.getDeductionBalance());
            }
        }
        return this.refundOrderMapper.updateByPrimaryKeySelective((Object)refundOrder);
    }

    public RefundOrder findById(Integer id) {
        RefundOrder refundOrder = this.refundOrderMapper.selectRefundOrderDetailById(id);
        Example example = new Example(Orders.class);
        example.createCriteria().andEqualTo("orderNo", (Object)refundOrder.getOrderNo());
        Orders orders = (Orders)this.ordersMapper.selectOneByExample((Object)example);
        if (orders == null) {
            return refundOrder;
        }
        refundOrder.setShippingFee(orders.getShippingFee());
        refundOrder.setShippingDeduction(orders.getShippingDeduction());
        return refundOrder;
    }

    public int updateRefundStatus(Integer merchantId, Integer id) {
        BigDecimal banlance;
        Integer redundIntegral;
        RefundOrder refundOrder = (RefundOrder)this.refundOrderMapper.selectByPrimaryKey((Object)id);
        OrderItems orderItems = (OrderItems)this.orderItemsMapper.selectByPrimaryKey((Object)refundOrder.getItemId());
        if (refundOrder.getRefundAmount().compareTo(BigDecimal.ZERO) == 1) {
            Example example = new Example(WechatMchNew.class);
            example.createCriteria().andEqualTo("merchantId", (Object)merchantId);
            WechatMchNew mchNew = (WechatMchNew)this.wechatMchNewMapper.selectOneByExample((Object)example);
            if (mchNew == null) {
                throw new CustomException("\u54c1\u724cID:" + merchantId + ",\u672a\u64cd\u4f5c\u5fae\u4fe1\u652f\u4ed8\u914d\u7f6e");
            }
            WechatMp wechatMp = new WechatMp();
            wechatMp.setAppid(mchNew.getAppId());
            WechatMch wechatMch = new WechatMch();
            wechatMch.setMchKey(mchNew.getMchKey());
            wechatMch.setMchNo(mchNew.getMchNo());
            wechatMch.setP12(mchNew.getP12());
            Wepay wepay = this.wechatService.getWepay(wechatMp, wechatMch);
            RefundApplyRequest refundApplyRequest = new RefundApplyRequest();
            refundApplyRequest.setOutTradeNo(refundOrder.getOrderNo());
            refundApplyRequest.setOutRefundNo(refundOrder.getRefundNo());
            refundApplyRequest.setRefundFee(Integer.valueOf(refundOrder.getRefundAmount().multiply(new BigDecimal("100")).intValue()));
            refundApplyRequest.setOpUserId(refundOrder.getAuditor());
            refundApplyRequest.setRefundDesc(refundOrder.getRefundReason());
            refundApplyRequest.setNotifyUrl((String)this.wechatProperties.getUrls().get("refund-notify"));
            refundApplyRequest.setRefundAccount(RefundAccount.REFUND_SOURCE_UNSETTLED_FUNDS);
            Orders orders = (Orders)this.ordersService.findById(refundOrder.getOrderNo());
            refundApplyRequest.setTotalFee(Integer.valueOf(orders.getPayAmount().multiply(new BigDecimal("100")).intValue()));
            log.info("\u5fae\u4fe1\u9000\u6b3e\u8bf7\u6c42\u4f53===>{}", (Object)JSONObject.toJSONString((Object)refundApplyRequest));
            try {
                RefundApplyResponse refundApplyResponse = wepay.refund().apply(refundApplyRequest);
                log.info("wexin pay refund result => {}", (Object)JSONObject.toJSONString((Object)refundApplyResponse));
            }
            catch (WepayException e) {
                throw new CustomException(e.getMessage());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
                return -1;
            }
        }
        if ((redundIntegral = refundOrder.getRefundIntegral()) > 0) {
            RestResult restResult;
            if (redundIntegral > orderItems.getDeductionIntegral()) {
                redundIntegral = orderItems.getDeductionIntegral();
            }
            if ((restResult = this.bizvaneInterface.operationIntegral(refundOrder.getUserNo(), redundIntegral, OperationTypeEnum.ADD.getCode(), refundOrder.getRefundNo())).getCode() != 0) {
                return -1;
            }
        }
        if ((banlance = refundOrder.getRefundBalance()).compareTo(BigDecimal.ZERO) == 1) {
            RestResult restResult;
            if (banlance.compareTo(orderItems.getDeductionBalance()) == 1) {
                banlance = orderItems.getDeductionBalance();
            }
            if ((restResult = this.bizvaneInterface.operationBalance(refundOrder.getUserNo(), banlance, OperationTypeEnum.ADD.getCode(), refundOrder.getRefundNo())).getCode() != 0) {
                return -1;
            }
        }
        orderItems.setRefundStatus(RefundStatus.SUCCESS);
        return this.orderItemsMapper.updateByPrimaryKeySelective((Object)orderItems);
    }

    private List<GoodsSkuDetail> convertToSkuInfo(List<OrderItems> orderItems) {
        ArrayList<GoodsSkuDetail> skuInfoList = new ArrayList<GoodsSkuDetail>();
        for (OrderItems item : orderItems) {
            GoodsSkuDetail skuInfo = new GoodsSkuDetail();
            skuInfo.setGoodsId(item.getGoodsId());
            skuInfo.setSkuNo(item.getGoodsSkuNo());
            skuInfo.setGoodsName(item.getGoodsName());
            skuInfo.setStock(item.getSaleQuantity());
            skuInfoList.add(skuInfo);
        }
        return skuInfoList;
    }
}

