/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.dto.integral.CityInfoDTO;
import com.wmeimob.fastboot.bizvane.dto.integral.ProvinceInfoDTO;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoods;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoodsSku;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrders;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrdersDetails;
import com.wmeimob.fastboot.bizvane.entity.IntegralRefundOrder;
import com.wmeimob.fastboot.bizvane.enums.IntegralOrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsSkuMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralOrdersDetailsMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralOrdersMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralRefundOrderMapper;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.IntegralOrdersService;
import com.wmeimob.fastboot.bizvane.util.IntegralOrderNoUtil;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.starter.common.entity.CityInfo;
import com.wmeimob.fastboot.starter.common.mapper.CityInfoMapper;
import com.wmeimob.fastboot.util.InputValidator;
import com.wmeimob.fastboot.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
public class IntegralOrdersServiceImpl
implements IntegralOrdersService {
    private static final Logger log = LoggerFactory.getLogger(IntegralOrdersServiceImpl.class);
    @Autowired
    private IntegralOrdersMapper integralOrdersMapper;
    @Autowired
    private IntegralRefundOrderMapper integralRefundOrderMapper;
    @Resource
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private IntegralOrdersDetailsMapper integralOrdersDetailsMapper;
    @Autowired
    private IntegralGoodsMapper integralGoodsMapper;
    @Autowired
    private IntegralGoodsSkuMapper integralGoodsSkuMapper;
    @Autowired
    private CityInfoMapper cityInfoMapper;
    @Resource
    private RedisTemplate redisTemplate;

    public List<IntegralOrders> getOrdersList(IntegralOrders integralOrders) {
        InputValidator.checkEmpty((Object)integralOrders.getMerchantId(), (String)"\u54c1\u724cid");
        return this.integralOrdersMapper.getOrders(integralOrders);
    }

    public IntegralOrders setCourier(IntegralOrders integralOrders) {
        IntegralOrders orders = (IntegralOrders)this.integralOrdersMapper.selectByPrimaryKey((Object)integralOrders.getId());
        if (orders == null) {
            throw new CustomException("\u65e0\u6b64\u8ba2\u5355");
        }
        if (!orders.getOrderStatus().equals(IntegralOrdersStatusEnum.UN_SHIPPED.getCode())) {
            if (orders.getOrderStatus().equals(IntegralOrdersStatusEnum.SHIPPED.getCode())) {
                throw new CustomException("\u8be5\u8ba2\u5355\u5df2\u7ecf\u53d1\u8d27");
            }
            throw new CustomException("\u8be5\u8ba2\u5355\u5df2\u53d6\u6d88");
        }
        orders.setCourierCompanyName(integralOrders.getCourierCompanyName());
        orders.setCourierCompanyCode(integralOrders.getCourierCompanyCode());
        orders.setCourierNo(integralOrders.getCourierNo());
        orders.setGmtModified(new Date());
        orders.setOrderStatus(IntegralOrdersStatusEnum.SHIPPED.getCode());
        orders.setSendGoodTime(new Date());
        this.integralOrdersMapper.updateByPrimaryKey((Object)orders);
        return orders;
    }

    public IntegralOrders updateCourierAddress(IntegralOrders integralOrders) {
        IntegralOrders orders = (IntegralOrders)this.integralOrdersMapper.selectByPrimaryKey((Object)integralOrders.getId());
        if (!orders.getOrderStatus().equals(IntegralOrdersStatusEnum.UN_SHIPPED.getCode())) {
            if (orders.getOrderStatus().equals(IntegralOrdersStatusEnum.SHIPPED.getCode())) {
                throw new CustomException("\u8be5\u8ba2\u5355\u5df2\u7ecf\u53d1\u8d27");
            }
            throw new CustomException("\u8be5\u8ba2\u5355\u5df2\u53d6\u6d88");
        }
        orders.setShippingName(integralOrders.getShippingName());
        orders.setShippingMobile(integralOrders.getShippingMobile());
        orders.setShippingProvince(integralOrders.getShippingProvince());
        orders.setShippingCity(integralOrders.getShippingCity());
        orders.setShippingDistrict(integralOrders.getShippingDistrict());
        orders.setShippingAddress(integralOrders.getShippingAddress());
        orders.setGmtModified(new Date());
        this.integralOrdersMapper.updateByPrimaryKey((Object)orders);
        return orders;
    }

    @Transactional
    public IntegralOrders auditor(IntegralRefundOrder integralRefundOrder) {
        Integer refundId = integralRefundOrder.getId();
        IntegralRefundOrder refundOrder = (IntegralRefundOrder)this.integralRefundOrderMapper.selectByPrimaryKey((Object)refundId);
        String orderNo = refundOrder.getOrderNo();
        Integer brandId = refundOrder.getMerchantId();
        Example example = new Example(IntegralOrders.class);
        example.createCriteria().andEqualTo("merchantId", (Object)brandId).andEqualTo("orderNo", (Object)orderNo).andEqualTo("valid", (Object)Boolean.TRUE);
        IntegralOrders orders = (IntegralOrders)this.integralOrdersMapper.selectOneByExample((Object)example);
        if (orders == null) {
            throw new CustomException("\u6b64\u9000\u8d27\u8ba2\u5355\u65e0\u8ba2\u5355\uff01");
        }
        refundOrder.setAuditor(integralRefundOrder.getAuditor());
        refundOrder.setAuditTime(new Date());
        refundOrder.setAuditReback(integralRefundOrder.getAuditReback());
        refundOrder.setGmtModified(new Date());
        if (integralRefundOrder.getAuditType().equals(Boolean.TRUE)) {
            if (StringUtils.isEmpty((Object)integralRefundOrder.getAuditReback())) {
                refundOrder.setAuditReback("\u5ba1\u6279\u901a\u8fc7\uff01");
            }
            orders.setGmtModified(new Date());
            refundOrder.setAuditStatus("1");
        } else {
            if (StringUtils.isEmpty((Object)integralRefundOrder.getAuditReback())) {
                refundOrder.setAuditReback("\u5ba1\u6279\u9a73\u56de\uff01");
            }
            orders.setGmtModified(new Date());
            refundOrder.setAuditStatus("2");
            refundOrder.setRefundStatus("2");
        }
        this.integralOrdersMapper.updateByPrimaryKeySelective((Object)orders);
        this.integralRefundOrderMapper.updateByPrimaryKeySelective((Object)refundOrder);
        return orders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public IntegralOrders refund(String orderNo, Integer merchantId, String staffName, String storeName) {
        IntegralOrders order = new IntegralOrders();
        order.setOrderNo(orderNo);
        order.setValid(Boolean.valueOf(true));
        order.setMerchantId(merchantId);
        List ordersList = this.integralOrdersMapper.getOrders(order);
        if (ordersList.size() == 0) {
            throw new CustomException("\u6b64\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728\uff01");
        }
        IntegralOrders orders = (IntegralOrders)ordersList.get(0);
        log.info("\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)orders));
        Example refundExample = new Example(IntegralRefundOrder.class);
        refundExample.createCriteria().andEqualTo("orderNo", (Object)orderNo).andEqualTo("valid", (Object)Boolean.TRUE);
        IntegralRefundOrder refundOrder = null;
        IntegralOrdersServiceImpl integralOrdersServiceImpl = this;
        synchronized (integralOrdersServiceImpl) {
            refundOrder = (IntegralRefundOrder)this.integralRefundOrderMapper.selectOneByExample((Object)refundExample);
            if (refundOrder == null) {
                throw new CustomException("\u6b64\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728\u9000\u8d27\u4fe1\u606f\uff01");
            }
            if ("1".equals(refundOrder.getRefundStatus())) {
                throw new CustomException("\u6b64\u8ba2\u5355\u5df2\u7ecf\u6210\u529f\u9000\u8d27\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u9000\u8d27\uff01");
            }
        }
        refundOrder.setMemberCode(orders.getMemberCode());
        RestResult result = this.bizvaneInterface.refundIntegralChange(refundOrder);
        if (RestResult.success().getCode() == result.getCode()) {
            orders.setOrderStatus(IntegralOrdersStatusEnum.RETURNED_GOODS.getCode());
            orders.setGmtModified(new Date());
            orders.setStoreName(storeName);
            orders.setStaffName(staffName);
            IntegralGoods integralGoods = (IntegralGoods)this.integralGoodsMapper.selectByPrimaryKey((Object)orders.getGoodId());
            integralGoods.setActualSales(Integer.valueOf(integralGoods.getActualSales() - orders.getSaleQuantity()));
            this.integralGoodsMapper.updateByPrimaryKey((Object)integralGoods);
            Example exampleSku = new Example(IntegralGoodsSku.class);
            exampleSku.createCriteria().andEqualTo("skuNo", (Object)orders.getGoodSkuNo()).andEqualTo("valid", (Object)Boolean.TRUE);
            IntegralGoodsSku sku = (IntegralGoodsSku)this.integralGoodsSkuMapper.selectOneByExample((Object)exampleSku);
            if (sku != null) {
                sku.setStock(Integer.valueOf(sku.getStock() + orders.getSaleQuantity()));
                this.integralGoodsSkuMapper.updateByPrimaryKey((Object)sku);
            }
        } else {
            return null;
        }
        refundOrder.setRefundStatus("1");
        refundOrder.setRefundTime(new Date());
        refundOrder.setGmtModified(new Date());
        order.setGmtModified(new Date());
        this.integralOrdersMapper.updateByPrimaryKeySelective((Object)orders);
        this.integralRefundOrderMapper.updateByPrimaryKeySelective((Object)refundOrder);
        return orders;
    }

    public List<IntegralRefundOrder> getRefundOrders(IntegralRefundOrder integralRefundOrder) {
        List list = this.integralRefundOrderMapper.getRefundOrders(integralRefundOrder);
        if (list.size() > 0) {
            for (IntegralRefundOrder refundOrder : list) {
                if ("0".equals(refundOrder.getAuditStatus()) && StringUtils.isEmpty((Object)refundOrder.getRefundStatus())) {
                    refundOrder.setOrderType("0");
                    continue;
                }
                if (!StringUtils.isEmpty((Object)refundOrder.getRefundStatus()) && "0".equals(refundOrder.getRefundStatus())) {
                    refundOrder.setOrderType("1");
                    continue;
                }
                if (!StringUtils.isEmpty((Object)refundOrder.getRefundStatus()) && "1".equals(refundOrder.getRefundStatus())) {
                    refundOrder.setOrderType("2");
                    continue;
                }
                if (!"2".equals(refundOrder.getAuditStatus())) continue;
                refundOrder.setOrderType("3");
            }
        }
        return list;
    }

    @Transactional
    public IntegralOrders confirm(IntegralOrders integralOrders) {
        integralOrders.setOrderStatus(IntegralOrdersStatusEnum.UN_SHIPPED.getCode());
        integralOrders.setOrderTime(new Date());
        integralOrders.setGmtCreate(new Date());
        String orderNo = IntegralOrderNoUtil.getOrderNo();
        integralOrders.setOrderNo(orderNo);
        IntegralGoods goods = (IntegralGoods)this.integralGoodsMapper.selectByPrimaryKey((Object)integralOrders.getGoodId());
        if (goods == null) {
            throw new CustomException("\u65e0\u6b64\u5546\u54c1");
        }
        if (integralOrders.getSaleQuantity() > goods.getRestrictedNum()) {
            throw new CustomException("\u6b64\u5546\u54c1\u9650\u5151\u6570\u91cf\u4e3a" + goods.getRestrictedNum() + "\u4e2a");
        }
        integralOrders.setSaleIntegral(Integer.valueOf(goods.getPrice().intValue()));
        integralOrders.setGoodNo(goods.getGoodsNo());
        integralOrders.setOrderType(goods.getDistributionMode());
        Example example = new Example(IntegralGoodsSku.class);
        example.createCriteria().andEqualTo("skuNo", (Object)integralOrders.getGoodSkuNo()).andEqualTo("valid", (Object)Boolean.TRUE);
        IntegralGoodsSku sku = (IntegralGoodsSku)this.integralGoodsSkuMapper.selectOneByExample((Object)example);
        if (sku == null) {
            throw new CustomException("\u65e0\u6b64\u5546\u54c1\u89c4\u683c");
        }
        if (integralOrders.getSaleQuantity() > sku.getStock()) {
            throw new CustomException("\u5546\u54c1\u5e93\u5b58\u4ec5\u5269[" + sku.getStock() + "]\u4ef6!");
        }
        integralOrders.setGoodSkuSpecNames(sku.getSpecNames());
        RestResult result = this.bizvaneInterface.consumeIntegralChange(integralOrders.getMemberCode(), Integer.valueOf(integralOrders.getSaleIntegral() * integralOrders.getSaleQuantity()), integralOrders.getOrderNo());
        if (RestResult.success().getCode() != result.getCode()) {
            return null;
        }
        this.integralOrdersMapper.insertSelective((Object)integralOrders);
        IntegralOrdersDetails details = new IntegralOrdersDetails();
        details.setMerchantId(integralOrders.getMerchantId());
        details.setOrderId(integralOrders.getId());
        details.setOrderNo(integralOrders.getOrderNo());
        details.setGoodId(integralOrders.getGoodId());
        details.setGoodsSkuNo(integralOrders.getGoodSkuNo());
        details.setGoodsSkuSpecNames(integralOrders.getGoodSkuSpecNames());
        details.setSaleIntegral(integralOrders.getSaleIntegral());
        details.setSaleQuantity(integralOrders.getSaleQuantity());
        details.setGmtCreate(new Date());
        this.integralOrdersDetailsMapper.insertSelective((Object)details);
        IntegralGoods integralGoods = (IntegralGoods)this.integralGoodsMapper.selectByPrimaryKey((Object)integralOrders.getGoodId());
        integralGoods.setActualSales(Integer.valueOf(integralGoods.getActualSales() + integralOrders.getSaleQuantity()));
        this.integralGoodsMapper.updateByPrimaryKey((Object)integralGoods);
        sku.setStock(Integer.valueOf(sku.getStock() - integralOrders.getSaleQuantity()));
        this.integralGoodsSkuMapper.updateByPrimaryKey((Object)sku);
        return integralOrders;
    }

    public List<IntegralOrders> getOrderListByStatus(Integer merchantId, String orderStatus, String memberCode) {
        IntegralOrders params = new IntegralOrders();
        if ("1".equals(orderStatus)) {
            orderStatus = IntegralOrdersStatusEnum.UN_SHIPPED.getCode();
        } else if ("2".equals(orderStatus)) {
            orderStatus = IntegralOrdersStatusEnum.SHIPPED.getCode();
        } else if ("3".equals(orderStatus)) {
            orderStatus = IntegralOrdersStatusEnum.SIGN.getCode();
        } else if ("4".equals(orderStatus)) {
            orderStatus = IntegralOrdersStatusEnum.RETURNED_GOODS.getCode();
            params.setRefundSort("DESC");
        } else {
            throw new CustomException("\u65e0\u6b64\u8ba2\u5355\u72b6\u6001\uff01");
        }
        params.setMerchantId(merchantId);
        params.setMemberCode(memberCode);
        params.setOrderStatus(orderStatus);
        List list = this.integralOrdersMapper.getOrders(params);
        if ("4".equals(orderStatus)) {
            for (IntegralOrders orders : list) {
                Example reExample = new Example(IntegralRefundOrder.class);
                reExample.createCriteria().andEqualTo("orderNo", (Object)orders.getOrderNo()).andEqualTo("valid", (Object)Boolean.TRUE);
                IntegralRefundOrder refundOrder = (IntegralRefundOrder)this.integralRefundOrderMapper.selectOneByExample((Object)reExample);
                orders.setRefundOrder(refundOrder);
            }
        }
        for (IntegralOrders orders : list) {
            if (!StringUtils.isEmpty((Object)orders.getGoodsName())) continue;
            orders.setGoodsName(orders.getGoodName());
            orders.setCoverImg("https://www.wsgxsp.com/TP/149881997658968.png");
        }
        return list;
    }

    public IntegralOrders getOrderById(Integer orderId) {
        IntegralOrders params = new IntegralOrders();
        params.setId(orderId);
        IntegralOrders orders = (IntegralOrders)this.integralOrdersMapper.getOrders(params).get(0);
        if (orders != null) {
            if (orders.getOrderStatus().equals(IntegralOrdersStatusEnum.RETURNED_GOODS.getCode()) || orders.getOrderStatus().equals(IntegralOrdersStatusEnum.SIGN.getCode())) {
                Example reeExample = new Example(IntegralRefundOrder.class);
                reeExample.createCriteria().andEqualTo("valid", (Object)Boolean.TRUE).andEqualTo("orderNo", (Object)orders.getOrderNo());
                IntegralRefundOrder refundOrder = (IntegralRefundOrder)this.integralRefundOrderMapper.selectOneByExample((Object)reeExample);
                orders.setRefundOrder(refundOrder);
            }
            if (StringUtils.isEmpty((Object)orders.getGoodsName())) {
                orders.setGoodsName(orders.getGoodName());
                orders.setCoverImg("https://www.wsgxsp.com/TP/149881997658968.png");
            }
        }
        return orders;
    }

    public void getProvince() {
        log.info("\u521d\u59cb\u5316\u52a0\u8f7d\u7701\u5e02\u533a\u6570\u636e\u5217\u8868\uff0c\u5e76\u653e\u81f3redis\u4e2d\u3002");
        Example example = new Example(CityInfo.class);
        example.createCriteria().andEqualTo("type", (Object)"0");
        List provinceList = this.cityInfoMapper.selectByExample((Object)example);
        ArrayList<ProvinceInfoDTO> provinceInfoDTOList = new ArrayList<ProvinceInfoDTO>();
        for (CityInfo cityInfo : provinceList) {
            ProvinceInfoDTO provinceInfoDTO = new ProvinceInfoDTO();
            provinceInfoDTO.setName(cityInfo.getName());
            Example cityExample = new Example(CityInfo.class);
            cityExample.createCriteria().andEqualTo("type", (Object)"1").andEqualTo("pid", (Object)cityInfo.getId());
            List cityList = this.cityInfoMapper.selectByExample((Object)cityExample);
            ArrayList<CityInfoDTO> cityInfoDTOS = new ArrayList<CityInfoDTO>();
            for (CityInfo cityInfo1 : cityList) {
                CityInfoDTO cityInfoDTO = new CityInfoDTO();
                cityInfoDTO.setName(cityInfo1.getName());
                ArrayList<String> dNames = new ArrayList<String>();
                Example districtExample = new Example(CityInfo.class);
                districtExample.createCriteria().andEqualTo("type", (Object)"2").andEqualTo("pid", (Object)cityInfo1.getId());
                List districtList = this.cityInfoMapper.selectByExample((Object)districtExample);
                for (CityInfo cityInfo2 : districtList) {
                    dNames.add(cityInfo2.getName());
                }
                cityInfoDTO.setChildNames(dNames);
                cityInfoDTOS.add(cityInfoDTO);
            }
            provinceInfoDTO.setChildNames(cityInfoDTOS);
            provinceInfoDTOList.add(provinceInfoDTO);
        }
        this.redisTemplate.opsForValue().set((Object)"city", provinceInfoDTOList);
    }

    public List<ProvinceInfoDTO> getCity() {
        List city = (List)this.redisTemplate.opsForValue().get((Object)"city");
        return city;
    }

    public String getDistributionModeBySkuNo(String skuNo) {
        String mode = "0";
        Example skuExample = new Example(IntegralGoodsSku.class);
        skuExample.createCriteria().andEqualTo("skuNo", (Object)skuNo).andEqualTo("valid", (Object)Boolean.TRUE);
        IntegralGoodsSku sku = (IntegralGoodsSku)this.integralGoodsSkuMapper.selectOneByExample((Object)skuExample);
        if (sku == null) {
            return mode;
        }
        IntegralGoods goods = (IntegralGoods)this.integralGoodsMapper.selectByPrimaryKey((Object)sku.getGoodsId());
        mode = goods.getDistributionMode();
        return mode;
    }
}

