/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.entity.ExpressTemplate;
import com.wmeimob.fastboot.bizvane.entity.ExpressTemplateArea;
import com.wmeimob.fastboot.bizvane.mapper.ExpressTemplateAreaMapper;
import com.wmeimob.fastboot.bizvane.mapper.ExpressTemplateMapper;
import com.wmeimob.fastboot.bizvane.service.ExpressService;
import com.wmeimob.fastboot.bizvane.service.GoodsService;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.util.InputValidator;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class ExpressServiceImpl
implements ExpressService {
    @Autowired
    private ExpressTemplateMapper expressTemplateMapper;
    @Autowired
    private ExpressTemplateAreaMapper expressTemplateAreaMapper;
    @Resource
    private GoodsService goodsService;

    public ExpressTemplate add(ExpressTemplate expressTemplate) {
        Date date = new Date();
        expressTemplate.setGmtCreate(date);
        this.expressTemplateMapper.insertSelective((Object)expressTemplate);
        List templateAreaList = expressTemplate.getTemplateAreaList();
        for (ExpressTemplateArea eta : templateAreaList) {
            InputValidator.checkEmpty((Object)eta.getArea(), (String)"\u914d\u9001\u533a\u57df");
            eta.setDelivery(Integer.valueOf(1));
            eta.setTemplateId(expressTemplate.getId());
            eta.setGmtCreate(date);
        }
        this.expressTemplateAreaMapper.insertList(templateAreaList);
        return expressTemplate;
    }

    public int delete(Integer id) {
        Integer integer = this.goodsService.selectCountGoodsByExpressId(id);
        if (integer > 0) {
            throw new CustomException("\u8fd8\u6709\u5546\u54c1\u4f7f\u7528\u6b64\u6a21\u677f\uff0c\u5220\u9664\u5931\u8d25");
        }
        this.expressTemplateMapper.deleteByPrimaryKey((Object)id);
        Example example = new Example(ExpressTemplateArea.class);
        example.createCriteria().andEqualTo("templateId", (Object)id);
        return this.expressTemplateAreaMapper.deleteByExample((Object)example);
    }

    public int update(ExpressTemplate expressTemplate) {
        Date date = new Date();
        expressTemplate.setGmtModified(date);
        if (expressTemplate.getTemplateAreaList() != null) {
            List templateAreaList = expressTemplate.getTemplateAreaList();
            for (ExpressTemplateArea eta : templateAreaList) {
                InputValidator.checkEmpty((Object)eta.getArea(), (String)"\u914d\u9001\u533a\u57df");
                eta.setDelivery(Integer.valueOf(1));
                eta.setGmtModified(date);
                if (eta.getId() == null) {
                    eta.setTemplateId(expressTemplate.getId());
                    eta.setGmtCreate(date);
                    this.expressTemplateAreaMapper.insertSelective((Object)eta);
                    continue;
                }
                this.expressTemplateAreaMapper.updateByPrimaryKeySelective((Object)eta);
            }
        }
        if (expressTemplate.getIsDefault() != null && expressTemplate.getIsDefault().booleanValue()) {
            this.expressTemplateMapper.updateDefaultIsFalse();
        }
        return this.expressTemplateMapper.updateByPrimaryKeySelective((Object)expressTemplate);
    }

    public List<ExpressTemplate> findByCondition(ExpressTemplate condition) {
        return this.expressTemplateMapper.selectList(condition);
    }

    public ExpressTemplate findById(Integer id) {
        return this.expressTemplateMapper.selectListById(id);
    }

    public int deleteTemplate(Integer id) {
        return this.expressTemplateAreaMapper.deleteByPrimaryKey((Object)id);
    }
}

