/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.GenerateTOTPSharedSecretExtendedRequest;
import com.unboundid.ldap.sdk.unboundidds.extensions.GenerateTOTPSharedSecretExtendedResult;
import com.unboundid.ldap.sdk.unboundidds.extensions.RevokeTOTPSharedSecretExtendedRequest;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.LDAPCommandLineTool;
import com.unboundid.util.PasswordReader;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.StringArgument;
import java.io.OutputStream;
import java.util.LinkedHashMap;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class GenerateTOTPSharedSecret
extends LDAPCommandLineTool {
    private BooleanArgument promptForUserPassword = null;
    private BooleanArgument revokeAll = null;
    private FileArgument userPasswordFile = null;
    private StringArgument authenticationID = null;
    private StringArgument revoke = null;
    private StringArgument userPassword = null;

    public static void main(String ... args) {
        ResultCode resultCode = GenerateTOTPSharedSecret.main(System.out, System.err, args);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    public static ResultCode main(OutputStream out, OutputStream err, String ... args) {
        GenerateTOTPSharedSecret tool = new GenerateTOTPSharedSecret(out, err);
        return tool.runTool(args);
    }

    public GenerateTOTPSharedSecret(OutputStream out, OutputStream err) {
        super(out, err);
    }

    @Override
    public String getToolName() {
        return "generate-totp-shared-secret";
    }

    @Override
    public String getToolDescription() {
        return ToolMessages.INFO_GEN_TOTP_SECRET_TOOL_DESC.get();
    }

    @Override
    public String getToolVersion() {
        return "4.0.13";
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean supportsOutputFile() {
        return true;
    }

    @Override
    protected boolean supportsAuthentication() {
        return true;
    }

    @Override
    protected boolean defaultToPromptForBindPassword() {
        return true;
    }

    @Override
    protected boolean supportsSASLHelp() {
        return true;
    }

    @Override
    protected boolean includeAlternateLongIdentifiers() {
        return true;
    }

    @Override
    protected boolean supportsSSLDebugging() {
        return true;
    }

    @Override
    protected boolean logToolInvocationByDefault() {
        return true;
    }

    @Override
    public void addNonLDAPArguments(ArgumentParser parser) throws ArgumentException {
        this.authenticationID = new StringArgument(null, "authID", true, 1, ToolMessages.INFO_GEN_TOTP_SECRET_PLACEHOLDER_AUTH_ID.get(), ToolMessages.INFO_GEN_TOTP_SECRET_DESCRIPTION_AUTH_ID.get());
        this.authenticationID.addLongIdentifier("authenticationID", true);
        this.authenticationID.addLongIdentifier("auth-id", true);
        this.authenticationID.addLongIdentifier("authentication-id", true);
        parser.addArgument(this.authenticationID);
        this.userPassword = new StringArgument(null, "userPassword", false, 1, ToolMessages.INFO_GEN_TOTP_SECRET_PLACEHOLDER_USER_PW.get(), ToolMessages.INFO_GEN_TOTP_SECRET_DESCRIPTION_USER_PW.get(this.authenticationID.getIdentifierString()));
        this.userPassword.setSensitive(true);
        this.userPassword.addLongIdentifier("user-password", true);
        parser.addArgument(this.userPassword);
        this.userPasswordFile = new FileArgument(null, "userPasswordFile", false, 1, null, ToolMessages.INFO_GEN_TOTP_SECRET_DESCRIPTION_USER_PW_FILE.get(this.authenticationID.getIdentifierString()), true, true, true, false);
        this.userPasswordFile.addLongIdentifier("user-password-file", true);
        parser.addArgument(this.userPasswordFile);
        this.promptForUserPassword = new BooleanArgument(null, "promptForUserPassword", ToolMessages.INFO_GEN_TOTP_SECRET_DESCRIPTION_PROMPT_FOR_USER_PW.get(this.authenticationID.getIdentifierString()));
        this.promptForUserPassword.addLongIdentifier("prompt-for-user-password", true);
        parser.addArgument(this.promptForUserPassword);
        this.revoke = new StringArgument(null, "revoke", false, 1, ToolMessages.INFO_GEN_TOTP_SECRET_PLACEHOLDER_SECRET.get(), ToolMessages.INFO_GEN_TOTP_SECRET_DESCRIPTION_REVOKE.get());
        parser.addArgument(this.revoke);
        this.revokeAll = new BooleanArgument(null, "revokeAll", 1, ToolMessages.INFO_GEN_TOTP_SECRET_DESCRIPTION_REVOKE_ALL.get());
        this.revokeAll.addLongIdentifier("revoke-all", true);
        parser.addArgument(this.revokeAll);
        parser.addExclusiveArgumentSet(this.userPassword, this.userPasswordFile, this.promptForUserPassword);
        parser.addDependentArgumentSet(this.userPassword, this.authenticationID, new Argument[0]);
        parser.addDependentArgumentSet(this.userPasswordFile, this.authenticationID, new Argument[0]);
        parser.addDependentArgumentSet(this.promptForUserPassword, this.authenticationID, new Argument[0]);
        parser.addExclusiveArgumentSet(this.revoke, this.revokeAll, new Argument[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultCode doToolProcessing() {
        LDAPConnection conn;
        try {
            conn = this.getConnection();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, StaticUtils.TERMINAL_WIDTH_COLUMNS, ToolMessages.ERR_GEN_TOTP_SECRET_CANNOT_CONNECT.get(StaticUtils.getExceptionMessage(le)));
            return le.getResultCode();
        }
        try {
            ExtendedResult result;
            ExtendedRequest request;
            byte[] staticPassword;
            String authID = this.authenticationID.getValue();
            if (this.userPassword.isPresent()) {
                staticPassword = StaticUtils.getBytes(this.userPassword.getValue());
            } else if (this.userPasswordFile.isPresent()) {
                try {
                    char[] pwChars = this.getPasswordFileReader().readPassword(this.userPasswordFile.getValue());
                    staticPassword = StaticUtils.getBytes(new String(pwChars));
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    this.wrapErr(0, StaticUtils.TERMINAL_WIDTH_COLUMNS, ToolMessages.ERR_GEN_TOTP_SECRET_CANNOT_READ_PW_FROM_FILE.get(this.userPasswordFile.getValue().getAbsolutePath(), StaticUtils.getExceptionMessage(e)));
                    ResultCode resultCode = ResultCode.LOCAL_ERROR;
                    conn.close();
                    return resultCode;
                }
            } else if (this.promptForUserPassword.isPresent()) {
                try {
                    this.getOut().print(ToolMessages.INFO_GEN_TOTP_SECRET_ENTER_PW.get(authID));
                    staticPassword = PasswordReader.readPassword();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    this.wrapErr(0, StaticUtils.TERMINAL_WIDTH_COLUMNS, ToolMessages.ERR_GEN_TOTP_SECRET_CANNOT_READ_PW_FROM_STDIN.get(StaticUtils.getExceptionMessage(e)));
                    ResultCode resultCode = ResultCode.LOCAL_ERROR;
                    conn.close();
                    return resultCode;
                }
            } else {
                staticPassword = null;
            }
            if (this.revoke.isPresent()) {
                request = new RevokeTOTPSharedSecretExtendedRequest(authID, staticPassword, this.revoke.getValue(), new Control[0]);
                try {
                    result = conn.processExtendedOperation(request);
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    result = new ExtendedResult(le);
                }
                if (result.getResultCode() == ResultCode.SUCCESS) {
                    this.wrapOut(0, StaticUtils.TERMINAL_WIDTH_COLUMNS, ToolMessages.INFO_GEN_TOTP_SECRET_REVOKE_SUCCESS.get(this.revoke.getValue()));
                } else {
                    this.wrapErr(0, StaticUtils.TERMINAL_WIDTH_COLUMNS, ToolMessages.ERR_GEN_TOTP_SECRET_REVOKE_FAILURE.get(this.revoke.getValue()));
                }
            } else if (this.revokeAll.isPresent()) {
                request = new RevokeTOTPSharedSecretExtendedRequest(authID, staticPassword, null, new Control[0]);
                try {
                    result = conn.processExtendedOperation(request);
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    result = new ExtendedResult(le);
                }
                if (result.getResultCode() == ResultCode.SUCCESS) {
                    this.wrapOut(0, StaticUtils.TERMINAL_WIDTH_COLUMNS, ToolMessages.INFO_GEN_TOTP_SECRET_REVOKE_ALL_SUCCESS.get());
                } else {
                    this.wrapErr(0, StaticUtils.TERMINAL_WIDTH_COLUMNS, ToolMessages.ERR_GEN_TOTP_SECRET_REVOKE_ALL_FAILURE.get());
                }
            } else {
                request = new GenerateTOTPSharedSecretExtendedRequest(authID, staticPassword, new Control[0]);
                try {
                    result = conn.processExtendedOperation(request);
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    result = new ExtendedResult(le);
                }
                if (result.getResultCode() == ResultCode.SUCCESS) {
                    this.wrapOut(0, StaticUtils.TERMINAL_WIDTH_COLUMNS, ToolMessages.INFO_GEN_TOTP_SECRET_GEN_SUCCESS.get(((GenerateTOTPSharedSecretExtendedResult)result).getTOTPSharedSecret()));
                } else {
                    this.wrapErr(0, StaticUtils.TERMINAL_WIDTH_COLUMNS, ToolMessages.ERR_GEN_TOTP_SECRET_GEN_FAILURE.get());
                }
            }
            if (result.getResultCode() != ResultCode.SUCCESS) {
                String matchedDN;
                this.wrapErr(0, StaticUtils.TERMINAL_WIDTH_COLUMNS, ToolMessages.ERR_GEN_TOTP_SECRET_RESULT_CODE.get(String.valueOf(result.getResultCode())));
                String diagnosticMessage = result.getDiagnosticMessage();
                if (diagnosticMessage != null) {
                    this.wrapErr(0, StaticUtils.TERMINAL_WIDTH_COLUMNS, ToolMessages.ERR_GEN_TOTP_SECRET_DIAGNOSTIC_MESSAGE.get(diagnosticMessage));
                }
                if ((matchedDN = result.getMatchedDN()) != null) {
                    this.wrapErr(0, StaticUtils.TERMINAL_WIDTH_COLUMNS, ToolMessages.ERR_GEN_TOTP_SECRET_MATCHED_DN.get(matchedDN));
                }
                for (String referralURL : result.getReferralURLs()) {
                    this.wrapErr(0, StaticUtils.TERMINAL_WIDTH_COLUMNS, ToolMessages.ERR_GEN_TOTP_SECRET_REFERRAL_URL.get(referralURL));
                }
            }
            ResultCode resultCode = result.getResultCode();
            return resultCode;
        }
        finally {
            conn.close();
        }
    }

    @Override
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(2));
        examples.put(new String[]{"--hostname", "ds.example.com", "--port", "389", "--authID", "u:john.doe", "--promptForUserPassword"}, ToolMessages.INFO_GEN_TOTP_SECRET_GEN_EXAMPLE.get());
        examples.put(new String[]{"--hostname", "ds.example.com", "--port", "389", "--authID", "u:john.doe", "--userPasswordFile", "password.txt", "--revokeAll"}, ToolMessages.INFO_GEN_TOTP_SECRET_REVOKE_ALL_EXAMPLE.get());
        return examples;
    }
}

