/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.webp.lossless;

import com.twelvemonkeys.imageio.plugins.webp.LSBBitReader;
import com.twelvemonkeys.imageio.plugins.webp.lossless.ColorCache;
import com.twelvemonkeys.imageio.plugins.webp.lossless.Transform;
import com.twelvemonkeys.imageio.util.RasterUtils;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

public final class VP8LDecoder {
    private final ImageInputStream imageInput;
    private final LSBBitReader lsbBitReader;
    private final List<Transform> transforms = new ArrayList<Transform>();
    private ColorCache colorCache;

    public VP8LDecoder(ImageInputStream imageInputStream, boolean bl) {
        this.imageInput = imageInputStream;
        this.lsbBitReader = new LSBBitReader(imageInputStream);
    }

    public void readVP8Lossless(WritableRaster writableRaster, boolean bl) throws IOException {
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        while (bl && this.lsbBitReader.readBit() == 1) {
            n = this.readTransform(n, n2);
        }
        int n3 = 0;
        if (this.lsbBitReader.readBit() == 1 && ((n3 = (int)this.lsbBitReader.readBits(4)) < 1 || n3 > 11)) {
            throw new IIOException("Corrupt WebP stream, colorCacheBits < 1 || > 11: " + n3);
        }
        this.readHuffmanCodes(n3, bl);
        if (n3 > 0) {
            this.colorCache = new ColorCache(n3);
        }
    }

    private int readTransform(int n, int n2) throws IOException {
        int n3 = (int)this.lsbBitReader.readBits(2);
        switch (n3) {
            case 0: {
                int n4;
                System.err.println("transformType: PREDICTOR_TRANSFORM");
                int n5 = (int)this.lsbBitReader.readBits(3) + 2;
                int n6 = n4 = 1 << n5;
                int n7 = n4;
                int n8 = VP8LDecoder.divRoundUp(n, n4);
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n; ++j) {
                        int n9 = (i >> n5) * n8 + (j >> n5);
                    }
                }
                break;
            }
            case 1: {
                System.err.println("transformType: COLOR_TRANSFORM");
                int n10 = (int)this.lsbBitReader.readBits(3) + 2;
                int n11 = VP8LDecoder.subSampleSize(n, n10);
                int n12 = VP8LDecoder.subSampleSize(n2, n10);
                WritableRaster writableRaster = Raster.createInterleavedRaster(0, n11, n12, n11, 1, new int[]{0}, null);
                this.readVP8Lossless(writableRaster, false);
                this.transforms.add(new Transform(n3, ((DataBufferByte)writableRaster.getDataBuffer()).getData()));
                break;
            }
            case 2: {
                System.err.println("transformType: SUBTRACT_GREEN");
                break;
            }
            case 3: {
                System.err.println("transformType: COLOR_INDEXING_TRANSFORM");
                int n13 = this.imageInput.readUnsignedByte() + 1;
                System.err.println("colorTableSize: " + n13);
                int n14 = n13 > 16 ? 256 : (n13 > 4 ? 16 : (n13 > 2 ? 4 : 2));
                System.err.println("safeColorTableSize: " + n14);
                int[] nArray = new int[n14];
                this.readVP8Lossless(RasterUtils.asByteRaster((WritableRaster)Raster.createPackedRaster(new DataBufferInt(nArray, n13), n13, 1, n13, new int[]{0}, null)), false);
                int n15 = n13 > 16 ? 0 : (n13 > 4 ? 1 : (n13 > 2 ? 2 : 3));
                n = VP8LDecoder.subSampleSize(n, n15);
                this.transforms.add(new Transform(n3, nArray));
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid transformType: " + n3));
            }
        }
        return n;
    }

    private void readHuffmanCodes(int n, boolean bl) {
    }

    private static int divRoundUp(int n, int n2) {
        return (n + n2 - 1) / n2;
    }

    private static int subSampleSize(int n, int n2) {
        return n + (1 << n2) - 1 >> n2;
    }

    private static int ALPHA(int n) {
        return n >>> 24;
    }

    private static int RED(int n) {
        return n >> 16 & 0xFF;
    }

    private static int GREEN(int n) {
        return n >> 8 & 0xFF;
    }

    private static int BLUE(int n) {
        return n & 0xFF;
    }

    private static int select(int n, int n2, int n3) {
        int n4;
        int n5 = VP8LDecoder.ALPHA(n) + VP8LDecoder.ALPHA(n2) - VP8LDecoder.ALPHA(n3);
        int n6 = VP8LDecoder.RED(n) + VP8LDecoder.RED(n2) - VP8LDecoder.RED(n3);
        int n7 = VP8LDecoder.GREEN(n) + VP8LDecoder.GREEN(n2) - VP8LDecoder.GREEN(n3);
        int n8 = VP8LDecoder.BLUE(n) + VP8LDecoder.BLUE(n2) - VP8LDecoder.BLUE(n3);
        int n9 = Math.abs(n5 - VP8LDecoder.ALPHA(n)) + Math.abs(n6 - VP8LDecoder.RED(n)) + Math.abs(n7 - VP8LDecoder.GREEN(n)) + Math.abs(n8 - VP8LDecoder.BLUE(n));
        return n9 < (n4 = Math.abs(n5 - VP8LDecoder.ALPHA(n2)) + Math.abs(n6 - VP8LDecoder.RED(n2)) + Math.abs(n7 - VP8LDecoder.GREEN(n2)) + Math.abs(n8 - VP8LDecoder.BLUE(n2))) ? n : n2;
    }

    private static int average2(int n, int n2) {
        return (n + n2) / 2;
    }

    private static int clamp(int n) {
        return Math.max(0, Math.min(n, 255));
    }

    private static int clampAddSubtractFull(int n, int n2, int n3) {
        return VP8LDecoder.clamp(n + n2 - n3);
    }

    private static int clampAddSubtractHalf(int n, int n2) {
        return VP8LDecoder.clamp(n + (n - n2) / 2);
    }

    private static void colorTransform(int n, int n2, int n3, ColorTransformElement colorTransformElement, int[] nArray) {
        int n4 = n;
        int n5 = n2;
        n5 += VP8LDecoder.colorTransformDelta((byte)colorTransformElement.green_to_blue, (byte)n3);
        nArray[0] = (n4 += VP8LDecoder.colorTransformDelta((byte)colorTransformElement.green_to_red, (byte)n3)) & 0xFF;
        nArray[1] = (n5 += VP8LDecoder.colorTransformDelta((byte)colorTransformElement.red_to_blue, (byte)n)) & 0xFF;
    }

    private static byte colorTransformDelta(byte by, byte by2) {
        return (byte)(by * by2 >> 5);
    }

    private static void inverseTransform(byte n, byte by, byte n2, ColorTransformElement colorTransformElement, int[] nArray) {
        int n3 = n;
        int n4 = n2;
        n4 -= VP8LDecoder.colorTransformDelta((byte)colorTransformElement.green_to_blue, by);
        nArray[0] = (n3 -= VP8LDecoder.colorTransformDelta((byte)colorTransformElement.green_to_red, by)) & 0xFF;
        nArray[1] = (n4 -= VP8LDecoder.colorTransformDelta((byte)colorTransformElement.red_to_blue, (byte)n)) & 0xFF;
    }

    private static void inverseTransform(byte[] byArray, ColorTransformElement colorTransformElement) {
        int n = byArray[0];
        int n2 = byArray[2];
        n2 -= VP8LDecoder.colorTransformDelta((byte)colorTransformElement.green_to_blue, byArray[1]);
        byArray[0] = (byte)((n -= VP8LDecoder.colorTransformDelta((byte)colorTransformElement.green_to_red, byArray[1])) & 0xFF);
        byArray[2] = (byte)((n2 -= VP8LDecoder.colorTransformDelta((byte)colorTransformElement.red_to_blue, byArray[0])) & 0xFF);
    }

    private static void addGreenToBlueAndRed(byte[] byArray) {
        byArray[0] = (byte)(byArray[0] + byArray[1] & 0xFF);
        byArray[2] = (byte)(byArray[2] + byArray[1] & 0xFF);
    }

    static final class ColorTransformElement {
        final int green_to_red;
        final int green_to_blue;
        final int red_to_blue;

        ColorTransformElement(int n, int n2, int n3) {
            this.green_to_red = n;
            this.green_to_blue = n2;
            this.red_to_blue = n3;
        }
    }
}

