/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.middleware.logger.support;

public class LogLog {
    protected static boolean debugEnabled = false;
    protected static boolean infoEnabled = true;
    private static boolean quietMode = false;
    private static final String DEBUG_PREFIX = "JM.Log:DEBUG ";
    private static final String INFO_PREFIX = "JM.Log:INFO ";
    private static final String WARN_PREFIX = "JM.Log:WARN ";
    private static final String ERR_PREFIX = "JM.Log:ERROR ";

    public static void setQuietMode(boolean quietMode) {
        LogLog.quietMode = quietMode;
    }

    public static void setInternalDebugging(boolean enabled) {
        debugEnabled = enabled;
    }

    public static void setInternalInfoing(boolean enabled) {
        infoEnabled = enabled;
    }

    public static void debug(String msg) {
        if (debugEnabled && !quietMode) {
            System.out.println(DEBUG_PREFIX + msg);
        }
    }

    public static void debug(String msg, Throwable t) {
        if (debugEnabled && !quietMode) {
            System.out.println(DEBUG_PREFIX + msg);
            if (t != null) {
                t.printStackTrace(System.out);
            }
        }
    }

    public static void info(String msg) {
        if (infoEnabled && !quietMode) {
            System.out.println(INFO_PREFIX + msg);
        }
    }

    public static void info(String msg, Throwable t) {
        if (infoEnabled && !quietMode) {
            System.out.println(INFO_PREFIX + msg);
            if (t != null) {
                t.printStackTrace(System.out);
            }
        }
    }

    public static void error(String msg) {
        if (quietMode) {
            return;
        }
        System.err.println(ERR_PREFIX + msg);
    }

    public static void error(String msg, Throwable t) {
        if (quietMode) {
            return;
        }
        System.err.println(ERR_PREFIX + msg);
        if (t != null) {
            t.printStackTrace();
        }
    }

    public static void warn(String msg) {
        if (quietMode) {
            return;
        }
        System.err.println(WARN_PREFIX + msg);
    }

    public static void warn(String msg, Throwable t) {
        if (quietMode) {
            return;
        }
        System.err.println(WARN_PREFIX + msg);
        if (t != null) {
            t.printStackTrace();
        }
    }
}

