/*
 * Decompiled with CFR 0.152.
 */
package com.stimulussoft.filequeue.processor;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class DelayRejectPolicy
implements RejectedExecutionHandler {
    private final long timeOut;
    private final TimeUnit timeUnit;

    public DelayRejectPolicy() {
        this.timeOut = 1L;
        this.timeUnit = TimeUnit.SECONDS;
    }

    public DelayRejectPolicy(long timeOut, TimeUnit timeUnit) {
        this.timeOut = timeOut;
        this.timeUnit = timeUnit;
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        block4: {
            if (!e.isShutdown()) {
                try {
                    if (!e.getQueue().offer(r, this.timeOut, this.timeUnit)) {
                        throw new RejectedExecutionException("Task " + r.toString() + " need save to disk.");
                    }
                    break block4;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new RejectedExecutionException("Task " + r.toString() + " rejected from " + e.toString() + " due to interruption.");
                }
            }
            throw new RejectedExecutionException("Task " + r.toString() + " rejected from " + e.toString() + " shutdown.");
        }
    }
}

