/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.google.common.base.MoreObjects;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class RemovedImage {
    private final String imageId;
    private final Type type;

    public RemovedImage(@JsonProperty(value="Untagged") String untagged, @JsonProperty(value="Deleted") String deleted) {
        if (untagged != null) {
            this.type = Type.UNTAGGED;
            this.imageId = untagged;
        } else if (deleted != null) {
            this.type = Type.DELETED;
            this.imageId = deleted;
        } else {
            this.type = Type.UNKNOWN;
            this.imageId = null;
        }
    }

    public RemovedImage(Type type, String imageId) {
        this.type = type;
        this.imageId = imageId;
    }

    public String imageId() {
        return this.imageId;
    }

    public Type type() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemovedImage that = (RemovedImage)o;
        return Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.imageId, that.imageId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.imageId, this.type});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("imageId", (Object)this.imageId).toString();
    }

    public static enum Type {
        UNTAGGED,
        DELETED,
        UNKNOWN;

    }
}

