/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@FileStatefulCheck
public class EqualsAvoidNullCheck
extends AbstractCheck {
    public static final String MSG_EQUALS_AVOID_NULL = "equals.avoid.null";
    public static final String MSG_EQUALS_IGNORE_CASE_AVOID_NULL = "equalsIgnoreCase.avoid.null";
    private static final String EQUALS = "equals";
    private static final String STRING = "String";
    private boolean ignoreEqualsIgnoreCase;
    private FieldFrame currentFrame;

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{27, 14, 9, 83, 91, 84, 85, 96, 95, 10, 21, 8, 7, 154, 155, 136};
    }

    public void setIgnoreEqualsIgnoreCase(boolean newValue) {
        this.ignoreEqualsIgnoreCase = newValue;
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.currentFrame = new FieldFrame(null);
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 10: 
            case 21: {
                this.currentFrame.addField(ast);
                break;
            }
            case 27: {
                this.processMethodCall(ast);
                break;
            }
            case 7: {
                this.processSlist(ast);
                break;
            }
            case 136: {
                this.processLiteralNew(ast);
                break;
            }
            default: {
                this.processFrame(ast);
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        int astType = ast.getType();
        if (astType != 10 && astType != 21 && astType != 27 && astType != 7 && astType != 136 || astType == 136 && ast.findFirstToken(6) != null) {
            this.currentFrame = this.currentFrame.getParent();
        } else if (astType == 7) {
            this.leaveSlist(ast);
        }
    }

    @Override
    public void finishTree(DetailAST ast) {
        this.traverseFieldFrameTree(this.currentFrame);
    }

    private void processSlist(DetailAST ast) {
        int parentType = ast.getParent().getType();
        if (parentType == 7 || parentType == 12 || parentType == 11) {
            FieldFrame frame = new FieldFrame(this.currentFrame);
            this.currentFrame.addChild(frame);
            this.currentFrame = frame;
        }
    }

    private void leaveSlist(DetailAST ast) {
        int parentType = ast.getParent().getType();
        if (parentType == 7 || parentType == 12 || parentType == 11) {
            this.currentFrame = this.currentFrame.getParent();
        }
    }

    private void processFrame(DetailAST ast) {
        FieldFrame frame = new FieldFrame(this.currentFrame);
        int astType = ast.getType();
        if (astType == 14 || astType == 154 || astType == 155) {
            frame.setClassOrEnumOrEnumConstDef(true);
            frame.setFrameName(ast.findFirstToken(58).getText());
        }
        this.currentFrame.addChild(frame);
        this.currentFrame = frame;
    }

    private void processMethodCall(DetailAST methodCall) {
        String methodName;
        DetailAST dot = methodCall.getFirstChild();
        if (dot.getType() == 59 && (EQUALS.equals(methodName = dot.getLastChild().getText()) || !this.ignoreEqualsIgnoreCase && "equalsIgnoreCase".equals(methodName))) {
            this.currentFrame.addMethodCall(methodCall);
        }
    }

    private void processLiteralNew(DetailAST ast) {
        if (ast.findFirstToken(6) != null) {
            FieldFrame frame = new FieldFrame(this.currentFrame);
            this.currentFrame.addChild(frame);
            this.currentFrame = frame;
        }
    }

    private void traverseFieldFrameTree(FieldFrame frame) {
        for (FieldFrame child : frame.getChildren()) {
            if (!child.getChildren().isEmpty()) {
                this.traverseFieldFrameTree(child);
            }
            this.currentFrame = child;
            child.getMethodCalls().forEach(this::checkMethodCall);
        }
    }

    private void checkMethodCall(DetailAST methodCall) {
        DetailAST objCalledOn = methodCall.getFirstChild().getFirstChild();
        if (objCalledOn.getType() == 59) {
            objCalledOn = objCalledOn.getLastChild();
        }
        DetailAST expr = methodCall.findFirstToken(34).getFirstChild();
        if (EqualsAvoidNullCheck.containsOneArgument(methodCall) && EqualsAvoidNullCheck.containsAllSafeTokens(expr) && this.isCalledOnStringFieldOrVariable(objCalledOn)) {
            String methodName = methodCall.getFirstChild().getLastChild().getText();
            if (EQUALS.equals(methodName)) {
                this.log(methodCall, MSG_EQUALS_AVOID_NULL, new Object[0]);
            } else {
                this.log(methodCall, MSG_EQUALS_IGNORE_CASE_AVOID_NULL, new Object[0]);
            }
        }
    }

    private static boolean containsOneArgument(DetailAST methodCall) {
        DetailAST elist = methodCall.findFirstToken(34);
        return elist.getChildCount() == 1;
    }

    private static boolean containsAllSafeTokens(DetailAST expr) {
        DetailAST arg = expr.getFirstChild();
        arg = EqualsAvoidNullCheck.skipVariableAssign(arg);
        boolean argIsNotNull = false;
        if (arg.getType() == 125) {
            for (DetailAST child = arg.getFirstChild(); child != null && !argIsNotNull; child = child.getNextSibling()) {
                argIsNotNull = child.getType() == 139 || child.getType() == 58;
            }
        }
        return argIsNotNull || !arg.branchContains(58) && !arg.branchContains(135);
    }

    private static DetailAST skipVariableAssign(DetailAST currentAST) {
        DetailAST result = currentAST;
        if (currentAST.getType() == 80 && currentAST.getFirstChild().getType() == 58) {
            result = currentAST.getFirstChild().getNextSibling();
        }
        return result;
    }

    private boolean isCalledOnStringFieldOrVariable(DetailAST objCalledOn) {
        boolean result;
        DetailAST previousSiblingAst = objCalledOn.getPreviousSibling();
        if (previousSiblingAst == null) {
            result = this.isStringFieldOrVariable(objCalledOn);
        } else if (previousSiblingAst.getType() == 78) {
            result = this.isStringFieldOrVariableFromThisInstance(objCalledOn);
        } else {
            String className = previousSiblingAst.getText();
            result = this.isStringFieldOrVariableFromClass(objCalledOn, className);
        }
        return result;
    }

    private boolean isStringFieldOrVariable(DetailAST objCalledOn) {
        boolean result = false;
        String name = objCalledOn.getText();
        for (FieldFrame frame = this.currentFrame; frame != null; frame = frame.getParent()) {
            DetailAST field = frame.findField(name);
            if (field == null || !frame.isClassOrEnumOrEnumConstDef() && !EqualsAvoidNullCheck.checkLineNo(field, objCalledOn)) continue;
            result = STRING.equals(EqualsAvoidNullCheck.getFieldType(field));
            break;
        }
        return result;
    }

    private boolean isStringFieldOrVariableFromThisInstance(DetailAST objCalledOn) {
        boolean result = false;
        String name = objCalledOn.getText();
        DetailAST field = EqualsAvoidNullCheck.getObjectFrame(this.currentFrame).findField(name);
        if (field != null) {
            result = STRING.equals(EqualsAvoidNullCheck.getFieldType(field));
        }
        return result;
    }

    private boolean isStringFieldOrVariableFromClass(DetailAST objCalledOn, String className) {
        boolean result = false;
        String name = objCalledOn.getText();
        FieldFrame frame = EqualsAvoidNullCheck.getObjectFrame(this.currentFrame);
        while (frame != null) {
            if (className.equals(frame.getFrameName())) {
                DetailAST field = frame.findField(name);
                if (field == null) break;
                result = STRING.equals(EqualsAvoidNullCheck.getFieldType(field));
                break;
            }
            frame = EqualsAvoidNullCheck.getObjectFrame(frame.getParent());
        }
        return result;
    }

    private static FieldFrame getObjectFrame(FieldFrame frame) {
        FieldFrame objectFrame;
        for (objectFrame = frame; objectFrame != null && !objectFrame.isClassOrEnumOrEnumConstDef(); objectFrame = objectFrame.getParent()) {
        }
        return objectFrame;
    }

    private static boolean checkLineNo(DetailAST field, DetailAST objCalledOn) {
        boolean result = false;
        int minimumSymbolsBetween = 11;
        if (field.getLineNo() < objCalledOn.getLineNo() || field.getLineNo() == objCalledOn.getLineNo() && field.getColumnNo() + 11 <= objCalledOn.getColumnNo()) {
            result = true;
        }
        return result;
    }

    private static String getFieldType(DetailAST field) {
        String fieldType = null;
        DetailAST identAst = field.findFirstToken(13).findFirstToken(58);
        if (identAst != null) {
            fieldType = identAst.getText();
        }
        return fieldType;
    }

    private static class FieldFrame {
        private final FieldFrame parent;
        private final Set<FieldFrame> children = new HashSet<FieldFrame>();
        private final Set<DetailAST> fields = new HashSet<DetailAST>();
        private final Set<DetailAST> methodCalls = new HashSet<DetailAST>();
        private String frameName;
        private boolean classOrEnumOrEnumConstDef;

        FieldFrame(FieldFrame parent) {
            this.parent = parent;
        }

        public void setFrameName(String frameName) {
            this.frameName = frameName;
        }

        public String getFrameName() {
            return this.frameName;
        }

        public FieldFrame getParent() {
            return this.parent;
        }

        public Set<FieldFrame> getChildren() {
            return Collections.unmodifiableSet(this.children);
        }

        public void addChild(FieldFrame child) {
            this.children.add(child);
        }

        public void addField(DetailAST field) {
            this.fields.add(field);
        }

        public void setClassOrEnumOrEnumConstDef(boolean value) {
            this.classOrEnumOrEnumConstDef = value;
        }

        public boolean isClassOrEnumOrEnumConstDef() {
            return this.classOrEnumOrEnumConstDef;
        }

        public void addMethodCall(DetailAST methodCall) {
            this.methodCalls.add(methodCall);
        }

        public DetailAST findField(String name) {
            DetailAST resultField = null;
            for (DetailAST field : this.fields) {
                if (!FieldFrame.getFieldName(field).equals(name)) continue;
                resultField = field;
                break;
            }
            return resultField;
        }

        public Set<DetailAST> getMethodCalls() {
            return Collections.unmodifiableSet(this.methodCalls);
        }

        private static String getFieldName(DetailAST field) {
            return field.findFirstToken(58).getText();
        }
    }
}

