/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.services.ums;

import com.google.protobuf.AbstractMessage;
import com.opera.core.systems.OperaWebElement;
import com.opera.core.systems.ScopeServices;
import com.opera.core.systems.model.ScriptResult;
import com.opera.core.systems.scope.ESDebuggerCommand;
import com.opera.core.systems.scope.protos.Esdbg6Protos;
import com.opera.core.systems.scope.protos.EsdbgProtos;
import com.opera.core.systems.scope.protos.UmsProtos;
import com.opera.core.systems.scope.services.ums.EcmaScriptDebugger;
import com.opera.core.systems.util.VersionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcmaScriptDebugger6
extends EcmaScriptDebugger {
    public EcmaScriptDebugger6(ScopeServices services, String version) {
        super(services, version);
        if (VersionUtil.compare(version, "7.0") >= 0) {
            throw new UnsupportedOperationException("ecmascript-debugger version " + version + " is not supported");
        }
    }

    @Override
    public Object scriptExecutor(String script, Object ... params) {
        String toSend;
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        if (params != null && params.length > 0) {
            StringBuilder builder = new StringBuilder();
            for (Object object : params) {
                if (builder.toString().length() > 0) {
                    builder.append(",");
                }
                if (object instanceof Collection) {
                    builder.append("[");
                    Collection collection = (Collection)object;
                    for (Object argument : collection) {
                        this.processArgument(argument, builder, elements);
                        builder.append(",");
                    }
                    int lastCharIndex = builder.length() - 1;
                    if (builder.charAt(lastCharIndex) != '[') {
                        builder.deleteCharAt(lastCharIndex);
                    }
                    builder.append("]");
                    continue;
                }
                this.processArgument(object, builder, elements);
            }
            String arguments = builder.toString();
            toSend = "(function(){" + script + "})(" + arguments + ")";
        } else {
            toSend = script;
        }
        EsdbgProtos.EvalData.Builder evalBuilder = this.buildEval(toSend, this.getRuntimeId());
        for (WebElement webElement : elements) {
            EsdbgProtos.EvalData.Variable variable = this.buildVariable(webElement.toString(), ((OperaWebElement)webElement).getObjectId());
            evalBuilder.addVariableList(variable);
        }
        UmsProtos.Response response = this.executeCommand(ESDebuggerCommand.EVAL, (AbstractMessage.Builder<?>)evalBuilder);
        if (response == null) {
            throw new WebDriverException("Internal error while executing script");
        }
        Esdbg6Protos.EvalResult result = this.parseEvalData(response);
        Object parsed = this.parseEvalReply(result);
        if (parsed instanceof Esdbg6Protos.ObjectValue) {
            Esdbg6Protos.ObjectValue data = (Esdbg6Protos.ObjectValue)parsed;
            return new ScriptResult(data.getObjectID(), data.getClassName());
        }
        return parsed;
    }

    private Esdbg6Protos.EvalResult parseEvalData(UmsProtos.Response response) {
        Esdbg6Protos.EvalResult.Builder builder = Esdbg6Protos.EvalResult.newBuilder();
        EcmaScriptDebugger6.buildPayload(response, builder);
        return builder.build();
    }

    @Override
    public Object executeScript(String using, boolean responseExpected) {
        return this.executeScript(using, responseExpected, this.getRuntimeId());
    }

    @Override
    public Object executeScript(String using, boolean responseExpected, int runtimeId) {
        UmsProtos.Response reply = this.eval(using, runtimeId, new EsdbgProtos.EvalData.Variable[0]);
        return responseExpected ? this.parseEvalReply(this.parseEvalData(reply)) : null;
    }

    @Override
    public Integer getObject(String using) {
        Esdbg6Protos.EvalResult reply = this.parseEvalData(this.eval(using, new EsdbgProtos.EvalData.Variable[0]));
        return reply.getType().equals("object") ? Integer.valueOf(reply.getObjectValue().getObjectID()) : null;
    }

    @Override
    public Integer getObject(String using, int runtimeId) {
        Esdbg6Protos.EvalResult reply = this.parseEvalData(this.eval(using, runtimeId, new EsdbgProtos.EvalData.Variable[0]));
        return reply.getType().equals("object") ? Integer.valueOf(reply.getObjectValue().getObjectID()) : null;
    }

    @Override
    public String callFunctionOnObject(String using, int objectId) {
        EsdbgProtos.EvalData.Variable variable = this.buildVariable("locator", objectId);
        Esdbg6Protos.EvalResult reply = this.parseEvalData(this.eval(using, variable));
        return reply.getType().equals("null") ? null : reply.getValue();
    }

    @Override
    public Object callFunctionOnObject(String using, int objectId, boolean responseExpected) {
        EsdbgProtos.EvalData.Variable variable = this.buildVariable("locator", objectId);
        UmsProtos.Response response = this.eval(using, variable);
        return responseExpected ? this.parseEvalReply(this.parseEvalData(response)) : null;
    }

    @Override
    public Integer executeScriptOnObject(String using, int objectId) {
        EsdbgProtos.EvalData.Variable variable = this.buildVariable("locator", objectId);
        Esdbg6Protos.EvalResult reply = this.parseEvalData(this.eval(using, variable));
        Object object = this.parseEvalReply(reply);
        if (object == null || !(object instanceof Esdbg6Protos.ObjectValue)) {
            return null;
        }
        return ((Esdbg6Protos.ObjectValue)object).getObjectID();
    }

    protected Object parseEvalReply(Esdbg6Protos.EvalResult result) {
        String dataType;
        String status = result.getStatus();
        if (!status.equals("completed")) {
            if (status.equals("unhandled-exception")) {
                String message;
                try {
                    message = (String)this.callFunctionOnObject("return locator.name+': '+locator.message;", result.getObjectValue().getObjectID(), true);
                }
                catch (Exception e) {
                    throw new WebDriverException("Ecmascript exception");
                }
                throw new WebDriverException("Ecmascript exception:\n" + message);
            }
            if (status.equals("cancelled-by-scheduler")) {
                return null;
            }
            if (status.equals("aborted")) {
                // empty if block
            }
        }
        if ("string".equals(dataType = result.getType())) {
            return result.getValue();
        }
        if (dataType.equals("number")) {
            return this.parseNumber(result.getValue());
        }
        if (dataType.equals("boolean")) {
            return Boolean.valueOf(result.getValue());
        }
        if (dataType.equals("undefined")) {
            return null;
        }
        if (dataType.equals("object")) {
            return result.getObjectValue();
        }
        return null;
    }

    @Override
    public List<Integer> examineObjects(Integer id) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        Esdbg6Protos.ObjectChainList list = this.getChainList(id);
        List<Esdbg6Protos.ObjectInfo.Property> properties = list.getObjectChainList(0).getObjectListList().get(0).getPropertyListList();
        for (Esdbg6Protos.ObjectInfo.Property property : properties) {
            if (!property.getType().equals("object")) continue;
            ids.add(property.getObjectValue().getObjectID());
        }
        return ids;
    }

    @Override
    public Object examineScriptResult(Integer id) {
        Esdbg6Protos.ObjectChainList list = this.getChainList(id);
        List<Esdbg6Protos.ObjectInfo.Property> properties = list.getObjectChainList(0).getObjectListList().get(0).getPropertyListList();
        String className = list.getObjectChainListList().get(0).getObjectList(0).getValue().getClassName();
        if (className.endsWith("Element")) {
            return new OperaWebElement(this.driver, id);
        }
        if (className.equals("Array")) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Esdbg6Protos.ObjectInfo.Property property : properties) {
                if (property.getType().equals("number") && property.getName().equals("length")) continue;
                if (property.getType().equals("object")) {
                    result.add(this.examineScriptResult(property.getObjectValue().getObjectID()));
                    continue;
                }
                result.add(this.parseValue(property.getType(), property.getValue()));
            }
            return result;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Esdbg6Protos.ObjectInfo.Property property : properties) {
            if (property.getType().equals("number") && property.getName().equals("length")) continue;
            if (property.getType().equals("object")) {
                result.put(property.getName(), this.examineScriptResult(property.getObjectValue().getObjectID()));
                continue;
            }
            result.put(property.getName(), this.parseValue(property.getType(), property.getValue()));
        }
        return result;
    }

    private Esdbg6Protos.ObjectChainList getChainList(Integer id) {
        Esdbg6Protos.ExamineList.Builder examine = Esdbg6Protos.ExamineList.newBuilder();
        examine.setExaminePrototypes(false);
        examine.setRuntimeID(this.getRuntimeId());
        examine.addObjectList(id);
        UmsProtos.Response response = this.executeCommand(ESDebuggerCommand.EXAMINE_OBJECTS, (AbstractMessage.Builder<?>)examine);
        Esdbg6Protos.ObjectChainList.Builder builder = Esdbg6Protos.ObjectChainList.newBuilder();
        EcmaScriptDebugger6.buildPayload(response, builder);
        return builder.build();
    }
}

