/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.aquarius.idgenerator.local.impl;

import com.nepxion.aquarius.common.exception.AquariusException;

public class SnowflakeIdGenerator {
    private static final long DATA_CENTER_ID_BITS = 5L;
    private static final long MACHINE_ID_BITS = 5L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long MAX_DATA_CENTER_ID = 31L;
    private static final long MAX_MACHINE_ID = 31L;
    private static final long MAX_SEQUENCE = 4095L;
    private static final long DATA_CENTER_ID_SHIFT = 17L;
    private static final long MACHINE_ID_SHIFT = 12L;
    private static final long TIMESTAMP_SHIFT = 22L;
    private static final int MAX_BATCH_COUNT = 100000;
    private long dataCenterId;
    private long machineId;
    private long sequence = 0L;
    private long startTimestamp = -1L;
    private long lastTimestamp = -1L;

    public SnowflakeIdGenerator(long startTimestamp, long dataCenterId, long machineId) {
        long currentTimestamp = this.getCurrentTimestamp();
        if (startTimestamp > currentTimestamp) {
            throw new AquariusException(String.format("Start timestamp can't be greater than %d", currentTimestamp));
        }
        if (dataCenterId > 31L || dataCenterId < 0L) {
            throw new AquariusException(String.format("Data center id can't be greater than %d or less than 0", 31L));
        }
        if (machineId > 31L || machineId < 0L) {
            throw new AquariusException(String.format("Machine id can't be greater than %d or less than 0", 31L));
        }
        this.startTimestamp = startTimestamp == currentTimestamp ? startTimestamp - 1L : startTimestamp;
        this.dataCenterId = dataCenterId;
        this.machineId = machineId;
    }

    public String[] nextIds(int count) {
        if (count <= 0 || count > 100000) {
            throw new AquariusException(String.format("Count can't be greater than %d or less than 0", 100000));
        }
        String[] ids = new String[count];
        for (int i = 0; i < count; ++i) {
            ids[i] = this.nextId();
        }
        return ids;
    }

    public synchronized String nextId() {
        long currentTimestamp = this.getCurrentTimestamp();
        if (currentTimestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards. Refusing to generate id for %d milliseconds", this.lastTimestamp - currentTimestamp));
        }
        if (this.lastTimestamp == currentTimestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                currentTimestamp = this.getNextTimestamp(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = currentTimestamp;
        long id = currentTimestamp - this.startTimestamp << 22 | this.dataCenterId << 17 | this.machineId << 12 | this.sequence;
        return String.valueOf(id);
    }

    private long getNextTimestamp(long lastTimestamp) {
        long currentTimestamp = this.getCurrentTimestamp();
        while (currentTimestamp <= lastTimestamp) {
            currentTimestamp = this.getCurrentTimestamp();
        }
        return currentTimestamp;
    }

    private long getCurrentTimestamp() {
        return System.currentTimeMillis();
    }

    public static void main(String[] args) {
        SnowflakeIdGenerator generator = new SnowflakeIdGenerator(1483200000000L, 2L, 3L);
        for (int i = 0; i < 4096; ++i) {
            System.out.println(generator.nextId());
        }
    }
}

