/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.aquarius.idgenerator.local.impl;

import com.nepxion.aquarius.common.util.DateUtil;
import com.nepxion.aquarius.common.util.StringUtil;
import com.nepxion.aquarius.idgenerator.local.LocalIdGenerator;
import com.nepxion.aquarius.idgenerator.local.impl.SnowflakeIdGenerator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class LocalIdGeneratorImpl
implements LocalIdGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(LocalIdGeneratorImpl.class);
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss:SSS";
    private static final long DEFAULT_START_TIMESTAMP = 1483200000000L;
    private volatile Map<String, SnowflakeIdGenerator> idGeneratorMap = new ConcurrentHashMap<String, SnowflakeIdGenerator>();
    @Value(value="${frequent.log.print:false}")
    private Boolean frequentLogPrint;

    @Override
    public String nextUniqueId(long dataCenterId, long machineId) throws Exception {
        return this.nextUniqueId(1483200000000L, dataCenterId, machineId);
    }

    @Override
    public String nextUniqueId(String startTimestamp, long dataCenterId, long machineId) throws Exception {
        return this.nextUniqueId(DateUtil.parseDate((String)startTimestamp, (String)DATE_FORMAT).getTime(), dataCenterId, machineId);
    }

    @Override
    public String nextUniqueId(long startTimestamp, long dataCenterId, long machineId) throws Exception {
        String nextUniqueId = this.getIdGenerator(startTimestamp, dataCenterId, machineId).nextId();
        if (this.frequentLogPrint.booleanValue()) {
            LOG.info("Next unique id is {} for startTimestamp={}, dataCenterId={}, machineId={}", new Object[]{nextUniqueId, startTimestamp, dataCenterId, machineId});
        }
        return nextUniqueId;
    }

    @Override
    public String[] nextUniqueIds(long dataCenterId, long machineId, int count) throws Exception {
        return this.nextUniqueIds(1483200000000L, dataCenterId, machineId, count);
    }

    @Override
    public String[] nextUniqueIds(String startTimestamp, long dataCenterId, long machineId, int count) throws Exception {
        return this.nextUniqueIds(DateUtil.parseDate((String)startTimestamp, (String)DATE_FORMAT).getTime(), dataCenterId, machineId, count);
    }

    @Override
    public String[] nextUniqueIds(long startTimestamp, long dataCenterId, long machineId, int count) throws Exception {
        String[] nextUniqueIds = this.getIdGenerator(startTimestamp, dataCenterId, machineId).nextIds(count);
        if (this.frequentLogPrint.booleanValue()) {
            LOG.info("Next unique ids is {} for startTimestamp={}, dataCenterId={}, machineId={}, count={}", new Object[]{StringUtil.convert((String[])nextUniqueIds), startTimestamp, dataCenterId, machineId, count});
        }
        return nextUniqueIds;
    }

    private SnowflakeIdGenerator getIdGenerator(long startTimestamp, long dataCenterId, long machineId) {
        SnowflakeIdGenerator newIdGnerator;
        String key = dataCenterId + "-" + machineId;
        SnowflakeIdGenerator idGenerator = this.idGeneratorMap.get(key);
        if (idGenerator == null && (idGenerator = this.idGeneratorMap.putIfAbsent(key, newIdGnerator = new SnowflakeIdGenerator(startTimestamp, dataCenterId, machineId))) == null) {
            idGenerator = newIdGnerator;
        }
        return idGenerator;
    }
}

