/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.aquarius.common.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DateUtil {
    private static volatile Map<String, DateTimeFormatter> dateFormatMap = new ConcurrentHashMap<String, DateTimeFormatter>();

    public static String formatDate(Date date, String pattern) {
        DateTimeFormatter dateTimeFormatter = DateUtil.getDateTimeFormatter(pattern);
        ZoneId zoneId = ZoneId.systemDefault();
        Instant instant = date.toInstant();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zoneId);
        return localDateTime.format(dateTimeFormatter);
    }

    public static Date parseDate(String date, String pattern) {
        DateTimeFormatter dateTimeFormatter = DateUtil.getDateTimeFormatter(pattern);
        LocalDateTime localDateTime = LocalDateTime.parse(date, dateTimeFormatter);
        ZoneId zoneId = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zoneId).toInstant();
        return Date.from(instant);
    }

    private static DateTimeFormatter getDateTimeFormatter(String pattern) {
        DateTimeFormatter newDateTimeFormatter;
        DateTimeFormatter dateTimeFormatter = dateFormatMap.get(pattern);
        if (dateTimeFormatter == null && (dateTimeFormatter = dateFormatMap.putIfAbsent(pattern, newDateTimeFormatter = DateTimeFormatter.ofPattern(pattern))) == null) {
            dateTimeFormatter = newDateTimeFormatter;
        }
        return dateTimeFormatter;
    }
}

