/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.aquarius.common.property;

import com.nepxion.aquarius.common.property.AquariusContent;
import com.nepxion.aquarius.common.util.MathsUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public class AquariusProperties
implements Serializable {
    private static final long serialVersionUID = 1722927234615067236L;
    private final Map<String, String> map;
    private String content;

    public AquariusProperties(String path, String stringEncoding, String readerEncoding) throws IOException {
        this(new AquariusContent(path, stringEncoding).getContent(), readerEncoding);
    }

    public AquariusProperties(byte[] bytes, String stringEncoding, String readerEncoding) throws IOException {
        this(new String(bytes, stringEncoding), readerEncoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AquariusProperties(String content, String encoding) throws IOException {
        InputStream inputStream;
        block6: {
            this.map = new LinkedHashMap<String, String>();
            this.content = content;
            inputStream = null;
            InputStreamReader reader = null;
            try {
                inputStream = IOUtils.toInputStream((String)content, (String)encoding);
                reader = new InputStreamReader(inputStream, encoding);
                Properties properties = new Properties();
                properties.load(reader);
                Iterator<Object> iterator = properties.keySet().iterator();
                while (iterator.hasNext()) {
                    String key = iterator.next().toString();
                    String value = properties.getProperty(key);
                    this.put(key, value);
                }
                if (reader == null) break block6;
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    IOUtils.closeQuietly(reader);
                }
                if (inputStream != null) {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)reader);
        }
        if (inputStream != null) {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public String getContent() {
        return this.content;
    }

    public void put(String key, String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null for key [" + key + "]");
        }
        Long result = MathsUtil.calculate(value);
        if (result != null) {
            this.map.put(key, String.valueOf(result));
        } else {
            this.map.put(key, value);
        }
    }

    public Map<String, String> getMap() {
        return this.map;
    }

    public String getString(String key) {
        if (!this.map.containsKey(key)) {
            throw new IllegalArgumentException("Key [" + key + "] isn't found in properties");
        }
        return this.map.get(key);
    }

    public String getString(String key, String defaultValue) {
        String value = this.getString(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public boolean getBoolean(String key) {
        String value = this.getString(key);
        if (value != null) {
            try {
                return Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Value [" + value + "] for key [" + key + "] can't be parsed to boolean", e);
            }
        }
        throw new IllegalArgumentException("Value [" + value + "] for key [" + key + "] is null");
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.getString(key);
        if (value != null) {
            try {
                return Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Value [" + value + "] for key [" + key + "] can't be parsed to boolean", e);
            }
        }
        return defaultValue;
    }

    public int getInteger(String key) {
        String value = this.getString(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Value [" + value + "] for key [" + key + "] can't be parsed to int", e);
            }
        }
        throw new IllegalArgumentException("Value [" + value + "] for key [" + key + "] is null");
    }

    public int getInteger(String key, int defaultValue) {
        String value = this.getString(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Value [" + value + "] for key [" + key + "] can't be parsed to int", e);
            }
        }
        return defaultValue;
    }

    public long getLong(String key) {
        String value = this.getString(key);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Value [" + value + "] for key [" + key + "] can't be parsed to long", e);
            }
        }
        throw new IllegalArgumentException("Value [" + value + "] for key [" + key + "] is null");
    }

    public long getLong(String key, long defaultValue) {
        String value = this.getString(key);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Value [" + value + "] for key [" + key + "] can't be parsed to long", e);
            }
        }
        return defaultValue;
    }

    public short getShort(String key, short defaultValue) {
        String value = this.getString(key);
        if (value != null) {
            try {
                return Short.parseShort(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Value [" + value + "] for key [" + key + "] can't be parsed to short", e);
            }
        }
        throw new IllegalArgumentException("Value [" + value + "] for key [" + key + "] is null");
    }

    public Short getShort(String key, Short defaultValue) {
        String value = this.getString(key);
        if (value != null) {
            try {
                return Short.parseShort(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Value [" + value + "] for key [" + key + "] can't be parsed to short", e);
            }
        }
        return defaultValue;
    }

    public byte getByte(String key) {
        String value = this.getString(key);
        if (value != null) {
            try {
                return Byte.parseByte(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Value [" + value + "] for key [" + key + "] can't be parsed to byte", e);
            }
        }
        throw new IllegalArgumentException("Value [" + value + "] for key [" + key + "] is null");
    }

    public byte getByte(String key, byte defaultValue) {
        String value = this.getString(key);
        if (value != null) {
            try {
                return Byte.parseByte(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Value [" + value + "] for key [" + key + "] can't be parsed to byte", e);
            }
        }
        return defaultValue;
    }

    public double getDouble(String key) {
        String value = this.getString(key);
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Value [" + value + "] for key [" + key + "] can't be parsed to double", e);
            }
        }
        throw new IllegalArgumentException("Value [" + value + "] for key [" + key + "] is null");
    }

    public double getDouble(String key, double defaultValue) {
        String value = this.getString(key);
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Value [" + value + "] for key [" + key + "] can't be parsed to double", e);
            }
        }
        return defaultValue;
    }

    public float getFloat(String key) {
        String value = this.getString(key);
        if (value != null) {
            try {
                return Float.parseFloat(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Value [" + value + "] for key [" + key + "] can't be parsed to float", e);
            }
        }
        throw new IllegalArgumentException("Value [" + value + "] for key [" + key + "] is null");
    }

    public float getFloat(String key, float defaultValue) {
        String value = this.getString(key);
        if (value != null) {
            try {
                return Float.parseFloat(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Value [" + value + "] for key [" + key + "] can't be parsed to float", e);
            }
        }
        return defaultValue;
    }

    public BigInteger getBigInteger(String key) {
        String value = this.getString(key);
        if (value != null) {
            try {
                return BigInteger.valueOf(Long.parseLong(value));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Value [" + value + "] for key [" + key + "] can't be parsed to BigInteger", e);
            }
        }
        throw new IllegalArgumentException("Value [" + value + "] for key [" + key + "] is null");
    }

    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        String value = this.getString(key);
        if (value != null) {
            try {
                return BigInteger.valueOf(Long.parseLong(value));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Value [" + value + "] for key [" + key + "] can't be parsed to BigInteger", e);
            }
        }
        return defaultValue;
    }

    public BigDecimal getBigDecimal(String key) {
        String value = this.getString(key);
        if (value != null) {
            try {
                return BigDecimal.valueOf(Double.parseDouble(value));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Value [" + value + "] for key [" + key + "] can't be parsed to BigDecimal", e);
            }
        }
        throw new IllegalArgumentException("Value [" + value + "] for key [" + key + "] is null");
    }

    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        String value = this.getString(key);
        if (value != null) {
            try {
                return BigDecimal.valueOf(Double.parseDouble(value));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Value [" + value + "] for key [" + key + "] can't be parsed to BigDecimal", e);
            }
        }
        return defaultValue;
    }

    public void mergeProperties(AquariusProperties properties) {
        this.map.putAll(properties.getMap());
    }

    public String toString() {
        return this.map.toString();
    }
}

