/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.io;

import com.mzlion.core.digest.DigestUtils;
import com.mzlion.core.digest.MD5;
import com.mzlion.core.exceptions.FatalStreamException;
import com.mzlion.core.lang.Assert;
import com.mzlion.core.lang.StringUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IOUtils {
    private static Logger logger = LoggerFactory.getLogger(IOUtils.class);
    private static final int EOF = -1;
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static byte[] toByteArray(InputStream in) {
        Assert.notNull(in, "Input stream must not be null.");
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        if (IOUtils.copy(in, (OutputStream)out) == -1) {
            return null;
        }
        return out.toByteArray();
    }

    public static byte[] toByteArray(InputStream in, int size) {
        Assert.notNull(in, "Input stream must not be null.");
        if (size < 0) {
            throw new IllegalArgumentException("Size must be equal or greater than zero: " + size);
        }
        if (size == 0) {
            return new byte[0];
        }
        byte[] data = new byte[size];
        try {
            int offset;
            int readed;
            for (offset = 0; offset < size && (readed = in.read(data, offset, size - offset)) != -1; offset += readed) {
            }
            if (offset != size) {
                throw new IOException("Unexpected readed size. current: " + offset + ", excepted: " + size);
            }
        }
        catch (IOException e) {
            throw new FatalStreamException(e);
        }
        return data;
    }

    public static byte[] toByteArray(Reader reader) {
        return IOUtils.toByteArray(reader, Charset.defaultCharset());
    }

    public static byte[] toByteArray(Reader reader, String encoding) {
        return IOUtils.toByteArray(reader, StringUtils.isEmpty(encoding) ? Charset.defaultCharset() : Charset.forName(encoding));
    }

    public static byte[] toByteArray(Reader reader, Charset encoding) {
        ByteArrayOutputStream out;
        Assert.notNull(reader, "Reader must not be null.");
        if (encoding == null) {
            encoding = Charset.defaultCharset();
        }
        if (!IOUtils.copy(reader, (OutputStream)(out = new ByteArrayOutputStream(1024)), encoding)) {
            return null;
        }
        return out.toByteArray();
    }

    public static String toString(InputStream in) {
        return IOUtils.toString(in, Charset.defaultCharset());
    }

    public static String toString(InputStream in, String encoding) {
        return IOUtils.toString(in, StringUtils.isEmpty(encoding) ? Charset.defaultCharset() : Charset.forName(encoding));
    }

    public static String toString(InputStream in, Charset encoding) {
        Assert.notNull(in, "InputStream must not be null.");
        StringWriter writer = new StringWriter();
        if (!IOUtils.copy(in, (Writer)writer, encoding)) {
            return null;
        }
        return writer.toString();
    }

    public static String toString(Reader reader) {
        Assert.notNull(reader, "Reader must not be null.");
        StringWriter writer = new StringWriter();
        if (IOUtils.copy(reader, (Writer)writer) == -1) {
            return null;
        }
        return writer.toString();
    }

    public static int copy(InputStream in, OutputStream out) {
        long count = IOUtils.copyLarge(in, out);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(InputStream in, OutputStream out) {
        return IOUtils.copyLarge(in, out, new byte[4096]);
    }

    public static long copyLarge(InputStream in, OutputStream out, byte[] buffer) {
        Assert.notNull(in, "InputStream must not be null.");
        Assert.notNull(out, "OutputStream must not be null.");
        Assert.notEmpty(buffer, "The buffer array must not null or empty.");
        long count = 0L;
        try {
            int n;
            while (-1 != (n = in.read(buffer))) {
                out.write(buffer, 0, n);
                count += (long)n;
            }
            return count;
        }
        catch (IOException e) {
            throw new FatalStreamException("Copy bytes from a large InputStream to an OutputStream error", e);
        }
    }

    public static boolean copy(InputStream in, Writer writer) {
        return IOUtils.copy(in, writer, Charset.defaultCharset());
    }

    public static boolean copy(InputStream in, Writer writer, String encoding) {
        return IOUtils.copy(in, writer, StringUtils.isEmpty(encoding) ? Charset.defaultCharset() : Charset.forName(encoding));
    }

    public static boolean copy(InputStream in, Writer writer, Charset encoding) {
        Assert.notNull(in, "Input stream must not be null.");
        InputStreamReader reader = new InputStreamReader(in, encoding == null ? Charset.defaultCharset() : encoding);
        return IOUtils.copy((Reader)reader, writer) > 0;
    }

    public static int copy(Reader reader, Writer writer) {
        long count = IOUtils.copyLarge(reader, writer);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(Reader reader, Writer writer) {
        return IOUtils.copyLarge(reader, writer, new char[4096]);
    }

    public static long copyLarge(Reader reader, Writer writer, char[] buffer) {
        long count = 0L;
        int n = 0;
        try {
            while (-1 != (n = reader.read(buffer))) {
                writer.write(buffer, 0, n);
                count += (long)n;
            }
        }
        catch (IOException e) {
            logger.error(" ===> Copy bytes from a large Reader to an Writer error", (Throwable)e);
            return -1L;
        }
        return count;
    }

    public static boolean copy(Reader reader, OutputStream out) {
        return IOUtils.copy(reader, out, Charset.defaultCharset());
    }

    public static boolean copy(Reader reader, OutputStream out, String encoding) {
        return IOUtils.copy(reader, out, StringUtils.isEmpty(encoding) ? Charset.defaultCharset() : Charset.forName(encoding));
    }

    public static boolean copy(Reader reader, OutputStream out, Charset encoding) {
        Assert.notNull(reader, "Reader must not be null.");
        Assert.notNull(out, "Output stream must not be null.");
        encoding = encoding == null ? Charset.defaultCharset() : encoding;
        OutputStreamWriter writer = new OutputStreamWriter(out, encoding);
        if (IOUtils.copy(reader, (Writer)writer) == -1) {
            return false;
        }
        try {
            writer.flush();
        }
        catch (IOException e) {
            logger.error(" ===> Flush outputStream error", (Throwable)e);
            return false;
        }
        return true;
    }

    public static String md5Hex(InputStream in) {
        return MD5.digestHex(in);
    }

    public static String sha1Hex(FileInputStream in) {
        return DigestUtils.sha1Hex(in);
    }

    public static List<String> readLines(InputStream in) {
        return IOUtils.readLines(in, Charset.defaultCharset());
    }

    public static List<String> readLines(InputStream in, Charset charset) {
        Assert.notNull(in, "The parameter[in] is null.");
        InputStreamReader reader = new InputStreamReader(in, charset);
        return IOUtils.readLines(reader);
    }

    public static List<String> readLines(Reader reader) {
        BufferedReader bufferedReader = IOUtils.to(reader);
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line = bufferedReader.readLine();
            while (line != null) {
                lines.add(line);
                line = bufferedReader.readLine();
            }
            return lines;
        }
        catch (IOException e) {
            throw new FatalStreamException(e);
        }
    }

    private static BufferedReader to(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }
}

