/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.http;

import com.mzlion.core.lang.StringUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ContentType {
    public static final ContentType ALL = ContentType.create("*/*", (Charset)null);
    public static final ContentType TEXT_XML = ContentType.create("text/xml", StandardCharsets.UTF_8);
    public static final ContentType TEXT_PLAIN = ContentType.create("text/plain", StandardCharsets.UTF_8);
    public static final ContentType TEXT_HTML = ContentType.create("text/html", StandardCharsets.UTF_8);
    public static final ContentType MULTIPART_FORM_DATA = ContentType.create("multipart/form-data", StandardCharsets.UTF_8);
    public static final ContentType APPLICATION_XML = ContentType.create("application/xml", StandardCharsets.UTF_8);
    public static final ContentType APPLICATION_OCTET_STREAM = ContentType.create("application/octet-stream", (Charset)null);
    public static final ContentType APPLICATION_FORM_URLENCODED = ContentType.create("application/x-www-form-urlencoded", StandardCharsets.UTF_8);
    public static final ContentType APPLICATION_JSON = ContentType.create("application/json", StandardCharsets.UTF_8);
    public static final ContentType IMAGE_PNG = ContentType.create("image/png", (Charset)null);
    public static final ContentType IMAGE_JPEG = ContentType.create("image/jpeg", (Charset)null);
    public static final ContentType IMAGE_JPG = ContentType.create("image/jpeg", (Charset)null);
    public static final ContentType IMAGE_GIF = ContentType.create("image/gif", (Charset)null);
    public static final ContentType IMAGE_BMP = ContentType.create("image/bmp", (Charset)null);
    public static final ContentType APPLICATION_ZIP = ContentType.create("application/zip", (Charset)null);
    public static final ContentType APPLICATION_GZ = ContentType.create("application/x-gzip", (Charset)null);
    public static final ContentType APPLICATION_PDF = ContentType.create("application/pdf", (Charset)null);
    public static final ContentType APPLICATION_DOC = ContentType.create("application/msword", (Charset)null);
    public static final ContentType APPLICATION_XLS = ContentType.create("application/vnd.ms-excel", (Charset)null);
    public static final ContentType APPLICATION_PPT = ContentType.create("application/vnd.ms-powerpoint", (Charset)null);
    public static final ContentType APPLICATION_APK = ContentType.create("application/vnd.android.package-archive", (Charset)null);
    public static final ContentType APPLICATION_IPA = ContentType.create("application/iphone", (Charset)null);
    public static final ContentType DEFAULT_TEXT = TEXT_PLAIN;
    public static final ContentType DEFAULT_BINARY = APPLICATION_OCTET_STREAM;
    private static final Map<String, ContentType> supportFileExts;
    private String mimeType;
    private Charset charset;

    ContentType(String mimeType, Charset charset) {
        this.mimeType = mimeType;
        this.charset = charset;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public static ContentType create(String mimeType, Charset charset) {
        return StringUtils.isEmpty(mimeType) ? DEFAULT_BINARY : new ContentType(mimeType.toLowerCase(Locale.CHINESE), charset);
    }

    public static ContentType create(String mimeType, String charset) {
        return ContentType.create(mimeType, StringUtils.isEmpty(charset) ? null : Charset.forName(charset));
    }

    public static ContentType create(String mimeType) {
        return ContentType.create(mimeType, (Charset)null);
    }

    public static ContentType parseByFileExt(String fileExt) {
        if (StringUtils.isEmpty(fileExt)) {
            return DEFAULT_BINARY;
        }
        ContentType contentType = supportFileExts.get(fileExt = fileExt.toLowerCase());
        return contentType == null ? DEFAULT_BINARY : contentType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.mimeType);
        if (this.charset != null) {
            sb.append("; charset=").append(this.charset.name());
        }
        return sb.toString();
    }

    static {
        ConcurrentHashMap<String, ContentType> _supportFileExts = new ConcurrentHashMap<String, ContentType>();
        _supportFileExts.put("xml", APPLICATION_XML);
        _supportFileExts.put("json", APPLICATION_JSON);
        _supportFileExts.put("doc", APPLICATION_DOC);
        _supportFileExts.put("docx", APPLICATION_DOC);
        _supportFileExts.put("xls", APPLICATION_XLS);
        _supportFileExts.put("xlsx", APPLICATION_XLS);
        _supportFileExts.put("ppt", APPLICATION_PPT);
        _supportFileExts.put("pptx", APPLICATION_PPT);
        _supportFileExts.put("pdf", APPLICATION_PDF);
        _supportFileExts.put("zip", APPLICATION_ZIP);
        _supportFileExts.put("gzip", APPLICATION_GZ);
        _supportFileExts.put("png", IMAGE_PNG);
        _supportFileExts.put("jpeg", IMAGE_JPEG);
        _supportFileExts.put("jpg", IMAGE_JPG);
        _supportFileExts.put("gif", IMAGE_GIF);
        _supportFileExts.put("html", TEXT_HTML);
        _supportFileExts.put("txt", TEXT_PLAIN);
        _supportFileExts.put("apk", APPLICATION_APK);
        _supportFileExts.put("ipa", APPLICATION_IPA);
        supportFileExts = _supportFileExts;
    }
}

