/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.beans;

import com.mzlion.core.exceptions.FatalBeanException;
import com.mzlion.core.lang.Assert;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;

public class PropertyUtilBean {
    private final WeakHashMap<Class<?>, List<PropertyDescriptor>> descriptorsCache = new WeakHashMap();

    public static PropertyUtilBean getInstance() {
        return new PropertyUtilBean();
    }

    private PropertyUtilBean() {
    }

    public List<PropertyDescriptor> getPropertyDescriptors(Object bean) {
        Assert.notNull(bean, "Bean must not be null.");
        return this.getPropertyDescriptors(bean.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PropertyDescriptor> getPropertyDescriptors(Class<?> beanClass) {
        List<PropertyDescriptor> propertyDescriptorList;
        Assert.notNull(beanClass, "BeanClass must not be null.");
        WeakHashMap<Class<?>, List<PropertyDescriptor>> weakHashMap = this.descriptorsCache;
        synchronized (weakHashMap) {
            propertyDescriptorList = this.descriptorsCache.get(beanClass);
        }
        if (propertyDescriptorList == null) {
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
                PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
                propertyDescriptorList = new ArrayList<PropertyDescriptor>(propertyDescriptors.length);
                for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                    if ("class".equals(propertyDescriptor.getName())) continue;
                    propertyDescriptorList.add(propertyDescriptor);
                }
                WeakHashMap<Class<?>, List<PropertyDescriptor>> weakHashMap2 = this.descriptorsCache;
                synchronized (weakHashMap2) {
                    this.descriptorsCache.put(beanClass, propertyDescriptorList);
                }
            }
            catch (IntrospectionException e) {
                throw new FatalBeanException(String.format("Failed to obtain BeanInfo for class [%s]", beanClass.getName()), e);
            }
        }
        return propertyDescriptorList;
    }

    public PropertyDescriptor getPropertyDescriptor(Object bean, String propertyName) {
        Assert.notNull(bean, "Bean must not be null.");
        return this.getPropertyDescriptor(bean.getClass(), propertyName);
    }

    public PropertyDescriptor getPropertyDescriptor(Class<?> beanClass, String propertyName) {
        List<PropertyDescriptor> propertyDescriptors = this.getPropertyDescriptors(beanClass);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (!propertyDescriptor.getName().equals(propertyName)) continue;
            return propertyDescriptor;
        }
        return null;
    }

    public void clearDescriptors() {
        this.descriptorsCache.clear();
    }
}

