/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.microsoft.azure.storage.blob.models.AccountKind;
import com.microsoft.azure.storage.blob.models.SkuName;
import com.microsoft.rest.v2.DateTimeRfc1123;
import java.time.OffsetDateTime;

@JacksonXmlRootElement(localName="Container-GetAccountInfo-Headers")
public final class ContainerGetAccountInfoHeaders {
    @JsonProperty(value="x-ms-request-id")
    private String requestId;
    @JsonProperty(value="x-ms-version")
    private String version;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 date;
    @JsonProperty(value="x-ms-sku-name")
    private SkuName skuName;
    @JsonProperty(value="x-ms-account-kind")
    private AccountKind accountKind;

    public String requestId() {
        return this.requestId;
    }

    public ContainerGetAccountInfoHeaders withRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String version() {
        return this.version;
    }

    public ContainerGetAccountInfoHeaders withVersion(String version) {
        this.version = version;
        return this;
    }

    public OffsetDateTime date() {
        if (this.date == null) {
            return null;
        }
        return this.date.dateTime();
    }

    public ContainerGetAccountInfoHeaders withDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }

    public SkuName skuName() {
        return this.skuName;
    }

    public ContainerGetAccountInfoHeaders withSkuName(SkuName skuName) {
        this.skuName = skuName;
        return this;
    }

    public AccountKind accountKind() {
        return this.accountKind;
    }

    public ContainerGetAccountInfoHeaders withAccountKind(AccountKind accountKind) {
        this.accountKind = accountKind;
        return this;
    }
}

