/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.BlobSASPermission;
import com.microsoft.azure.storage.blob.ContainerSASPermission;
import com.microsoft.azure.storage.blob.IPRange;
import com.microsoft.azure.storage.blob.SASProtocol;
import com.microsoft.azure.storage.blob.SASQueryParameters;
import com.microsoft.azure.storage.blob.SharedKeyCredentials;
import com.microsoft.azure.storage.blob.Utility;
import com.microsoft.azure.storage.blob.models.UserDelegationKey;
import java.security.InvalidKeyException;
import java.time.OffsetDateTime;

public final class ServiceSASSignatureValues {
    private String version = "2018-11-09";
    private SASProtocol protocol;
    private OffsetDateTime startTime;
    private OffsetDateTime expiryTime;
    private String permissions;
    private IPRange ipRange;
    private String containerName;
    private String blobName;
    private String snapshotId;
    private String identifier;
    private String cacheControl;
    private String contentDisposition;
    private String contentEncoding;
    private String contentLanguage;
    private String contentType;

    public String version() {
        return this.version;
    }

    public ServiceSASSignatureValues withVersion(String version) {
        this.version = version;
        return this;
    }

    public SASProtocol protocol() {
        return this.protocol;
    }

    public ServiceSASSignatureValues withProtocol(SASProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public ServiceSASSignatureValues withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime expiryTime() {
        return this.expiryTime;
    }

    public ServiceSASSignatureValues withExpiryTime(OffsetDateTime expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    public String permissions() {
        return this.permissions;
    }

    public ServiceSASSignatureValues withPermissions(String permissions) {
        this.permissions = permissions;
        return this;
    }

    public IPRange ipRange() {
        return this.ipRange;
    }

    public ServiceSASSignatureValues withIpRange(IPRange ipRange) {
        this.ipRange = ipRange;
        return this;
    }

    public String containerName() {
        return this.containerName;
    }

    public ServiceSASSignatureValues withContainerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    public String blobName() {
        return this.blobName;
    }

    public ServiceSASSignatureValues withBlobName(String blobName) {
        this.blobName = blobName;
        return this;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    public ServiceSASSignatureValues withSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
        return this;
    }

    public String identifier() {
        return this.identifier;
    }

    public ServiceSASSignatureValues withIdentifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public String cacheControl() {
        return this.cacheControl;
    }

    public ServiceSASSignatureValues withCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public String contentDisposition() {
        return this.contentDisposition;
    }

    public ServiceSASSignatureValues withContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public String contentEncoding() {
        return this.contentEncoding;
    }

    public ServiceSASSignatureValues withContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public String contentLanguage() {
        return this.contentLanguage;
    }

    public ServiceSASSignatureValues withContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public String contentType() {
        return this.contentType;
    }

    public ServiceSASSignatureValues withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public SASQueryParameters generateSASQueryParameters(SharedKeyCredentials sharedKeyCredentials) {
        Utility.assertNotNull("sharedKeyCredentials", sharedKeyCredentials);
        this.assertGenerateOK();
        String resource = this.getResource();
        String verifiedPermissions = this.getVerifiedPermissions();
        String stringToSign = this.stringToSign(verifiedPermissions, resource, sharedKeyCredentials);
        String signature = null;
        try {
            signature = sharedKeyCredentials.computeHmac256(stringToSign);
        }
        catch (InvalidKeyException e) {
            throw new Error(e);
        }
        return new SASQueryParameters(this.version, null, null, this.protocol, this.startTime, this.expiryTime, this.ipRange, this.identifier, resource, this.permissions, signature, this.cacheControl, this.contentDisposition, this.contentEncoding, this.contentLanguage, this.contentType, null);
    }

    public SASQueryParameters generateSASQueryParameters(UserDelegationKey delegationKey, String accountName) {
        Utility.assertNotNull("delegationKey", delegationKey);
        Utility.assertNotNull("accountName", accountName);
        this.assertGenerateOK();
        String resource = this.getResource();
        String verifiedPermissions = this.getVerifiedPermissions();
        String stringToSign = this.stringToSign(verifiedPermissions, resource, delegationKey, accountName);
        String signature = null;
        try {
            signature = Utility.delegateComputeHmac256(delegationKey, stringToSign);
        }
        catch (InvalidKeyException e) {
            throw new Error(e);
        }
        return new SASQueryParameters(this.version, null, null, this.protocol, this.startTime, this.expiryTime, this.ipRange, null, resource, this.permissions, signature, this.cacheControl, this.contentDisposition, this.contentEncoding, this.contentLanguage, this.contentType, delegationKey);
    }

    private void assertGenerateOK() {
        Utility.assertNotNull("version", this.version);
        Utility.assertNotNull("containerName", this.containerName);
        if (this.blobName == null && this.snapshotId != null) {
            throw new IllegalArgumentException("Cannot set a snapshotId without a blobName.");
        }
    }

    private String getResource() {
        String resource = "c";
        if (!Utility.isNullOrEmpty(this.blobName)) {
            resource = this.snapshotId != null && !this.snapshotId.isEmpty() ? "bs" : "b";
        }
        return resource;
    }

    private String getVerifiedPermissions() {
        String verifiedPermissions = null;
        if (Utility.isNullOrEmpty(this.blobName)) {
            if (this.permissions != null) {
                verifiedPermissions = ContainerSASPermission.parse(this.permissions).toString();
            }
        } else if (this.permissions != null) {
            verifiedPermissions = BlobSASPermission.parse(this.permissions).toString();
        }
        return verifiedPermissions;
    }

    private String getCanonicalName(String accountName) {
        StringBuilder canonicalName = new StringBuilder("/blob");
        canonicalName.append('/').append(accountName).append('/').append(this.containerName);
        if (!Utility.isNullOrEmpty(this.blobName)) {
            canonicalName.append("/").append(this.blobName);
        }
        return canonicalName.toString();
    }

    private String stringToSign(String verifiedPermissions, String resource, SharedKeyCredentials sharedKeyCredentials) {
        return String.join((CharSequence)"\n", verifiedPermissions == null ? "" : verifiedPermissions, this.startTime == null ? "" : Utility.ISO8601UTCDateFormatter.format(this.startTime), this.expiryTime == null ? "" : Utility.ISO8601UTCDateFormatter.format(this.expiryTime), this.getCanonicalName(sharedKeyCredentials.getAccountName()), this.identifier == null ? "" : this.identifier, this.ipRange == null ? new IPRange().toString() : this.ipRange.toString(), this.protocol == null ? "" : this.protocol.toString(), this.version == null ? "" : this.version, resource == null ? "" : resource, this.snapshotId == null ? "" : this.snapshotId, this.cacheControl == null ? "" : this.cacheControl, this.contentDisposition == null ? "" : this.contentDisposition, this.contentEncoding == null ? "" : this.contentEncoding, this.contentLanguage == null ? "" : this.contentLanguage, this.contentType == null ? "" : this.contentType);
    }

    private String stringToSign(String verifiedPermissions, String resource, UserDelegationKey key, String accountName) {
        return String.join((CharSequence)"\n", verifiedPermissions == null ? "" : verifiedPermissions, this.startTime == null ? "" : Utility.ISO8601UTCDateFormatter.format(this.startTime), this.expiryTime == null ? "" : Utility.ISO8601UTCDateFormatter.format(this.expiryTime), this.getCanonicalName(accountName), key.signedOid() == null ? "" : key.signedOid(), key.signedTid() == null ? "" : key.signedTid(), key.signedStart() == null ? "" : Utility.ISO8601UTCDateFormatter.format(key.signedStart()), key.signedExpiry() == null ? "" : Utility.ISO8601UTCDateFormatter.format(key.signedExpiry()), key.signedService() == null ? "" : key.signedService(), key.signedVersion() == null ? "" : key.signedVersion(), this.ipRange == null ? new IPRange().toString() : this.ipRange.toString(), this.protocol == null ? "" : this.protocol.toString(), this.version == null ? "" : this.version, resource == null ? "" : resource, this.snapshotId == null ? "" : this.snapshotId, this.cacheControl == null ? "" : this.cacheControl, this.contentDisposition == null ? "" : this.contentDisposition, this.contentEncoding == null ? "" : this.contentEncoding, this.contentLanguage == null ? "" : this.contentLanguage, this.contentType == null ? "" : this.contentType);
    }
}

