/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.GeneratedStorageClient;
import com.microsoft.azure.storage.blob.models.AccessTier;
import com.microsoft.azure.storage.blob.models.BlobAbortCopyFromURLResponse;
import com.microsoft.azure.storage.blob.models.BlobAcquireLeaseResponse;
import com.microsoft.azure.storage.blob.models.BlobBreakLeaseResponse;
import com.microsoft.azure.storage.blob.models.BlobChangeLeaseResponse;
import com.microsoft.azure.storage.blob.models.BlobCopyFromURLResponse;
import com.microsoft.azure.storage.blob.models.BlobCreateSnapshotResponse;
import com.microsoft.azure.storage.blob.models.BlobDeleteResponse;
import com.microsoft.azure.storage.blob.models.BlobDownloadResponse;
import com.microsoft.azure.storage.blob.models.BlobGetAccountInfoResponse;
import com.microsoft.azure.storage.blob.models.BlobGetPropertiesResponse;
import com.microsoft.azure.storage.blob.models.BlobHTTPHeaders;
import com.microsoft.azure.storage.blob.models.BlobReleaseLeaseResponse;
import com.microsoft.azure.storage.blob.models.BlobRenewLeaseResponse;
import com.microsoft.azure.storage.blob.models.BlobSetHTTPHeadersResponse;
import com.microsoft.azure.storage.blob.models.BlobSetMetadataResponse;
import com.microsoft.azure.storage.blob.models.BlobSetTierResponse;
import com.microsoft.azure.storage.blob.models.BlobStartCopyFromURLResponse;
import com.microsoft.azure.storage.blob.models.BlobUndeleteResponse;
import com.microsoft.azure.storage.blob.models.DeleteSnapshotsOptionType;
import com.microsoft.azure.storage.blob.models.LeaseAccessConditions;
import com.microsoft.azure.storage.blob.models.ModifiedAccessConditions;
import com.microsoft.azure.storage.blob.models.SourceModifiedAccessConditions;
import com.microsoft.azure.storage.blob.models.StorageErrorException;
import com.microsoft.rest.v2.Context;
import com.microsoft.rest.v2.DateTimeRfc1123;
import com.microsoft.rest.v2.RestProxy;
import com.microsoft.rest.v2.ServiceCallback;
import com.microsoft.rest.v2.ServiceClient;
import com.microsoft.rest.v2.ServiceFuture;
import com.microsoft.rest.v2.Validator;
import com.microsoft.rest.v2.annotations.DELETE;
import com.microsoft.rest.v2.annotations.ExpectedResponses;
import com.microsoft.rest.v2.annotations.GET;
import com.microsoft.rest.v2.annotations.HEAD;
import com.microsoft.rest.v2.annotations.HeaderParam;
import com.microsoft.rest.v2.annotations.Host;
import com.microsoft.rest.v2.annotations.HostParam;
import com.microsoft.rest.v2.annotations.PUT;
import com.microsoft.rest.v2.annotations.QueryParam;
import com.microsoft.rest.v2.annotations.UnexpectedResponseExceptionType;
import com.microsoft.rest.v2.util.Base64Util;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.reactivex.annotations.NonNull;
import java.net.URL;
import java.nio.ByteBuffer;
import java.time.OffsetDateTime;
import java.util.Map;

public final class GeneratedBlobs {
    private BlobsService service;
    private GeneratedStorageClient client;

    public GeneratedBlobs(GeneratedStorageClient client) {
        this.service = (BlobsService)RestProxy.create(BlobsService.class, (ServiceClient)client);
        this.client = client;
    }

    public Flowable<ByteBuffer> download(Context context, String snapshot, Integer timeout, String range, Boolean rangeGetContentMD5, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        return (Flowable)this.downloadAsync(context, snapshot, timeout, range, rangeGetContentMD5, requestId, leaseAccessConditions, modifiedAccessConditions).blockingGet();
    }

    public ServiceFuture<Flowable<ByteBuffer>> downloadAsync(Context context, String snapshot, Integer timeout, String range, Boolean rangeGetContentMD5, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, ServiceCallback<Flowable<ByteBuffer>> serviceCallback) {
        return ServiceFuture.fromBody(this.downloadAsync(context, snapshot, timeout, range, rangeGetContentMD5, requestId, leaseAccessConditions, modifiedAccessConditions), serviceCallback);
    }

    public Single<BlobDownloadResponse> downloadWithRestResponseAsync(Context context, String snapshot, Integer timeout, String range, Boolean rangeGetContentMD5, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        Validator.validate((Object)leaseAccessConditions);
        Validator.validate((Object)modifiedAccessConditions);
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.ifMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.ifNoneMatch();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.download(context, this.client.url(), snapshot, timeout, range, rangeGetContentMD5, this.client.version(), requestId, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch);
    }

    public Maybe<Flowable<ByteBuffer>> downloadAsync(Context context, String snapshot, Integer timeout, String range, Boolean rangeGetContentMD5, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        return this.downloadWithRestResponseAsync(context, snapshot, timeout, range, rangeGetContentMD5, requestId, leaseAccessConditions, modifiedAccessConditions).flatMapMaybe(res -> res.body() == null ? Maybe.empty() : Maybe.just(res.body()));
    }

    public void getProperties(Context context, String snapshot, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        this.getPropertiesAsync(context, snapshot, timeout, requestId, leaseAccessConditions, modifiedAccessConditions).blockingAwait();
    }

    public ServiceFuture<Void> getPropertiesAsync(Context context, String snapshot, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.getPropertiesAsync(context, snapshot, timeout, requestId, leaseAccessConditions, modifiedAccessConditions), serviceCallback);
    }

    public Single<BlobGetPropertiesResponse> getPropertiesWithRestResponseAsync(Context context, String snapshot, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        Validator.validate((Object)leaseAccessConditions);
        Validator.validate((Object)modifiedAccessConditions);
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.ifMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.ifNoneMatch();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.getProperties(context, this.client.url(), snapshot, timeout, this.client.version(), requestId, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch);
    }

    public Completable getPropertiesAsync(Context context, String snapshot, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        return this.getPropertiesWithRestResponseAsync(context, snapshot, timeout, requestId, leaseAccessConditions, modifiedAccessConditions).toCompletable();
    }

    public void delete(Context context, String snapshot, Integer timeout, DeleteSnapshotsOptionType deleteSnapshots, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        this.deleteAsync(context, snapshot, timeout, deleteSnapshots, requestId, leaseAccessConditions, modifiedAccessConditions).blockingAwait();
    }

    public ServiceFuture<Void> deleteAsync(Context context, String snapshot, Integer timeout, DeleteSnapshotsOptionType deleteSnapshots, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.deleteAsync(context, snapshot, timeout, deleteSnapshots, requestId, leaseAccessConditions, modifiedAccessConditions), serviceCallback);
    }

    public Single<BlobDeleteResponse> deleteWithRestResponseAsync(Context context, String snapshot, Integer timeout, DeleteSnapshotsOptionType deleteSnapshots, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        Validator.validate((Object)leaseAccessConditions);
        Validator.validate((Object)modifiedAccessConditions);
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.ifMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.ifNoneMatch();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.delete(context, this.client.url(), snapshot, timeout, deleteSnapshots, this.client.version(), requestId, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch);
    }

    public Completable deleteAsync(Context context, String snapshot, Integer timeout, DeleteSnapshotsOptionType deleteSnapshots, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        return this.deleteWithRestResponseAsync(context, snapshot, timeout, deleteSnapshots, requestId, leaseAccessConditions, modifiedAccessConditions).toCompletable();
    }

    public void undelete(Context context, Integer timeout, String requestId) {
        this.undeleteAsync(context, timeout, requestId).blockingAwait();
    }

    public ServiceFuture<Void> undeleteAsync(Context context, Integer timeout, String requestId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.undeleteAsync(context, timeout, requestId), serviceCallback);
    }

    public Single<BlobUndeleteResponse> undeleteWithRestResponseAsync(Context context, Integer timeout, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        return this.service.undelete(context, this.client.url(), timeout, this.client.version(), requestId, "undelete");
    }

    public Completable undeleteAsync(Context context, Integer timeout, String requestId) {
        return this.undeleteWithRestResponseAsync(context, timeout, requestId).toCompletable();
    }

    public void setHTTPHeaders(Context context, Integer timeout, String requestId, BlobHTTPHeaders blobHTTPHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        this.setHTTPHeadersAsync(context, timeout, requestId, blobHTTPHeaders, leaseAccessConditions, modifiedAccessConditions).blockingAwait();
    }

    public ServiceFuture<Void> setHTTPHeadersAsync(Context context, Integer timeout, String requestId, BlobHTTPHeaders blobHTTPHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.setHTTPHeadersAsync(context, timeout, requestId, blobHTTPHeaders, leaseAccessConditions, modifiedAccessConditions), serviceCallback);
    }

    public Single<BlobSetHTTPHeadersResponse> setHTTPHeadersWithRestResponseAsync(Context context, Integer timeout, String requestId, BlobHTTPHeaders blobHTTPHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        Validator.validate((Object)blobHTTPHeaders);
        Validator.validate((Object)leaseAccessConditions);
        Validator.validate((Object)modifiedAccessConditions);
        String blobCacheControl = null;
        if (blobHTTPHeaders != null) {
            blobCacheControl = blobHTTPHeaders.blobCacheControl();
        }
        String blobContentType = null;
        if (blobHTTPHeaders != null) {
            blobContentType = blobHTTPHeaders.blobContentType();
        }
        byte[] blobContentMD5 = null;
        if (blobHTTPHeaders != null) {
            blobContentMD5 = blobHTTPHeaders.blobContentMD5();
        }
        String blobContentEncoding = null;
        if (blobHTTPHeaders != null) {
            blobContentEncoding = blobHTTPHeaders.blobContentEncoding();
        }
        String blobContentLanguage = null;
        if (blobHTTPHeaders != null) {
            blobContentLanguage = blobHTTPHeaders.blobContentLanguage();
        }
        String blobContentDisposition = null;
        if (blobHTTPHeaders != null) {
            blobContentDisposition = blobHTTPHeaders.blobContentDisposition();
        }
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.ifMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.ifNoneMatch();
        }
        String blobContentMD5Converted = Base64Util.encodeToString((byte[])blobContentMD5);
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.setHTTPHeaders(context, this.client.url(), timeout, this.client.version(), requestId, "properties", blobCacheControl, blobContentType, blobContentMD5Converted, blobContentEncoding, blobContentLanguage, blobContentDisposition, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch);
    }

    public Completable setHTTPHeadersAsync(Context context, Integer timeout, String requestId, BlobHTTPHeaders blobHTTPHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        return this.setHTTPHeadersWithRestResponseAsync(context, timeout, requestId, blobHTTPHeaders, leaseAccessConditions, modifiedAccessConditions).toCompletable();
    }

    public void setMetadata(Context context, Integer timeout, Map<String, String> metadata, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        this.setMetadataAsync(context, timeout, metadata, requestId, leaseAccessConditions, modifiedAccessConditions).blockingAwait();
    }

    public ServiceFuture<Void> setMetadataAsync(Context context, Integer timeout, Map<String, String> metadata, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.setMetadataAsync(context, timeout, metadata, requestId, leaseAccessConditions, modifiedAccessConditions), serviceCallback);
    }

    public Single<BlobSetMetadataResponse> setMetadataWithRestResponseAsync(Context context, Integer timeout, Map<String, String> metadata, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        Validator.validate(metadata);
        Validator.validate((Object)leaseAccessConditions);
        Validator.validate((Object)modifiedAccessConditions);
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.ifMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.ifNoneMatch();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.setMetadata(context, this.client.url(), timeout, metadata, this.client.version(), requestId, "metadata", leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch);
    }

    public Completable setMetadataAsync(Context context, Integer timeout, Map<String, String> metadata, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        return this.setMetadataWithRestResponseAsync(context, timeout, metadata, requestId, leaseAccessConditions, modifiedAccessConditions).toCompletable();
    }

    public void acquireLease(Context context, Integer timeout, Integer duration, String proposedLeaseId, String requestId, ModifiedAccessConditions modifiedAccessConditions) {
        this.acquireLeaseAsync(context, timeout, duration, proposedLeaseId, requestId, modifiedAccessConditions).blockingAwait();
    }

    public ServiceFuture<Void> acquireLeaseAsync(Context context, Integer timeout, Integer duration, String proposedLeaseId, String requestId, ModifiedAccessConditions modifiedAccessConditions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.acquireLeaseAsync(context, timeout, duration, proposedLeaseId, requestId, modifiedAccessConditions), serviceCallback);
    }

    public Single<BlobAcquireLeaseResponse> acquireLeaseWithRestResponseAsync(Context context, Integer timeout, Integer duration, String proposedLeaseId, String requestId, ModifiedAccessConditions modifiedAccessConditions) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        Validator.validate((Object)modifiedAccessConditions);
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.ifMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.ifNoneMatch();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.acquireLease(context, this.client.url(), timeout, duration, proposedLeaseId, this.client.version(), requestId, "lease", "acquire", ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch);
    }

    public Completable acquireLeaseAsync(Context context, Integer timeout, Integer duration, String proposedLeaseId, String requestId, ModifiedAccessConditions modifiedAccessConditions) {
        return this.acquireLeaseWithRestResponseAsync(context, timeout, duration, proposedLeaseId, requestId, modifiedAccessConditions).toCompletable();
    }

    public void releaseLease(Context context, @NonNull String leaseId, Integer timeout, String requestId, ModifiedAccessConditions modifiedAccessConditions) {
        this.releaseLeaseAsync(context, leaseId, timeout, requestId, modifiedAccessConditions).blockingAwait();
    }

    public ServiceFuture<Void> releaseLeaseAsync(Context context, @NonNull String leaseId, Integer timeout, String requestId, ModifiedAccessConditions modifiedAccessConditions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.releaseLeaseAsync(context, leaseId, timeout, requestId, modifiedAccessConditions), serviceCallback);
    }

    public Single<BlobReleaseLeaseResponse> releaseLeaseWithRestResponseAsync(Context context, @NonNull String leaseId, Integer timeout, String requestId, ModifiedAccessConditions modifiedAccessConditions) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (leaseId == null) {
            throw new IllegalArgumentException("Parameter leaseId is required and cannot be null.");
        }
        Validator.validate((Object)modifiedAccessConditions);
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.ifMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.ifNoneMatch();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.releaseLease(context, this.client.url(), timeout, leaseId, this.client.version(), requestId, "lease", "release", ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch);
    }

    public Completable releaseLeaseAsync(Context context, @NonNull String leaseId, Integer timeout, String requestId, ModifiedAccessConditions modifiedAccessConditions) {
        return this.releaseLeaseWithRestResponseAsync(context, leaseId, timeout, requestId, modifiedAccessConditions).toCompletable();
    }

    public void renewLease(Context context, @NonNull String leaseId, Integer timeout, String requestId, ModifiedAccessConditions modifiedAccessConditions) {
        this.renewLeaseAsync(context, leaseId, timeout, requestId, modifiedAccessConditions).blockingAwait();
    }

    public ServiceFuture<Void> renewLeaseAsync(Context context, @NonNull String leaseId, Integer timeout, String requestId, ModifiedAccessConditions modifiedAccessConditions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.renewLeaseAsync(context, leaseId, timeout, requestId, modifiedAccessConditions), serviceCallback);
    }

    public Single<BlobRenewLeaseResponse> renewLeaseWithRestResponseAsync(Context context, @NonNull String leaseId, Integer timeout, String requestId, ModifiedAccessConditions modifiedAccessConditions) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (leaseId == null) {
            throw new IllegalArgumentException("Parameter leaseId is required and cannot be null.");
        }
        Validator.validate((Object)modifiedAccessConditions);
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.ifMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.ifNoneMatch();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.renewLease(context, this.client.url(), timeout, leaseId, this.client.version(), requestId, "lease", "renew", ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch);
    }

    public Completable renewLeaseAsync(Context context, @NonNull String leaseId, Integer timeout, String requestId, ModifiedAccessConditions modifiedAccessConditions) {
        return this.renewLeaseWithRestResponseAsync(context, leaseId, timeout, requestId, modifiedAccessConditions).toCompletable();
    }

    public void changeLease(Context context, @NonNull String leaseId, @NonNull String proposedLeaseId, Integer timeout, String requestId, ModifiedAccessConditions modifiedAccessConditions) {
        this.changeLeaseAsync(context, leaseId, proposedLeaseId, timeout, requestId, modifiedAccessConditions).blockingAwait();
    }

    public ServiceFuture<Void> changeLeaseAsync(Context context, @NonNull String leaseId, @NonNull String proposedLeaseId, Integer timeout, String requestId, ModifiedAccessConditions modifiedAccessConditions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.changeLeaseAsync(context, leaseId, proposedLeaseId, timeout, requestId, modifiedAccessConditions), serviceCallback);
    }

    public Single<BlobChangeLeaseResponse> changeLeaseWithRestResponseAsync(Context context, @NonNull String leaseId, @NonNull String proposedLeaseId, Integer timeout, String requestId, ModifiedAccessConditions modifiedAccessConditions) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (leaseId == null) {
            throw new IllegalArgumentException("Parameter leaseId is required and cannot be null.");
        }
        if (proposedLeaseId == null) {
            throw new IllegalArgumentException("Parameter proposedLeaseId is required and cannot be null.");
        }
        Validator.validate((Object)modifiedAccessConditions);
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.ifMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.ifNoneMatch();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.changeLease(context, this.client.url(), timeout, leaseId, proposedLeaseId, this.client.version(), requestId, "lease", "change", ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch);
    }

    public Completable changeLeaseAsync(Context context, @NonNull String leaseId, @NonNull String proposedLeaseId, Integer timeout, String requestId, ModifiedAccessConditions modifiedAccessConditions) {
        return this.changeLeaseWithRestResponseAsync(context, leaseId, proposedLeaseId, timeout, requestId, modifiedAccessConditions).toCompletable();
    }

    public void breakLease(Context context, Integer timeout, Integer breakPeriod, String requestId, ModifiedAccessConditions modifiedAccessConditions) {
        this.breakLeaseAsync(context, timeout, breakPeriod, requestId, modifiedAccessConditions).blockingAwait();
    }

    public ServiceFuture<Void> breakLeaseAsync(Context context, Integer timeout, Integer breakPeriod, String requestId, ModifiedAccessConditions modifiedAccessConditions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.breakLeaseAsync(context, timeout, breakPeriod, requestId, modifiedAccessConditions), serviceCallback);
    }

    public Single<BlobBreakLeaseResponse> breakLeaseWithRestResponseAsync(Context context, Integer timeout, Integer breakPeriod, String requestId, ModifiedAccessConditions modifiedAccessConditions) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        Validator.validate((Object)modifiedAccessConditions);
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.ifMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.ifNoneMatch();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.breakLease(context, this.client.url(), timeout, breakPeriod, this.client.version(), requestId, "lease", "break", ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch);
    }

    public Completable breakLeaseAsync(Context context, Integer timeout, Integer breakPeriod, String requestId, ModifiedAccessConditions modifiedAccessConditions) {
        return this.breakLeaseWithRestResponseAsync(context, timeout, breakPeriod, requestId, modifiedAccessConditions).toCompletable();
    }

    public void createSnapshot(Context context, Integer timeout, Map<String, String> metadata, String requestId, ModifiedAccessConditions modifiedAccessConditions, LeaseAccessConditions leaseAccessConditions) {
        this.createSnapshotAsync(context, timeout, metadata, requestId, modifiedAccessConditions, leaseAccessConditions).blockingAwait();
    }

    public ServiceFuture<Void> createSnapshotAsync(Context context, Integer timeout, Map<String, String> metadata, String requestId, ModifiedAccessConditions modifiedAccessConditions, LeaseAccessConditions leaseAccessConditions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.createSnapshotAsync(context, timeout, metadata, requestId, modifiedAccessConditions, leaseAccessConditions), serviceCallback);
    }

    public Single<BlobCreateSnapshotResponse> createSnapshotWithRestResponseAsync(Context context, Integer timeout, Map<String, String> metadata, String requestId, ModifiedAccessConditions modifiedAccessConditions, LeaseAccessConditions leaseAccessConditions) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        Validator.validate(metadata);
        Validator.validate((Object)modifiedAccessConditions);
        Validator.validate((Object)leaseAccessConditions);
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.ifMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.ifNoneMatch();
        }
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.createSnapshot(context, this.client.url(), timeout, metadata, this.client.version(), requestId, "snapshot", ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, leaseId);
    }

    public Completable createSnapshotAsync(Context context, Integer timeout, Map<String, String> metadata, String requestId, ModifiedAccessConditions modifiedAccessConditions, LeaseAccessConditions leaseAccessConditions) {
        return this.createSnapshotWithRestResponseAsync(context, timeout, metadata, requestId, modifiedAccessConditions, leaseAccessConditions).toCompletable();
    }

    public void startCopyFromURL(Context context, @NonNull URL copySource, Integer timeout, Map<String, String> metadata, String requestId, SourceModifiedAccessConditions sourceModifiedAccessConditions, ModifiedAccessConditions modifiedAccessConditions, LeaseAccessConditions leaseAccessConditions) {
        this.startCopyFromURLAsync(context, copySource, timeout, metadata, requestId, sourceModifiedAccessConditions, modifiedAccessConditions, leaseAccessConditions).blockingAwait();
    }

    public ServiceFuture<Void> startCopyFromURLAsync(Context context, @NonNull URL copySource, Integer timeout, Map<String, String> metadata, String requestId, SourceModifiedAccessConditions sourceModifiedAccessConditions, ModifiedAccessConditions modifiedAccessConditions, LeaseAccessConditions leaseAccessConditions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.startCopyFromURLAsync(context, copySource, timeout, metadata, requestId, sourceModifiedAccessConditions, modifiedAccessConditions, leaseAccessConditions), serviceCallback);
    }

    public Single<BlobStartCopyFromURLResponse> startCopyFromURLWithRestResponseAsync(Context context, @NonNull URL copySource, Integer timeout, Map<String, String> metadata, String requestId, SourceModifiedAccessConditions sourceModifiedAccessConditions, ModifiedAccessConditions modifiedAccessConditions, LeaseAccessConditions leaseAccessConditions) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (copySource == null) {
            throw new IllegalArgumentException("Parameter copySource is required and cannot be null.");
        }
        Validator.validate(metadata);
        Validator.validate((Object)copySource);
        Validator.validate((Object)sourceModifiedAccessConditions);
        Validator.validate((Object)modifiedAccessConditions);
        Validator.validate((Object)leaseAccessConditions);
        OffsetDateTime sourceIfModifiedSince = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfModifiedSince = sourceModifiedAccessConditions.sourceIfModifiedSince();
        }
        OffsetDateTime sourceIfUnmodifiedSince = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfUnmodifiedSince = sourceModifiedAccessConditions.sourceIfUnmodifiedSince();
        }
        String sourceIfMatch = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfMatch = sourceModifiedAccessConditions.sourceIfMatch();
        }
        String sourceIfNoneMatch = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfNoneMatch = sourceModifiedAccessConditions.sourceIfNoneMatch();
        }
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.ifMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.ifNoneMatch();
        }
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        DateTimeRfc1123 sourceIfModifiedSinceConverted = null;
        if (sourceIfModifiedSince != null) {
            sourceIfModifiedSinceConverted = new DateTimeRfc1123(sourceIfModifiedSince);
        }
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = null;
        if (sourceIfUnmodifiedSince != null) {
            sourceIfUnmodifiedSinceConverted = new DateTimeRfc1123(sourceIfUnmodifiedSince);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.startCopyFromURL(context, this.client.url(), timeout, metadata, copySource, this.client.version(), requestId, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, leaseId);
    }

    public Completable startCopyFromURLAsync(Context context, @NonNull URL copySource, Integer timeout, Map<String, String> metadata, String requestId, SourceModifiedAccessConditions sourceModifiedAccessConditions, ModifiedAccessConditions modifiedAccessConditions, LeaseAccessConditions leaseAccessConditions) {
        return this.startCopyFromURLWithRestResponseAsync(context, copySource, timeout, metadata, requestId, sourceModifiedAccessConditions, modifiedAccessConditions, leaseAccessConditions).toCompletable();
    }

    public void copyFromURL(Context context, @NonNull URL copySource, Integer timeout, Map<String, String> metadata, String requestId, SourceModifiedAccessConditions sourceModifiedAccessConditions, ModifiedAccessConditions modifiedAccessConditions, LeaseAccessConditions leaseAccessConditions) {
        this.copyFromURLAsync(context, copySource, timeout, metadata, requestId, sourceModifiedAccessConditions, modifiedAccessConditions, leaseAccessConditions).blockingAwait();
    }

    public ServiceFuture<Void> copyFromURLAsync(Context context, @NonNull URL copySource, Integer timeout, Map<String, String> metadata, String requestId, SourceModifiedAccessConditions sourceModifiedAccessConditions, ModifiedAccessConditions modifiedAccessConditions, LeaseAccessConditions leaseAccessConditions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.copyFromURLAsync(context, copySource, timeout, metadata, requestId, sourceModifiedAccessConditions, modifiedAccessConditions, leaseAccessConditions), serviceCallback);
    }

    public Single<BlobCopyFromURLResponse> copyFromURLWithRestResponseAsync(Context context, @NonNull URL copySource, Integer timeout, Map<String, String> metadata, String requestId, SourceModifiedAccessConditions sourceModifiedAccessConditions, ModifiedAccessConditions modifiedAccessConditions, LeaseAccessConditions leaseAccessConditions) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (copySource == null) {
            throw new IllegalArgumentException("Parameter copySource is required and cannot be null.");
        }
        Validator.validate(metadata);
        Validator.validate((Object)copySource);
        Validator.validate((Object)sourceModifiedAccessConditions);
        Validator.validate((Object)modifiedAccessConditions);
        Validator.validate((Object)leaseAccessConditions);
        OffsetDateTime sourceIfModifiedSince = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfModifiedSince = sourceModifiedAccessConditions.sourceIfModifiedSince();
        }
        OffsetDateTime sourceIfUnmodifiedSince = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfUnmodifiedSince = sourceModifiedAccessConditions.sourceIfUnmodifiedSince();
        }
        String sourceIfMatch = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfMatch = sourceModifiedAccessConditions.sourceIfMatch();
        }
        String sourceIfNoneMatch = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfNoneMatch = sourceModifiedAccessConditions.sourceIfNoneMatch();
        }
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.ifMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.ifNoneMatch();
        }
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        DateTimeRfc1123 sourceIfModifiedSinceConverted = null;
        if (sourceIfModifiedSince != null) {
            sourceIfModifiedSinceConverted = new DateTimeRfc1123(sourceIfModifiedSince);
        }
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = null;
        if (sourceIfUnmodifiedSince != null) {
            sourceIfUnmodifiedSinceConverted = new DateTimeRfc1123(sourceIfUnmodifiedSince);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.copyFromURL(context, this.client.url(), timeout, metadata, copySource, this.client.version(), requestId, "true", sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, leaseId);
    }

    public Completable copyFromURLAsync(Context context, @NonNull URL copySource, Integer timeout, Map<String, String> metadata, String requestId, SourceModifiedAccessConditions sourceModifiedAccessConditions, ModifiedAccessConditions modifiedAccessConditions, LeaseAccessConditions leaseAccessConditions) {
        return this.copyFromURLWithRestResponseAsync(context, copySource, timeout, metadata, requestId, sourceModifiedAccessConditions, modifiedAccessConditions, leaseAccessConditions).toCompletable();
    }

    public void abortCopyFromURL(Context context, @NonNull String copyId, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions) {
        this.abortCopyFromURLAsync(context, copyId, timeout, requestId, leaseAccessConditions).blockingAwait();
    }

    public ServiceFuture<Void> abortCopyFromURLAsync(Context context, @NonNull String copyId, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.abortCopyFromURLAsync(context, copyId, timeout, requestId, leaseAccessConditions), serviceCallback);
    }

    public Single<BlobAbortCopyFromURLResponse> abortCopyFromURLWithRestResponseAsync(Context context, @NonNull String copyId, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (copyId == null) {
            throw new IllegalArgumentException("Parameter copyId is required and cannot be null.");
        }
        Validator.validate((Object)leaseAccessConditions);
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        return this.service.abortCopyFromURL(context, this.client.url(), copyId, timeout, this.client.version(), requestId, "copy", "abort", leaseId);
    }

    public Completable abortCopyFromURLAsync(Context context, @NonNull String copyId, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions) {
        return this.abortCopyFromURLWithRestResponseAsync(context, copyId, timeout, requestId, leaseAccessConditions).toCompletable();
    }

    public void setTier(Context context, @NonNull AccessTier tier, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions) {
        this.setTierAsync(context, tier, timeout, requestId, leaseAccessConditions).blockingAwait();
    }

    public ServiceFuture<Void> setTierAsync(Context context, @NonNull AccessTier tier, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.setTierAsync(context, tier, timeout, requestId, leaseAccessConditions), serviceCallback);
    }

    public Single<BlobSetTierResponse> setTierWithRestResponseAsync(Context context, @NonNull AccessTier tier, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (tier == null) {
            throw new IllegalArgumentException("Parameter tier is required and cannot be null.");
        }
        Validator.validate((Object)leaseAccessConditions);
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        return this.service.setTier(context, this.client.url(), timeout, tier, this.client.version(), requestId, "tier", leaseId);
    }

    public Completable setTierAsync(Context context, @NonNull AccessTier tier, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions) {
        return this.setTierWithRestResponseAsync(context, tier, timeout, requestId, leaseAccessConditions).toCompletable();
    }

    public void getAccountInfo(Context context) {
        this.getAccountInfoAsync(context).blockingAwait();
    }

    public ServiceFuture<Void> getAccountInfoAsync(Context context, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.getAccountInfoAsync(context), serviceCallback);
    }

    public Single<BlobGetAccountInfoResponse> getAccountInfoWithRestResponseAsync(Context context) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        return this.service.getAccountInfo(context, this.client.url(), this.client.version(), "account", "properties");
    }

    public Completable getAccountInfoAsync(Context context) {
        return this.getAccountInfoWithRestResponseAsync(context).toCompletable();
    }

    @Host(value="{url}")
    private static interface BlobsService {
        @GET(value="{containerName}/{blob}")
        @ExpectedResponses(value={200, 206})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<BlobDownloadResponse> download(Context var1, @HostParam(value="url") String var2, @QueryParam(value="snapshot") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-range") String var5, @HeaderParam(value="x-ms-range-get-content-md5") Boolean var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @HeaderParam(value="x-ms-lease-id") String var9, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var10, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var11, @HeaderParam(value="If-Match") String var12, @HeaderParam(value="If-None-Match") String var13);

        @HEAD(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<BlobGetPropertiesResponse> getProperties(Context var1, @HostParam(value="url") String var2, @QueryParam(value="snapshot") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="If-None-Match") String var11);

        @DELETE(value="{containerName}/{blob}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<BlobDeleteResponse> delete(Context var1, @HostParam(value="url") String var2, @QueryParam(value="snapshot") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-delete-snapshots") DeleteSnapshotsOptionType var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var10, @HeaderParam(value="If-Match") String var11, @HeaderParam(value="If-None-Match") String var12);

        @PUT(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<BlobUndeleteResponse> undelete(Context var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @QueryParam(value="comp") String var6);

        @PUT(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<BlobSetHTTPHeadersResponse> setHTTPHeaders(Context var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @QueryParam(value="comp") String var6, @HeaderParam(value="x-ms-blob-cache-control") String var7, @HeaderParam(value="x-ms-blob-content-type") String var8, @HeaderParam(value="x-ms-blob-content-md5") String var9, @HeaderParam(value="x-ms-blob-content-encoding") String var10, @HeaderParam(value="x-ms-blob-content-language") String var11, @HeaderParam(value="x-ms-blob-content-disposition") String var12, @HeaderParam(value="x-ms-lease-id") String var13, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var14, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var15, @HeaderParam(value="If-Match") String var16, @HeaderParam(value="If-None-Match") String var17);

        @PUT(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<BlobSetMetadataResponse> setMetadata(Context var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-meta-") Map<String, String> var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="comp") String var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var10, @HeaderParam(value="If-Match") String var11, @HeaderParam(value="If-None-Match") String var12);

        @PUT(value="{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<BlobAcquireLeaseResponse> acquireLease(Context var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-lease-duration") Integer var4, @HeaderParam(value="x-ms-proposed-lease-id") String var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @QueryParam(value="comp") String var8, @HeaderParam(value="x-ms-lease-action") String var9, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var10, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var11, @HeaderParam(value="If-Match") String var12, @HeaderParam(value="If-None-Match") String var13);

        @PUT(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<BlobReleaseLeaseResponse> releaseLease(Context var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-lease-id") String var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="comp") String var7, @HeaderParam(value="x-ms-lease-action") String var8, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var10, @HeaderParam(value="If-Match") String var11, @HeaderParam(value="If-None-Match") String var12);

        @PUT(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<BlobRenewLeaseResponse> renewLease(Context var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-lease-id") String var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="comp") String var7, @HeaderParam(value="x-ms-lease-action") String var8, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var10, @HeaderParam(value="If-Match") String var11, @HeaderParam(value="If-None-Match") String var12);

        @PUT(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<BlobChangeLeaseResponse> changeLease(Context var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-lease-id") String var4, @HeaderParam(value="x-ms-proposed-lease-id") String var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @QueryParam(value="comp") String var8, @HeaderParam(value="x-ms-lease-action") String var9, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var10, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var11, @HeaderParam(value="If-Match") String var12, @HeaderParam(value="If-None-Match") String var13);

        @PUT(value="{containerName}/{blob}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<BlobBreakLeaseResponse> breakLease(Context var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-lease-break-period") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="comp") String var7, @HeaderParam(value="x-ms-lease-action") String var8, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var10, @HeaderParam(value="If-Match") String var11, @HeaderParam(value="If-None-Match") String var12);

        @PUT(value="{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<BlobCreateSnapshotResponse> createSnapshot(Context var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-meta-") Map<String, String> var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="comp") String var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="If-None-Match") String var11, @HeaderParam(value="x-ms-lease-id") String var12);

        @PUT(value="{containerName}/{blob}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<BlobStartCopyFromURLResponse> startCopyFromURL(Context var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-meta-") Map<String, String> var4, @HeaderParam(value="x-ms-copy-source") URL var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="x-ms-source-if-modified-since") DateTimeRfc1123 var8, @HeaderParam(value="x-ms-source-if-unmodified-since") DateTimeRfc1123 var9, @HeaderParam(value="x-ms-source-if-match") String var10, @HeaderParam(value="x-ms-source-if-none-match") String var11, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var13, @HeaderParam(value="If-Match") String var14, @HeaderParam(value="If-None-Match") String var15, @HeaderParam(value="x-ms-lease-id") String var16);

        @PUT(value="{containerName}/{blob}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<BlobCopyFromURLResponse> copyFromURL(Context var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-meta-") Map<String, String> var4, @HeaderParam(value="x-ms-copy-source") URL var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="x-ms-requires-sync") String var8, @HeaderParam(value="x-ms-source-if-modified-since") DateTimeRfc1123 var9, @HeaderParam(value="x-ms-source-if-unmodified-since") DateTimeRfc1123 var10, @HeaderParam(value="x-ms-source-if-match") String var11, @HeaderParam(value="x-ms-source-if-none-match") String var12, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var13, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var14, @HeaderParam(value="If-Match") String var15, @HeaderParam(value="If-None-Match") String var16, @HeaderParam(value="x-ms-lease-id") String var17);

        @PUT(value="{containerName}/{blob}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<BlobAbortCopyFromURLResponse> abortCopyFromURL(Context var1, @HostParam(value="url") String var2, @QueryParam(value="copyid") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="comp") String var7, @HeaderParam(value="x-ms-copy-action") String var8, @HeaderParam(value="x-ms-lease-id") String var9);

        @PUT(value="{containerName}/{blob}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<BlobSetTierResponse> setTier(Context var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-access-tier") AccessTier var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="comp") String var7, @HeaderParam(value="x-ms-lease-id") String var8);

        @GET(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<BlobGetAccountInfoResponse> getAccountInfo(Context var1, @HostParam(value="url") String var2, @HeaderParam(value="x-ms-version") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="comp") String var5);
    }
}

