/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

package com.microsoft.azure.storage.blob.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

/**
 * Key information.
 */
@JacksonXmlRootElement(localName = "KeyInfo")
public final class KeyInfo {
    /**
     * The date-time the key is active in ISO 8601 UTC time.
     */
    @JsonProperty(value = "Start", required = true)
    private String start;

    /**
     * The date-time the key expires in ISO 8601 UTC time.
     */
    @JsonProperty(value = "Expiry", required = true)
    private String expiry;

    /**
     * Get the start value.
     *
     * @return the start value.
     */
    public String start() {
        return this.start;
    }

    /**
     * Set the start value.
     *
     * @param start the start value to set.
     * @return the KeyInfo object itself.
     */
    public KeyInfo withStart(String start) {
        this.start = start;
        return this;
    }

    /**
     * Get the expiry value.
     *
     * @return the expiry value.
     */
    public String expiry() {
        return this.expiry;
    }

    /**
     * Set the expiry value.
     *
     * @param expiry the expiry value to set.
     * @return the KeyInfo object itself.
     */
    public KeyInfo withExpiry(String expiry) {
        this.expiry = expiry;
        return this;
    }
}
