/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

package com.microsoft.azure.storage.blob.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.Map;

/**
 * The BlobMetadata model.
 */
@JacksonXmlRootElement(localName = "Metadata")
public final class BlobMetadata {
    /**
     * Unmatched properties from the message are deserialized this collection.
     */
    @JsonProperty(value = "")
    private Map<String, String> additionalProperties;

    /**
     * The encrypted property.
     */
    @JacksonXmlProperty(localName = "Encrypted", isAttribute = true)
    private String encrypted;

    /**
     * Get the additionalProperties value.
     *
     * @return the additionalProperties value.
     */
    public Map<String, String> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties value.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the BlobMetadata object itself.
     */
    public BlobMetadata withAdditionalProperties(Map<String, String> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Get the encrypted value.
     *
     * @return the encrypted value.
     */
    public String encrypted() {
        return this.encrypted;
    }

    /**
     * Set the encrypted value.
     *
     * @param encrypted the encrypted value to set.
     * @return the BlobMetadata object itself.
     */
    public BlobMetadata withEncrypted(String encrypted) {
        this.encrypted = encrypted;
        return this;
    }
}
