/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

package com.microsoft.azure.storage.blob.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

/**
 * Additional parameters for a set of operations.
 */
@JacksonXmlRootElement(localName = "blob-HTTP-headers")
public final class BlobHTTPHeaders {
    /**
     * Optional. Sets the blob's cache control. If specified, this property is
     * stored with the blob and returned with a read request.
     */
    @JsonProperty(value = "BlobCacheControl")
    private String blobCacheControl;

    /**
     * Optional. Sets the blob's content type. If specified, this property is
     * stored with the blob and returned with a read request.
     */
    @JsonProperty(value = "BlobContentType")
    private String blobContentType;

    /**
     * Optional. An MD5 hash of the blob content. Note that this hash is not
     * validated, as the hashes for the individual blocks were validated when
     * each was uploaded.
     */
    @JsonProperty(value = "BlobContentMD5")
    private byte[] blobContentMD5;

    /**
     * Optional. Sets the blob's content encoding. If specified, this property
     * is stored with the blob and returned with a read request.
     */
    @JsonProperty(value = "BlobContentEncoding")
    private String blobContentEncoding;

    /**
     * Optional. Set the blob's content language. If specified, this property
     * is stored with the blob and returned with a read request.
     */
    @JsonProperty(value = "BlobContentLanguage")
    private String blobContentLanguage;

    /**
     * Optional. Sets the blob's Content-Disposition header.
     */
    @JsonProperty(value = "BlobContentDisposition")
    private String blobContentDisposition;

    /**
     * Get the blobCacheControl value.
     *
     * @return the blobCacheControl value.
     */
    public String blobCacheControl() {
        return this.blobCacheControl;
    }

    /**
     * Set the blobCacheControl value.
     *
     * @param blobCacheControl the blobCacheControl value to set.
     * @return the BlobHTTPHeaders object itself.
     */
    public BlobHTTPHeaders withBlobCacheControl(String blobCacheControl) {
        this.blobCacheControl = blobCacheControl;
        return this;
    }

    /**
     * Get the blobContentType value.
     *
     * @return the blobContentType value.
     */
    public String blobContentType() {
        return this.blobContentType;
    }

    /**
     * Set the blobContentType value.
     *
     * @param blobContentType the blobContentType value to set.
     * @return the BlobHTTPHeaders object itself.
     */
    public BlobHTTPHeaders withBlobContentType(String blobContentType) {
        this.blobContentType = blobContentType;
        return this;
    }

    /**
     * Get the blobContentMD5 value.
     *
     * @return the blobContentMD5 value.
     */
    public byte[] blobContentMD5() {
        return this.blobContentMD5;
    }

    /**
     * Set the blobContentMD5 value.
     *
     * @param blobContentMD5 the blobContentMD5 value to set.
     * @return the BlobHTTPHeaders object itself.
     */
    public BlobHTTPHeaders withBlobContentMD5(byte[] blobContentMD5) {
        this.blobContentMD5 = blobContentMD5;
        return this;
    }

    /**
     * Get the blobContentEncoding value.
     *
     * @return the blobContentEncoding value.
     */
    public String blobContentEncoding() {
        return this.blobContentEncoding;
    }

    /**
     * Set the blobContentEncoding value.
     *
     * @param blobContentEncoding the blobContentEncoding value to set.
     * @return the BlobHTTPHeaders object itself.
     */
    public BlobHTTPHeaders withBlobContentEncoding(String blobContentEncoding) {
        this.blobContentEncoding = blobContentEncoding;
        return this;
    }

    /**
     * Get the blobContentLanguage value.
     *
     * @return the blobContentLanguage value.
     */
    public String blobContentLanguage() {
        return this.blobContentLanguage;
    }

    /**
     * Set the blobContentLanguage value.
     *
     * @param blobContentLanguage the blobContentLanguage value to set.
     * @return the BlobHTTPHeaders object itself.
     */
    public BlobHTTPHeaders withBlobContentLanguage(String blobContentLanguage) {
        this.blobContentLanguage = blobContentLanguage;
        return this;
    }

    /**
     * Get the blobContentDisposition value.
     *
     * @return the blobContentDisposition value.
     */
    public String blobContentDisposition() {
        return this.blobContentDisposition;
    }

    /**
     * Set the blobContentDisposition value.
     *
     * @param blobContentDisposition the blobContentDisposition value to set.
     * @return the BlobHTTPHeaders object itself.
     */
    public BlobHTTPHeaders withBlobContentDisposition(String blobContentDisposition) {
        this.blobContentDisposition = blobContentDisposition;
        return this;
    }
}
