/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

package com.microsoft.azure.storage.blob.implementation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.microsoft.azure.storage.blob.models.SignedIdentifier;
import java.util.ArrayList;
import java.util.List;

/**
 * A wrapper around List&lt;SignedIdentifier&gt; which provides top-level metadata for serialization.
 */
@JacksonXmlRootElement(localName = "SignedIdentifier")
public final class SignedIdentifierWrapper {
    @JacksonXmlProperty(localName = "SignedIdentifier")
    private final List<SignedIdentifier> signedIdentifier;

    /**
     * Creates an instance of SignedIdentifierWrapper.
     *
     * @param signedIdentifier the list.
     */
    @JsonCreator
    public SignedIdentifierWrapper(@JsonProperty("SignedIdentifier") List<SignedIdentifier> signedIdentifier) {
        this.signedIdentifier = signedIdentifier;
    }

    /**
     * Get the List&lt;SignedIdentifier&gt; contained in this wrapper.
     *
     * @return the List&lt;SignedIdentifier&gt;.
     */
    public List<SignedIdentifier> items() {
        return signedIdentifier;
    }
}
