/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.pos;

import com.google.common.collect.Lists;
import com.mayabot.nlp.injector.Singleton;
import com.mayabot.nlp.segment.Nature;
import com.mayabot.nlp.segment.WordpathProcessor;
import com.mayabot.nlp.segment.common.BaseSegmentComponent;
import com.mayabot.nlp.segment.plugins.pos.PerceptronPosService;
import com.mayabot.nlp.segment.wordnet.Vertex;
import com.mayabot.nlp.segment.wordnet.Wordpath;
import java.util.ArrayList;
import java.util.List;

@Singleton
public class PosPerceptronProcessor
extends BaseSegmentComponent
implements WordpathProcessor {
    private final PerceptronPosService perceptronPosService;

    public PosPerceptronProcessor(PerceptronPosService perceptronPosService) {
        super(500);
        this.perceptronPosService = perceptronPosService;
    }

    @Override
    public Wordpath process(Wordpath wordPath) {
        ArrayList vertices = Lists.newArrayList(wordPath.iteratorVertex());
        List<Nature> posList = this.perceptronPosService.posFromVertex(vertices);
        for (int i = 0; i < vertices.size(); ++i) {
            Vertex vertex = (Vertex)vertices.get(i);
            if (vertex.nature != null && vertex.nature != Nature.newWord && vertex.nature != Nature.nr) continue;
            vertex.nature = posList.get(i);
        }
        return wordPath;
    }
}

