/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.ner;

import com.google.common.collect.Lists;
import com.mayabot.nlp.injector.Singleton;
import com.mayabot.nlp.segment.Nature;
import com.mayabot.nlp.segment.WordpathProcessor;
import com.mayabot.nlp.segment.common.BaseSegmentComponent;
import com.mayabot.nlp.segment.pipeline.PipelineLexerBuilder;
import com.mayabot.nlp.segment.pipeline.PipelineLexerPlugin;
import com.mayabot.nlp.segment.plugins.ner.PerceptronNerService;
import com.mayabot.nlp.segment.wordnet.Vertex;
import com.mayabot.nlp.segment.wordnet.Wordpath;
import java.util.ArrayList;
import java.util.List;

@Singleton
public class NerProcessor
extends BaseSegmentComponent
implements WordpathProcessor,
PipelineLexerPlugin {
    private final PerceptronNerService service;

    public NerProcessor(PerceptronNerService perceptronPosService) {
        super(1000);
        this.service = perceptronPosService;
    }

    @Override
    public void install(PipelineLexerBuilder pipelineLexerBuilder) {
        pipelineLexerBuilder.addProcessor(this);
    }

    @Override
    public Wordpath process(Wordpath wordPath) {
        ArrayList vertices = Lists.newArrayList(wordPath.iteratorVertex());
        List<String> tagS = this.service.getPerceptron().decodeVertexList(vertices);
        int from = -1;
        int length = 0;
        for (int i = 0; i < vertices.size(); ++i) {
            String tag = tagS.get(i);
            Vertex vertex = (Vertex)vertices.get(i);
            if ("O".equals(tag) || "S".equals(tag)) {
                from = -1;
                length = 0;
                continue;
            }
            if (tag.startsWith("B-")) {
                from = vertex.offset();
                length += vertex.length;
                continue;
            }
            if (tag.startsWith("M-")) {
                length += vertex.length;
                continue;
            }
            if (!tag.startsWith("E-")) continue;
            length += vertex.length;
            if (from != -1) {
                Vertex x = wordPath.combine(from, length);
                if ("E-nt".equals(tag)) {
                    x.nature = Nature.nt;
                }
                if ("E-ns".equals(tag)) {
                    x.nature = Nature.ns;
                }
            }
            from = -1;
            length = 0;
        }
        return wordPath;
    }
}

