/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.customwords;

import com.mayabot.nlp.collection.dat.DoubleArrayTrieStringIntMap;
import com.mayabot.nlp.segment.plugins.customwords.CustomDictionary;
import java.util.TreeMap;

public class MemCustomDictionary
implements CustomDictionary {
    private TreeMap<String, Integer> dict;
    private DoubleArrayTrieStringIntMap trie;

    public MemCustomDictionary() {
        this.dict = new TreeMap();
        this.rebuild();
    }

    public MemCustomDictionary(TreeMap<String, Integer> dict) {
        this.dict = dict;
        this.rebuild();
    }

    public void rebuild() {
        if (this.dict.isEmpty()) {
            this.trie = null;
            return;
        }
        this.trie = new DoubleArrayTrieStringIntMap(this.dict);
    }

    public void addWord(String word) {
        this.dict.put(word, 1000);
    }

    public void removeWord(String word) {
        this.dict.remove(word);
    }

    @Override
    public DoubleArrayTrieStringIntMap getTrie() {
        return this.trie;
    }
}

