/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mayabot.nlp.segment.WordTerm;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;

public final class Sentence
implements Iterable<WordTerm> {
    private List<WordTerm> words;

    public static Sentence of() {
        return new Sentence();
    }

    public static Sentence of(List<WordTerm> words) {
        return new Sentence(words);
    }

    public static Sentence of(Iterable<WordTerm> words) {
        return new Sentence(words);
    }

    private Sentence(List<WordTerm> words) {
        this.words = words;
    }

    private Sentence(Iterable<WordTerm> words) {
        this.words = Lists.newArrayList(words);
    }

    private Sentence() {
        this.words = ImmutableList.of();
    }

    public String toPlainString() {
        return Joiner.on((char)' ').join(this.toWordList());
    }

    public String pkuFormat() {
        return this.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int size = this.words.size();
        int last = size - 1;
        for (int i = 0; i < size; ++i) {
            WordTerm term = this.words.get(i);
            if (term.hasSubword()) {
                sb.append("[");
                sb.append(new Sentence(term.getSubword()).toString());
                sb.append("]");
                if (term.getNature() != null) {
                    sb.append("/");
                    sb.append((Object)term.getNature());
                }
                sb.append(" ");
                continue;
            }
            sb.append(term.word);
            if (term.getNature() != null) {
                sb.append("/");
                sb.append((Object)term.getNature());
            }
            if (i >= last) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    @NotNull
    public List<String> toWordList() {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)this.words.size());
        for (WordTerm w : this.words) {
            list.add(w.word);
        }
        return list;
    }

    public List<WordTerm> toList() {
        return this.words;
    }

    public Stream<WordTerm> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    @NotNull
    public Iterator<WordTerm> iterator() {
        return this.words.iterator();
    }
}

