/*
 * Decompiled with CFR 0.152.
 */
package com.iblotus;

import com.iblotus.ContentDecoder;
import com.iblotus.DefaultTaobaoApiMethod;
import com.iblotus.TaobaoApiMethod;
import java.util.HashMap;
import java.util.Map;

public class TaobaoApiConfig {
    private String url;
    private String appKey;
    private String secret;
    private final String signMethod = "hmac";
    private final String version = "2.0";
    private final String resultFormat = "json";
    private Map<String, ContentDecoder> decoderMap = new HashMap<String, ContentDecoder>();

    public TaobaoApiConfig(String url, String appKey, String secret) {
        this.url = url;
        this.appKey = appKey;
        this.secret = secret;
    }

    public String getUrl() {
        return this.url;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getSecret() {
        return this.secret;
    }

    public void addDecoder(String methodName, ContentDecoder decoder) {
        this.decoderMap.put(methodName, decoder);
    }

    public ContentDecoder getDecoder(String methodName) {
        return this.decoderMap.get(methodName);
    }

    public String getSignMethod() {
        return "hmac";
    }

    public String getVersion() {
        return "2.0";
    }

    public String getResultFormat() {
        return "json";
    }

    public TaobaoApiMethod createMethod(String methodName) {
        return new DefaultTaobaoApiMethod(methodName, this);
    }
}

