/*
 * Decompiled with CFR 0.152.
 */
package com.iblotus;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.iblotus.ContentDecoder;
import com.iblotus.TaobaoApiException;
import com.iblotus.TaobaoApiResult;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonTaobaoApiResult
implements TaobaoApiResult {
    private final String rawString;
    private ContentDecoder resultDecoder;

    public JsonTaobaoApiResult(String rawString, ContentDecoder resultDecoder) {
        this.rawString = rawString;
        this.resultDecoder = resultDecoder;
    }

    public JsonTaobaoApiResult(String rawString) {
        this(rawString, null);
    }

    public String toString() {
        return this.rawString;
    }

    @Override
    public <T> T getObject(ContentDecoder<T> decoder) {
        TaobaoApiException exception = this.getException();
        if (exception != null) {
            throw exception;
        }
        return decoder.decode(this.rawString);
    }

    @Override
    public Object getObject() {
        if (this.resultDecoder == null) {
            throw new RuntimeException("\u672a\u8bbe\u7f6e\u89e3\u7801\u5668");
        }
        return this.getObject(this.resultDecoder);
    }

    @Override
    public TaobaoApiException getException() {
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode = null;
        try {
            jsonNode = objectMapper.readTree(this.rawString);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        JsonNode errNode = jsonNode.findValue("error_response");
        if (errNode != null) {
            String code = errNode.get("code").asText();
            String msg = errNode.get("msg").asText();
            String requestId = errNode.get("request_id").asText();
            return new TaobaoApiException(code, msg, requestId);
        }
        return null;
    }
}

