/*
 * Decompiled with CFR 0.152.
 */
package com.iblotus;

import com.iblotus.ApiSignMethod;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HmacApiSignMethod
implements ApiSignMethod {
    private final String secret;
    private static final String CHARSET = "UTF-8";

    public HmacApiSignMethod(String secret) {
        this.secret = secret;
    }

    @Override
    public String sign(Map<String, String> params) {
        Object[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder query = new StringBuilder();
        for (Object key : keys) {
            String value = params.get(key);
            if (!HmacApiSignMethod.areNotEmpty((String)key, value)) continue;
            query.append((String)key).append(value);
        }
        byte[] bytes = this.encryptHMAC(query.toString());
        return HmacApiSignMethod.byte2hex(bytes);
    }

    private byte[] encryptHMAC(String data) {
        byte[] bytes = null;
        try {
            SecretKeySpec secretKey = new SecretKeySpec(this.secret.getBytes(CHARSET), "HmacMD5");
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            bytes = mac.doFinal(data.getBytes(CHARSET));
        }
        catch (GeneralSecurityException gse) {
            throw new RuntimeException(gse);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return bytes;
    }

    private static boolean areNotEmpty(String key, String value) {
        if (key == null || key.equals("")) {
            return false;
        }
        return value != null && !value.equals("");
    }

    private static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toUpperCase());
        }
        return sign.toString();
    }
}

