/*
 * Decompiled with CFR 0.152.
 */
package com.iblotus;

import com.iblotus.ApiParam;
import com.iblotus.ApiSignMethod;
import com.iblotus.HmacApiSignMethod;
import com.iblotus.JsonTaobaoApiResult;
import com.iblotus.TaobaoApiConfig;
import com.iblotus.TaobaoApiMethod;
import com.iblotus.TaobaoApiResult;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultTaobaoApiMethod
implements TaobaoApiMethod {
    private String accessToken;
    private String methodName;
    private Map<String, ApiParam> params = new HashMap<String, ApiParam>();
    private TaobaoApiConfig config;
    private static final String charset = "UTF-8";

    public DefaultTaobaoApiMethod(String methodName, TaobaoApiConfig config) {
        this.methodName = methodName;
        this.config = config;
    }

    @Override
    public TaobaoApiMethod setParam(String name, ApiParam value) {
        this.params.put(name, value);
        return this;
    }

    @Override
    public TaobaoApiMethod setAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @Override
    public TaobaoApiResult call() throws IOException {
        String accessToken = this.accessToken;
        Map<String, String> paramss = this.toApiParams();
        paramss.put("v", this.config.getVersion());
        paramss.put("app_key", this.config.getAppKey());
        if (accessToken != null && !accessToken.equals("")) {
            paramss.put("session", accessToken);
        }
        paramss.put("sign_method", this.config.getSignMethod());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        paramss.put("timestamp", formatter.format(new Date()));
        paramss.put("format", this.config.getResultFormat());
        paramss.put("method", this.methodName);
        paramss.put("sign", this.getSignMethod().sign(paramss));
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost post = new HttpPost(this.config.getUrl());
        post.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : paramss.entrySet()) {
            pairs.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        StringEntity stringEntity = new StringEntity(URLEncodedUtils.format(pairs, (String)charset), charset);
        post.setEntity((HttpEntity)stringEntity);
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)post);
        String result = this.readString(response.getEntity().getContent());
        return new JsonTaobaoApiResult(result, this.config.getDecoder(this.methodName));
    }

    private ApiSignMethod getSignMethod() {
        return new HmacApiSignMethod(this.config.getSecret());
    }

    private Map<String, String> toApiParams() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, ApiParam> entry : this.params.entrySet()) {
            map.put(entry.getKey(), entry.getValue().format());
        }
        return map;
    }

    private String readString(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString(charset);
    }
}

