/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.impl;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.BufferObjectDataOutput;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.partition.MigrationEndpoint;
import com.hazelcast.partition.MigrationInfo;
import com.hazelcast.partition.impl.BaseMigrationOperation;
import com.hazelcast.partition.impl.InternalPartitionImpl;
import com.hazelcast.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.partition.impl.MigrationOperation;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.NonThreadSafe;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.spi.ServiceInfo;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.util.executor.ManagedExecutorService;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public final class MigrationRequestOperation
extends BaseMigrationOperation {
    private static final int TRY_PAUSE_MILLIS = 1000;
    private static final int DEFAULT_DATA_OUTPUT_BUFFER_SIZE = 32768;
    private boolean returnResponse = true;

    public MigrationRequestOperation() {
    }

    public MigrationRequestOperation(MigrationInfo migrationInfo) {
        super(migrationInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        NodeEngine nodeEngine = this.getNodeEngine();
        this.verifyGoodMaster(nodeEngine);
        Address source = this.migrationInfo.getSource();
        Address destination = this.migrationInfo.getDestination();
        this.verifyExistingTarget(nodeEngine, destination);
        if (destination.equals(source)) {
            this.getLogger().warning("Source and destination addresses are the same! => " + this.toString());
            this.success = false;
            return;
        }
        this.verifyNotThisNode(nodeEngine, source);
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        InternalPartitionImpl partition = partitionService.getPartition(this.migrationInfo.getPartitionId());
        Address owner = partition.getOwnerOrNull();
        this.verifyOwnerExists(owner);
        if (!this.migrationInfo.startProcessing()) {
            this.getLogger().warning("Migration is cancelled -> " + this.migrationInfo);
            this.success = false;
            return;
        }
        try {
            this.verifyOwner(source, partition, owner);
            partitionService.addActiveMigration(this.migrationInfo);
            long[] replicaVersions = partitionService.getPartitionReplicaVersions(this.migrationInfo.getPartitionId());
            Collection<Operation> tasks = this.prepareMigrationTasks();
            if (tasks.size() > 0) {
                this.returnResponse = false;
                this.spawnMigrationRequestTask(destination, replicaVersions, tasks);
            } else {
                this.success = true;
            }
        }
        catch (Throwable e) {
            this.getLogger().warning(e);
            this.success = false;
        }
        finally {
            this.migrationInfo.doneProcessing();
        }
    }

    private void verifyNotThisNode(NodeEngine nodeEngine, Address source) {
        if (source == null || !source.equals(nodeEngine.getThisAddress())) {
            throw new RetryableHazelcastException("Source of migration is not this node! => " + this.toString());
        }
    }

    private void verifyOwnerExists(Address owner) {
        if (owner == null) {
            throw new RetryableHazelcastException("Cannot migrate at the moment! Owner of the partition is null => " + this.migrationInfo);
        }
    }

    private void verifyOwner(Address source, InternalPartition partition, Address owner) {
        if (!source.equals(owner)) {
            throw new HazelcastException("Cannot migrate! This node is not owner of the partition => " + this.migrationInfo + " -> " + partition);
        }
    }

    private void spawnMigrationRequestTask(Address destination, long[] replicaVersions, Collection<Operation> tasks) throws IOException {
        NodeEngine nodeEngine = this.getNodeEngine();
        SerializationService serializationService = nodeEngine.getSerializationService();
        BufferObjectDataOutput out = this.createDataOutput(serializationService);
        out.writeInt(tasks.size());
        Iterator<Operation> iter = tasks.iterator();
        while (iter.hasNext()) {
            Operation task = iter.next();
            if (!(task instanceof NonThreadSafe)) continue;
            serializationService.writeObject(out, task);
            iter.remove();
        }
        ManagedExecutorService executor = nodeEngine.getExecutionService().getExecutor("hz:async");
        MigrationRequestTask task = new MigrationRequestTask(tasks, out, replicaVersions, destination);
        executor.execute(task);
    }

    private BufferObjectDataOutput createDataOutput(SerializationService serializationService) {
        return serializationService.createObjectDataOutput(32768);
    }

    private void verifyGoodMaster(NodeEngine nodeEngine) {
        Address masterAddress = nodeEngine.getMasterAddress();
        if (!masterAddress.equals(this.migrationInfo.getMaster())) {
            throw new RetryableHazelcastException("Migration initiator is not master node! => " + this.toString());
        }
        if (!masterAddress.equals(this.getCallerAddress())) {
            throw new RetryableHazelcastException("Caller is not master node! => " + this.toString());
        }
    }

    private void verifyExistingTarget(NodeEngine nodeEngine, Address destination) {
        MemberImpl target = nodeEngine.getClusterService().getMember(destination);
        if (target == null) {
            throw new TargetNotMemberException("Destination of migration could not be found! => " + this.toString());
        }
    }

    @Override
    public ExceptionAction onException(Throwable throwable) {
        boolean rethrowException;
        if (throwable instanceof TargetNotMemberException && (rethrowException = this.rethrowException())) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onException(throwable);
    }

    private boolean rethrowException() {
        NodeEngine nodeEngine = this.getNodeEngine();
        if (nodeEngine == null) {
            return false;
        }
        MemberImpl destination = nodeEngine.getClusterService().getMember(this.migrationInfo.getDestination());
        return destination == null;
    }

    @Override
    public Object getResponse() {
        return this.success;
    }

    @Override
    public boolean returnsResponse() {
        return this.returnResponse;
    }

    private Collection<Operation> prepareMigrationTasks() {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        PartitionReplicationEvent replicationEvent = new PartitionReplicationEvent(this.migrationInfo.getPartitionId(), 0);
        PartitionMigrationEvent migrationEvent = new PartitionMigrationEvent(MigrationEndpoint.SOURCE, this.migrationInfo.getPartitionId());
        LinkedList<Operation> tasks = new LinkedList<Operation>();
        for (ServiceInfo serviceInfo : nodeEngine.getServiceInfos(MigrationAwareService.class)) {
            MigrationAwareService service = (MigrationAwareService)serviceInfo.getService();
            service.beforeMigration(migrationEvent);
            Operation op = service.prepareReplicationOperation(replicationEvent);
            if (op == null) continue;
            op.setServiceName(serviceInfo.getName());
            tasks.add(op);
        }
        return tasks;
    }

    private class MigrationRequestTask
    implements Runnable {
        private final SerializationService serializationService;
        private final Collection<Operation> tasks;
        private final BufferObjectDataOutput out;
        private final long[] replicaVersions;
        private final Address destination;
        private final long timeout;
        private final ResponseHandler responseHandler;
        private final boolean compress;

        public MigrationRequestTask(Collection<Operation> tasks, BufferObjectDataOutput out, long[] replicaVersions, Address destination) {
            this.tasks = tasks;
            this.out = out;
            this.replicaVersions = replicaVersions;
            this.destination = destination;
            this.responseHandler = MigrationRequestOperation.this.getResponseHandler();
            NodeEngine nodeEngine = MigrationRequestOperation.this.getNodeEngine();
            this.serializationService = nodeEngine.getSerializationService();
            this.compress = nodeEngine.getGroupProperties().PARTITION_MIGRATION_ZIP_ENABLED.getBoolean();
            this.timeout = nodeEngine.getGroupProperties().PARTITION_MIGRATION_TIMEOUT.getLong();
        }

        @Override
        public void run() {
            NodeEngine nodeEngine = MigrationRequestOperation.this.getNodeEngine();
            try {
                byte[] data = this.getTaskData();
                MigrationOperation operation = new MigrationOperation(MigrationRequestOperation.this.migrationInfo, this.replicaVersions, data, this.compress);
                InternalCompletableFuture future = nodeEngine.getOperationService().createInvocationBuilder("hz:core:partitionService", (Operation)operation, this.destination).setTryPauseMillis(1000L).setReplicaIndex(MigrationRequestOperation.this.getReplicaIndex()).invoke();
                Object response = future.get(this.timeout, TimeUnit.SECONDS);
                Boolean result = (Boolean)nodeEngine.toObject(response);
                MigrationRequestOperation.this.migrationInfo.doneProcessing();
                this.responseHandler.sendResponse(result);
            }
            catch (Throwable e) {
                this.responseHandler.sendResponse(Boolean.FALSE);
                this.logThrowable(e);
            }
        }

        private void logThrowable(Throwable t) {
            Throwable throwableToLog = t;
            if (throwableToLog instanceof ExecutionException) {
                throwableToLog = throwableToLog.getCause() != null ? throwableToLog.getCause() : throwableToLog;
            }
            Level level = this.getLogLevel(throwableToLog);
            MigrationRequestOperation.this.getLogger().log(level, throwableToLog.getMessage(), throwableToLog);
        }

        private Level getLogLevel(Throwable e) {
            return e instanceof MemberLeftException || e instanceof InterruptedException || !MigrationRequestOperation.this.getNodeEngine().isActive() ? Level.INFO : Level.WARNING;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] getTaskData() throws IOException {
            try {
                byte[] byArray;
                for (Operation task : this.tasks) {
                    this.serializationService.writeObject(this.out, task);
                }
                if (this.compress) {
                    byArray = IOUtil.compress(this.out.toByteArray());
                    return byArray;
                }
                byArray = this.out.toByteArray();
                return byArray;
            }
            finally {
                IOUtil.closeResource(this.out);
            }
        }
    }
}

