/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization.serializers;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

public class LinkedListSerializerHook
implements SerializerHook<LinkedList> {
    @Override
    public Class<LinkedList> getSerializationType() {
        return LinkedList.class;
    }

    @Override
    public Serializer createSerializer() {
        return new LinkedListStreamSerializer();
    }

    @Override
    public boolean isOverwritable() {
        return true;
    }

    public static class LinkedListStreamSerializer
    implements StreamSerializer<LinkedList> {
        @Override
        public void write(ObjectDataOutput out, LinkedList object) throws IOException {
            out.writeBoolean(object != null);
            if (object != null) {
                int size = object.size();
                out.writeInt(size);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    out.writeObject(iterator.next());
                }
            }
        }

        @Override
        public LinkedList read(ObjectDataInput in) throws IOException {
            if (in.readBoolean()) {
                int size = in.readInt();
                LinkedList result = new LinkedList();
                for (int i = 0; i < size; ++i) {
                    result.add(i, in.readObject());
                }
                return result;
            }
            return null;
        }

        @Override
        public int getTypeId() {
            return -103;
        }

        @Override
        public void destroy() {
        }
    }
}

