/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.mapstore.writebehind;

import com.hazelcast.cluster.ClusterService;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapServiceContext;
import com.hazelcast.map.PartitionContainer;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.mapstore.writebehind.DelayedEntry;
import com.hazelcast.map.mapstore.writebehind.WriteBehindProcessor;
import com.hazelcast.map.mapstore.writebehind.WriteBehindQueue;
import com.hazelcast.map.mapstore.writebehind.WriteBehindStore;
import com.hazelcast.nio.Address;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class StoreWorker
implements Runnable {
    private final String mapName;
    private final MapServiceContext mapServiceContext;
    private final WriteBehindProcessor writeBehindProcessor;
    private final long backupRunIntervalTime;
    private long lastRunTime;

    public StoreWorker(MapContainer mapContainer, WriteBehindProcessor writeBehindProcessor) {
        this.mapName = mapContainer.getName();
        this.mapServiceContext = mapContainer.getMapServiceContext();
        this.writeBehindProcessor = writeBehindProcessor;
        this.backupRunIntervalTime = this.getReplicaWaitTime();
        this.lastRunTime = Clock.currentTimeMillis();
    }

    private long getReplicaWaitTime() {
        return TimeUnit.SECONDS.toMillis(this.mapServiceContext.getNodeEngine().getGroupProperties().MAP_REPLICA_SCHEDULED_TASK_DELAY_SECONDS.getInteger());
    }

    @Override
    public void run() {
        long now = Clock.currentTimeMillis();
        MapServiceContext mapServiceContext = this.mapServiceContext;
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        ClusterService clusterService = nodeEngine.getClusterService();
        InternalPartitionService partitionService = nodeEngine.getPartitionService();
        Address thisAddress = clusterService.getThisAddress();
        int partitionCount = partitionService.getPartitionCount();
        Map<Integer, Integer> partitionToEntryCountHolder = Collections.emptyMap();
        List<DelayedEntry> entries = Collections.emptyList();
        boolean createLazy = true;
        for (int partitionId = 0; partitionId < partitionCount; ++partitionId) {
            WriteBehindQueue<DelayedEntry> queue;
            List<DelayedEntry> delayedEntries;
            InternalPartition partition = partitionService.getPartition(partitionId, false);
            Address owner = partition.getOwnerOrNull();
            RecordStore recordStore = this.getRecordStoreOrNull(this.mapName, partitionId);
            if (owner == null || recordStore == null || (delayedEntries = StoreWorker.filterItemsLessThanOrEqualToTime(queue = this.getWriteBehindQueue(recordStore), now)).isEmpty()) continue;
            if (!owner.equals(thisAddress)) {
                if (now >= this.lastRunTime + this.backupRunIntervalTime) continue;
                this.doInBackup(queue, delayedEntries, partitionId);
                continue;
            }
            if (createLazy) {
                partitionToEntryCountHolder = new HashMap();
                entries = new ArrayList<DelayedEntry>();
                createLazy = false;
            }
            partitionToEntryCountHolder.put(partitionId, delayedEntries.size());
            entries.addAll(delayedEntries);
        }
        if (!entries.isEmpty()) {
            Map<Integer, List<DelayedEntry>> failsPerPartition = this.writeBehindProcessor.process(entries);
            this.removeProcessed(this.mapName, this.getEntryPerPartitionMap(entries));
            this.addFailsToQueue(this.mapName, failsPerPartition);
            this.lastRunTime = now;
        }
    }

    private void removeProcessed(String mapName, Map<Integer, List<DelayedEntry>> entryListPerPartition) {
        for (Map.Entry<Integer, List<DelayedEntry>> entry : entryListPerPartition.entrySet()) {
            int partitionId = entry.getKey();
            RecordStore recordStore = this.getRecordStoreOrNull(mapName, partitionId);
            if (recordStore == null) continue;
            WriteBehindQueue<DelayedEntry> queue = this.getWriteBehindQueue(recordStore);
            List<DelayedEntry> entries = entry.getValue();
            queue.removeAll(entries);
        }
    }

    private Map<Integer, List<DelayedEntry>> getEntryPerPartitionMap(List<DelayedEntry> entries) {
        HashMap<Integer, List<DelayedEntry>> entryListPerPartition = new HashMap<Integer, List<DelayedEntry>>();
        for (DelayedEntry entry : entries) {
            int partitionId = entry.getPartitionId();
            ArrayList<DelayedEntry> delayedEntries = (ArrayList<DelayedEntry>)entryListPerPartition.get(partitionId);
            if (delayedEntries == null) {
                delayedEntries = new ArrayList<DelayedEntry>();
                entryListPerPartition.put(partitionId, delayedEntries);
            }
            delayedEntries.add(entry);
        }
        return entryListPerPartition;
    }

    private void doInBackup(WriteBehindQueue queue, List<DelayedEntry> delayedEntries, int partitionId) {
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        ClusterService clusterService = nodeEngine.getClusterService();
        InternalPartitionService partitionService = nodeEngine.getPartitionService();
        Address thisAddress = clusterService.getThisAddress();
        InternalPartition partition = partitionService.getPartition(partitionId, false);
        Address owner = partition.getOwnerOrNull();
        if (owner != null && !owner.equals(thisAddress)) {
            this.writeBehindProcessor.callBeforeStoreListeners(delayedEntries);
            this.removeProcessed(this.mapName, this.getEntryPerPartitionMap(delayedEntries));
            this.writeBehindProcessor.callAfterStoreListeners(delayedEntries);
        }
    }

    private RecordStore getRecordStoreOrNull(String mapName, int partitionId) {
        PartitionContainer partitionContainer = this.mapServiceContext.getPartitionContainer(partitionId);
        return partitionContainer.getExistingRecordStore(mapName);
    }

    private void addFailsToQueue(String mapName, Map<Integer, List<DelayedEntry>> failsPerPartition) {
        if (failsPerPartition.isEmpty()) {
            return;
        }
        for (Map.Entry<Integer, List<DelayedEntry>> entry : failsPerPartition.entrySet()) {
            RecordStore recordStore;
            Integer partitionId = entry.getKey();
            List<DelayedEntry> fails = failsPerPartition.get(partitionId);
            if (fails == null || fails.isEmpty() || (recordStore = this.getRecordStoreOrNull(mapName, partitionId)) == null) continue;
            WriteBehindQueue<DelayedEntry> queue = this.getWriteBehindQueue(recordStore);
            queue.addFront(fails);
        }
    }

    private static List<DelayedEntry> filterItemsLessThanOrEqualToTime(WriteBehindQueue<DelayedEntry> queue, long now) {
        if (queue == null || queue.size() == 0) {
            return Collections.emptyList();
        }
        return queue.filterItems(now);
    }

    private WriteBehindQueue<DelayedEntry> getWriteBehindQueue(RecordStore recordStore) {
        WriteBehindStore storeManager = (WriteBehindStore)recordStore.getMapDataStore();
        return storeManager.getWriteBehindQueue();
    }
}

