/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.AbstractClusterOperation;
import com.hazelcast.cluster.ClusterServiceImpl;
import com.hazelcast.cluster.MemberAttributeOperationType;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;

public class MemberAttributeChangedOperation
extends AbstractClusterOperation {
    private MemberAttributeOperationType operationType;
    private String key;
    private Object value;

    public MemberAttributeChangedOperation() {
    }

    public MemberAttributeChangedOperation(MemberAttributeOperationType operationType, String key, Object value) {
        this.operationType = operationType;
        this.key = key;
        this.value = value;
    }

    @Override
    public void run() throws Exception {
        ClusterServiceImpl cs = (ClusterServiceImpl)this.getService();
        cs.updateMemberAttribute(this.getCallerUuid(), this.operationType, this.key, this.value);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.key);
        out.writeByte(this.operationType.getId());
        if (this.operationType == MemberAttributeOperationType.PUT) {
            out.writeObject(this.value);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.key = in.readUTF();
        this.operationType = MemberAttributeOperationType.getValue(in.readByte());
        if (this.operationType == MemberAttributeOperationType.PUT) {
            this.value = in.readObject();
        }
    }
}

