/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.block.factory.primitive.IntPredicates;
import com.gs.collections.impl.factory.primitive.IntSets;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import com.gs.collections.impl.utility.internal.primitive.IntIterableIterate;
import com.gs.collections.impl.utility.primitive.LazyIntIterate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLazyIntIterable
implements LazyIntIterable {
    public int size() {
        return this.count(IntPredicates.alwaysTrue());
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public boolean isEmpty() {
        return IntIterableIterate.isEmpty((IntIterable)this);
    }

    public boolean notEmpty() {
        return IntIterableIterate.notEmpty((IntIterable)this);
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        IntIterableIterate.appendString((IntIterable)this, appendable, start, separator, end);
    }

    public boolean contains(int value) {
        return this.anySatisfy(IntPredicates.equal(value));
    }

    public boolean containsAll(int ... source) {
        return this.containsAll((IntIterable)IntSets.immutable.of(source));
    }

    public boolean containsAll(IntIterable source) {
        return source.allSatisfy(new IntPredicate(){

            public boolean accept(int value) {
                return AbstractLazyIntIterable.this.contains(value);
            }
        });
    }

    public LazyIntIterable select(IntPredicate predicate) {
        return LazyIntIterate.select((IntIterable)this, predicate);
    }

    public LazyIntIterable reject(IntPredicate predicate) {
        return LazyIntIterate.select((IntIterable)this, IntPredicates.not(predicate));
    }

    public <V> LazyIterable<V> collect(IntToObjectFunction<? extends V> function) {
        return LazyIntIterate.collect((IntIterable)this, function);
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return IntIterableIterate.detectIfNone((IntIterable)this, predicate, ifNone);
    }

    public int count(IntPredicate predicate) {
        return IntIterableIterate.count((IntIterable)this, predicate);
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return IntIterableIterate.anySatisfy((IntIterable)this, predicate);
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return IntIterableIterate.allSatisfy((IntIterable)this, predicate);
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return IntIterableIterate.noneSatisfy((IntIterable)this, predicate);
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return IntIterableIterate.injectInto((IntIterable)this, injectedValue, function);
    }

    public long sum() {
        return IntIterableIterate.sum((IntIterable)this);
    }

    public int max() {
        return IntIterableIterate.max((IntIterable)this);
    }

    public int maxIfEmpty(int ifEmpty) {
        return IntIterableIterate.maxIfEmpty((IntIterable)this, ifEmpty);
    }

    public int min() {
        return IntIterableIterate.min((IntIterable)this);
    }

    public int minIfEmpty(int ifEmpty) {
        return IntIterableIterate.minIfEmpty((IntIterable)this, ifEmpty);
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        int[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            int first = sortedArray[middleIndex];
            int second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public int[] toSortedArray() {
        return this.toSortedList().toArray();
    }

    public MutableIntList toSortedList() {
        return IntArrayList.newList((IntIterable)this).sortThis();
    }

    public int[] toArray() {
        return this.toList().toArray();
    }

    public MutableIntList toList() {
        final IntArrayList list = new IntArrayList();
        this.forEach(new IntProcedure(){

            public void value(int each) {
                list.add(each);
            }
        });
        return list;
    }

    public MutableIntSet toSet() {
        final IntHashSet set = new IntHashSet();
        this.forEach(new IntProcedure(){

            public void value(int each) {
                set.add(each);
            }
        });
        return set;
    }

    public MutableIntBag toBag() {
        final IntHashBag bag = new IntHashBag();
        this.forEach(new IntProcedure(){

            public void value(int each) {
                bag.add(each);
            }
        });
        return bag;
    }

    public LazyIntIterable asLazy() {
        return this;
    }
}

