/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.list.immutable.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.factory.list.primitive.ImmutableLongListFactory;
import com.gs.collections.api.list.primitive.ImmutableLongList;

/**
 * ImmutableLongListFactoryImpl is a factory implementation which creates instances of type {@link ImmutableLongList}.
 * This file was automatically generated from template file immutablePrimitiveListFactoryImpl.stg.
 *
 * @since 3.2.
 */
public class ImmutableLongListFactoryImpl implements ImmutableLongListFactory
{
    public ImmutableLongList of()
    {
        return this.with();
    }

    public ImmutableLongList with()
    {
        return ImmutableLongEmptyList.INSTANCE;
    }

    public ImmutableLongList of(long one)
    {
        return this.with(one);
    }

    public ImmutableLongList with(long one)
    {
        return new ImmutableLongSingletonList(one);
    }

    public ImmutableLongList of(long... items)
    {
        return this.with(items);
    }

    public ImmutableLongList with(long... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ImmutableLongArrayList.newListWith(items);
    }

    public ImmutableLongList ofAll(LongIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableLongList withAll(LongIterable items)
    {
        if (items instanceof ImmutableLongList)
        {
            return (ImmutableLongList) items;
        }
        return this.with(items.toArray());
    }
}
